/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Setter;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public abstract class ParserSession
extends BeanSession {
    private final boolean trimStrings;
    private final boolean strict;
    private final String inputStreamCharset;
    private final String fileCharset;
    private final Method javaMethod;
    private final Object outer;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private final ParserListener listener;

    protected ParserSession(ParserContext ctx, ParserSessionArgs args) {
        super(ctx != null ? ctx : ParserContext.DEFAULT, args);
        Class listenerClass;
        ObjectMap p;
        if (ctx == null) {
            ctx = ParserContext.DEFAULT;
        }
        if ((p = this.getProperties()).isEmpty()) {
            this.trimStrings = ctx.trimStrings;
            this.strict = ctx.strict;
            this.inputStreamCharset = ctx.inputStreamCharset;
            this.fileCharset = ctx.fileCharset;
            listenerClass = ctx.listener;
        } else {
            this.trimStrings = p.getBoolean("Parser.trimStrings", ctx.trimStrings);
            this.strict = p.getBoolean("Parser.strict", ctx.strict);
            this.inputStreamCharset = p.getString("Parser.inputStreamCharset", ctx.inputStreamCharset);
            this.fileCharset = p.getString("Parser.fileCharset", ctx.fileCharset);
            listenerClass = p.getWithDefault("PARSER.listener", ctx.listener, Class.class);
        }
        this.javaMethod = args.javaMethod;
        this.outer = args.outer;
        this.listener = ClassUtils.newInstance(ParserListener.class, listenerClass, new Object[0]);
    }

    protected abstract <T> T doParse(ParserPipe var1, ClassMeta<T> var2) throws Exception;

    public abstract boolean isReaderParser();

    public final ParserPipe createPipe(Object input) {
        return new ParserPipe(input, this.isDebug(), this.strict, this.fileCharset, this.inputStreamCharset);
    }

    public final ObjectMap getLastLocation() {
        ObjectMap m = new ObjectMap();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass.toString(true));
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        return m;
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final Object getOuter() {
        return this.outer;
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    protected final boolean isStrict() {
        return this.strict;
    }

    protected final <K> K trim(K o) {
        if (this.trimStrings && o instanceof String) {
            return (K)o.toString().trim();
        }
        return o;
    }

    protected final String trim(String s) {
        if (this.trimStrings && s != null) {
            return s.trim();
        }
        return s;
    }

    protected final Object cast(ObjectMap m, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        String btpn = this.getBeanTypePropertyName(eType);
        Object o = m.get(btpn);
        if (o == null) {
            return m;
        }
        String typeName = o.toString();
        ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
        if (cm != null) {
            BeanMap<?> bm = m.getBeanSession().newBeanMap(cm.getInnerClass());
            for (Map.Entry<String, Object> e : m.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                if (k.equals(btpn)) continue;
                if (v instanceof ObjectMap) {
                    v = this.cast((ObjectMap)v, pMeta, eType);
                }
                bm.put(k, v);
            }
            return bm.getBean();
        }
        return m;
    }

    protected final ClassMeta<?> getClassMeta(String typeName, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        BeanRegistry br = null;
        if (pMeta != null && (br = pMeta.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        if (eType != null && (br = eType.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        return this.getBeanRegistry().getClassMeta(typeName);
    }

    protected final <T> void onUnknownProperty(ParserPipe pipe, String propertyName, BeanMap<T> beanMap, int line, int col) throws ParseException {
        if (propertyName.equals(this.getBeanTypePropertyName(beanMap.getClassMeta()))) {
            return;
        }
        if (!this.isIgnoreUnknownBeanProperties()) {
            throw new ParseException(this.getLastLocation(), "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", propertyName, beanMap.getClassMeta());
        }
        if (this.listener != null) {
            this.listener.onUnknownBeanProperty(this, pipe, propertyName, beanMap.getClassMeta().getInnerClass(), beanMap.getBean(), line, col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            Object t = this.parseInner(pipe, this.getClassMeta(type, args));
            return t;
        }
        finally {
            pipe.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, Class<T> type) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            T t = this.parseInner(pipe, this.getClassMeta(type));
            return t;
        }
        finally {
            pipe.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            T t = this.parseInner(pipe, type);
            return t;
        }
        finally {
            pipe.close();
        }
    }

    private <T> T parseInner(ParserPipe pipe, ClassMeta<T> type) throws ParseException {
        try {
            if (type.isVoid()) {
                return null;
            }
            return this.doParse(pipe, type);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(this.getLastLocation(), "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(this.getLastLocation(), "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        catch (Exception e) {
            throw new ParseException(this.getLastLocation(), "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            Map<K, V> map = this.doParseIntoMap(pipe, m, keyType, valueType);
            return map;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(this.getLastLocation(), e);
        }
        finally {
            pipe.close();
        }
    }

    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            Collection<E> collection = this.doParseIntoCollection(pipe, c, elementType);
            return collection;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(this.getLastLocation(), "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(this.getLastLocation(), "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        catch (Exception e) {
            throw new ParseException(this.getLastLocation(), "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        finally {
            pipe.close();
        }
    }

    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        ParserPipe pipe = this.createPipe(input);
        try {
            Object[] objectArray = this.doParse(pipe, this.getArgsClassMeta(argTypes));
            return objectArray;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(this.getLastLocation(), "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(this.getLastLocation(), "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        catch (Exception e) {
            throw new ParseException(this.getLastLocation(), "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        finally {
            pipe.close();
        }
    }

    protected final <T> T convertAttrToType(Object outer, String s, ClassMeta<T> type) throws Exception {
        PojoSwap<T, Object> swap;
        if (s == null) {
            return null;
        }
        if (type == null) {
            type = this.object();
        }
        ClassMeta<Object> sType = (swap = type.getPojoSwap(this)) == null ? type : swap.getSwapClassMeta(this);
        Object o = s;
        if (sType.isChar()) {
            o = Character.valueOf(s.charAt(0));
        } else if (sType.isNumber()) {
            o = type.canCreateNewInstanceFromNumber(outer) ? type.newInstanceFromNumber(this, outer, StringUtils.parseNumber(s, type.getNewInstanceFromNumberClass())) : StringUtils.parseNumber(s, sType.getInnerClass());
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(s);
        } else if (!sType.isCharSequence() && !sType.isObject()) {
            if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, s);
            } else {
                throw new ParseException(this.getLastLocation(), "Invalid conversion from string to class ''{0}''", type);
            }
        }
        if (swap != null) {
            o = swap.unswap(this, o, type);
        }
        return (T)o;
    }

    protected static final void setParent(ClassMeta<?> cm, Object o, Object parent) throws Exception {
        Setter m = cm.getParentProperty();
        if (m != null) {
            m.set(o, parent);
        }
    }

    protected static final void setName(ClassMeta<?> cm, Object o, Object name) throws Exception {
        Setter m;
        if (cm != null && (m = cm.getNameProperty()) != null) {
            m.set(o, name);
        }
    }
}

