/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.json.JsonSerializerContext;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;

public class JsonSerializer
extends WriterSerializer {
    public static final JsonSerializer DEFAULT = new JsonSerializer(PropertyStore.create());
    public static final JsonSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX = new Simple(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX_READABLE = new SimpleReadable(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX_READABLE_SAFE = new SimpleReadableSafe(PropertyStore.create());
    final JsonSerializerContext ctx = this.createContext(JsonSerializerContext.class);
    private volatile JsonSchemaSerializer schemaSerializer;

    public JsonSerializer(PropertyStore propertyStore) {
        this(propertyStore, "application/json", "application/json", "application/json+*", "text/json", "text/json+*");
    }

    public JsonSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore, produces, accept);
    }

    @Override
    public JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder(this.propertyStore);
    }

    public JsonSchemaSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new JsonSchemaSerializer(this.propertyStore);
        }
        return this.schemaSerializer;
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new JsonSerializerSession(this.ctx, args);
    }

    public static class SimpleReadableSafe
    extends JsonSerializer {
        public SimpleReadableSafe(PropertyStore propertyStore) {
            super(propertyStore.copy().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true).append("Serializer.detectRecursions", true));
        }
    }

    public static class SimpleReadable
    extends JsonSerializer {
        public SimpleReadable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true));
        }
    }

    public static class Simple
    extends JsonSerializer {
        public Simple(PropertyStore propertyStore) {
            super(propertyStore.copy().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\'')), "application/json", "application/json+simple", "application/json+simple+*", "text/json+simple", "text/json+simple+*");
        }
    }

    public static class Readable
    extends JsonSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.useWhitespace", true));
        }
    }
}

