/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.BeanSession;
import org.apache.juneau.Writable;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.ConfigFileVar;
import org.apache.juneau.ini.ConfigFileWrapped;
import org.apache.juneau.ini.ConfigFileWritable;
import org.apache.juneau.ini.ConfigUtils;
import org.apache.juneau.ini.Encoder;
import org.apache.juneau.ini.Section;
import org.apache.juneau.ini.XorEncoder;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.svl.vars.EnvVariablesVar;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.SwitchVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;

public final class ConfigFileImpl
extends ConfigFile {
    private final File file;
    private final Encoder encoder;
    private final WriterSerializer serializer;
    private final ReaderParser parser;
    private final BeanSession pBeanSession;
    private final Charset charset;
    final List<ConfigFileListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<String, Section> sections;
    private static final String DEFAULT = "default";
    private final boolean readOnly;
    volatile boolean hasBeenModified = false;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    long modifiedTimestamp;

    public ConfigFileImpl(File file, boolean readOnly, Encoder encoder, WriterSerializer serializer, ReaderParser parser, Charset charset) throws IOException {
        this.file = file;
        this.encoder = encoder == null ? XorEncoder.INSTANCE : encoder;
        this.serializer = serializer == null ? JsonSerializer.DEFAULT : serializer;
        this.parser = parser == null ? JsonParser.DEFAULT : parser;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.load();
        this.readOnly = readOnly;
        if (readOnly) {
            this.sections = Collections.unmodifiableMap(this.sections);
            for (Section s : this.sections.values()) {
                s.setReadOnly();
            }
        }
        this.pBeanSession = this.parser.getBeanContext().createSession();
    }

    public ConfigFileImpl(File file) throws IOException {
        this(file, false, null, null, null, null);
    }

    public ConfigFileImpl() throws IOException {
        this(null);
    }

    @Override
    public ConfigFileImpl loadIfModified() throws IOException {
        if (this.file == null) {
            return this;
        }
        this.writeLock();
        try {
            if (this.file.lastModified() > this.modifiedTimestamp) {
                this.load();
            }
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    @Override
    public ConfigFileImpl load() throws IOException {
        Reader r = null;
        r = this.file != null && this.file.exists() ? new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset) : new StringReader("");
        try {
            this.load(r);
        }
        finally {
            ((Reader)r).close();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFileImpl load(Reader r) throws IOException {
        ThrowableUtils.assertFieldNotNull(r, "r");
        this.writeLock();
        try {
            this.sections = Collections.synchronizedMap(new LinkedHashMap());
            BufferedReader in = new BufferedReader(r);
            try {
                this.writeLock();
                this.hasBeenModified = false;
                try {
                    this.sections.clear();
                    String line = null;
                    Section section = this.getSection(null, true);
                    ArrayList<String> lines = new ArrayList<String>();
                    boolean canAppend = false;
                    while ((line = in.readLine()) != null) {
                        char c;
                        if (ConfigUtils.isSection(line)) {
                            section.addLines(null, lines.toArray(new String[lines.size()]));
                            lines.clear();
                            canAppend = false;
                            String sn = StringUtils.replaceUnicodeSequences(line.substring(line.indexOf(91) + 1, line.indexOf(93)).trim());
                            section = this.getSection(sn, true).addHeaderComments(section.removeTrailingComments());
                            continue;
                        }
                        char c2 = c = line.isEmpty() ? (char)'\u0000' : line.charAt(0);
                        if (!(c != ' ' && c != '\t' || !canAppend || ConfigUtils.isComment(line) || ConfigUtils.isAssignment(line))) {
                            lines.add((String)lines.remove(lines.size() - 1) + '\n' + line.substring(1));
                            continue;
                        }
                        lines.add(line);
                        if (ConfigUtils.isAssignment(line)) {
                            canAppend = true;
                            continue;
                        }
                        canAppend = canAppend && !StringUtils.isEmpty(line) && !ConfigUtils.isComment(line);
                    }
                    section.addLines(null, lines.toArray(new String[lines.size()]));
                    in.close();
                    if (this.hasBeenModified) {
                        this.save();
                    }
                    if (this.file != null) {
                        this.modifiedTimestamp = this.file.lastModified();
                    }
                }
                finally {
                    this.writeUnlock();
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            this.writeUnlock();
        }
        for (ConfigFileListener l : this.listeners) {
            l.onLoad(this);
        }
        return this;
    }

    @Override
    protected String serialize(Object value, Serializer serializer, boolean newline) throws SerializeException {
        Class<?> c;
        if (value == null) {
            return "";
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        if (ConfigFileImpl.isSimpleType(c = value.getClass())) {
            return value.toString();
        }
        String r = null;
        r = newline ? "\n" + (String)serializer.serialize(value) : (String)serializer.serialize(value);
        if (r.startsWith("'")) {
            return r.substring(1, r.length() - 1);
        }
        return r;
    }

    @Override
    protected <T> T parse(String s, Parser parser, Type type, Type ... args) throws ParseException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        if (ConfigFileImpl.isSimpleType(type)) {
            return this.pBeanSession.convertToType((Object)s, (Class)type);
        }
        char s1 = StringUtils.firstNonWhitespaceChar(s);
        if (ConfigFileImpl.isArray(type) && s1 != '[') {
            s = '[' + s + ']';
        } else if (s1 != '[' && s1 != '{' && !"null".equals(s)) {
            s = '\'' + s + '\'';
        }
        if (parser == null) {
            parser = this.parser;
        }
        return parser.parse(s, type, args);
    }

    private static boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }

    private static boolean isArray(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c.isArray();
    }

    @Override
    public Section get(Object key) {
        if (StringUtils.isEmpty(key)) {
            key = DEFAULT;
        }
        this.readLock();
        try {
            Section section = this.sections.get(key);
            return section;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Section put(String key, Section section) {
        Set<String> changes = this.createChanges();
        Section old = this.put(key, section, changes);
        this.signalChanges(changes);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Section put(String key, Section section, Set<String> changes) {
        if (StringUtils.isEmpty(key)) {
            key = DEFAULT;
        }
        this.writeLock();
        try {
            Section prev = this.sections.put(key, section);
            ConfigFileImpl.findChanges(changes, prev, section);
            Section section2 = prev;
            return section2;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends String, ? extends Section> map) {
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            for (Map.Entry<? extends String, ? extends Section> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue(), changes);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            for (Section s : this.values()) {
                ConfigFileImpl.findChanges(changes, s, null);
            }
            this.sections.clear();
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
    }

    @Override
    public boolean containsKey(Object key) {
        if (StringUtils.isEmpty(key)) {
            key = DEFAULT;
        }
        return this.sections.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sections.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return new AbstractSet<Map.Entry<String, Section>>(){

            @Override
            public Iterator<Map.Entry<String, Section>> iterator() {
                return new Iterator<Map.Entry<String, Section>>(){
                    Iterator<Map.Entry<String, Section>> i;
                    Map.Entry<String, Section> i2;
                    {
                        this.i = ConfigFileImpl.this.sections.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Section> next() {
                        this.i2 = this.i.next();
                        return this.i2;
                    }

                    @Override
                    public void remove() {
                        Set changes = ConfigFileImpl.this.createChanges();
                        ConfigFileImpl.findChanges(changes, this.i2.getValue(), null);
                        this.i.remove();
                        ConfigFileImpl.this.signalChanges(changes);
                    }
                };
            }

            @Override
            public int size() {
                return ConfigFileImpl.this.sections.size();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.sections.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    Iterator<String> i;
                    String i2;
                    {
                        this.i = ConfigFileImpl.this.sections.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public String next() {
                        this.i2 = this.i.next();
                        return this.i2;
                    }

                    @Override
                    public void remove() {
                        Set changes = ConfigFileImpl.this.createChanges();
                        ConfigFileImpl.findChanges(changes, (Section)ConfigFileImpl.this.sections.get(this.i2), null);
                        this.i.remove();
                        ConfigFileImpl.this.signalChanges(changes);
                    }
                };
            }

            @Override
            public int size() {
                return ConfigFileImpl.this.sections.size();
            }
        };
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public Collection<Section> values() {
        return new AbstractCollection<Section>(){

            @Override
            public Iterator<Section> iterator() {
                return new Iterator<Section>(){
                    Iterator<Section> i;
                    Section i2;
                    {
                        this.i = ConfigFileImpl.this.sections.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Section next() {
                        this.i2 = this.i.next();
                        return this.i2;
                    }

                    @Override
                    public void remove() {
                        Set changes = ConfigFileImpl.this.createChanges();
                        ConfigFileImpl.findChanges(changes, this.i2, null);
                        this.i.remove();
                        ConfigFileImpl.this.signalChanges(changes);
                    }
                };
            }

            @Override
            public int size() {
                return ConfigFileImpl.this.sections.size();
            }
        };
    }

    @Override
    public Section remove(Object key) {
        Set<String> changes = this.createChanges();
        Section prev = this.remove(key, changes);
        this.signalChanges(changes);
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Section remove(Object key, Set<String> changes) {
        this.writeLock();
        try {
            Section prev = this.sections.remove(key);
            ConfigFileImpl.findChanges(changes, prev, null);
            Section section = prev;
            return section;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public String get(String sectionName, String sectionKey) {
        ThrowableUtils.assertFieldNotNull(sectionKey, "sectionKey");
        Section s = this.get(sectionName);
        if (s == null) {
            return null;
        }
        String s2 = s.get(sectionKey);
        return s2 == null ? null : s2.toString();
    }

    @Override
    public String put(String sectionName, String sectionKey, Object value, Serializer serializer, boolean encoded, boolean newline) throws SerializeException {
        ThrowableUtils.assertFieldNotNull(sectionKey, "sectionKey");
        Section s = this.getSection(sectionName, true);
        return s.put(sectionKey, this.serialize(value, serializer, newline), encoded);
    }

    @Override
    public String put(String sectionName, String sectionKey, String value, boolean encoded) {
        ThrowableUtils.assertFieldNotNull(sectionKey, "sectionKey");
        Section s = this.getSection(sectionName, true);
        return s.put(sectionKey, value, encoded);
    }

    @Override
    public String remove(String sectionName, String sectionKey) {
        ThrowableUtils.assertFieldNotNull(sectionKey, "sectionKey");
        Section s = this.getSection(sectionName, false);
        if (s == null) {
            return null;
        }
        return s.remove(sectionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFileImpl addLines(String section, String ... lines) {
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            this.getSection(section, true).addLines(changes, lines);
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
        return this;
    }

    @Override
    public ConfigFileImpl addHeaderComments(String section, String ... headerComments) {
        this.writeLock();
        try {
            if (headerComments == null) {
                headerComments = new String[]{};
            }
            this.getSection(section, true).addHeaderComments(Arrays.asList(headerComments));
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    @Override
    public ConfigFileImpl clearHeaderComments(String section) {
        this.writeLock();
        try {
            Section s = this.getSection(section, false);
            if (s != null) {
                s.clearHeaderComments();
            }
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    @Override
    public Section getSection(String name) {
        return this.getSection(name, false);
    }

    @Override
    public Section getSection(String name, boolean create) {
        Section s;
        if (StringUtils.isEmpty(name)) {
            name = DEFAULT;
        }
        if ((s = this.sections.get(name)) != null) {
            return s;
        }
        if (create) {
            s = new Section().setParent(this).setName(name);
            this.sections.put(name, s);
            return s;
        }
        return null;
    }

    @Override
    public ConfigFileImpl addSection(String name) {
        this.writeLock();
        try {
            this.getSection(name, true);
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    @Override
    public ConfigFile setSection(String name, Map<String, String> contents) {
        this.writeLock();
        try {
            this.put(name, new Section(contents).setParent(this).setName(name));
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFileImpl removeSection(String name) {
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            Section prev = this.sections.remove(name);
            if (changes != null && prev != null) {
                ConfigFileImpl.findChanges(changes, prev, null);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
        return this;
    }

    @Override
    public Set<String> getSectionKeys(String sectionName) {
        Section s = this.get(sectionName);
        if (s == null) {
            return null;
        }
        return s.keySet();
    }

    @Override
    public boolean isEncoded(String key) {
        ThrowableUtils.assertFieldNotNull(key, "key");
        String section = ConfigUtils.getSectionName(key);
        Section s = this.getSection(section, false);
        if (s == null) {
            return false;
        }
        return s.isEncoded(ConfigUtils.getSectionKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFileImpl save() throws IOException {
        this.writeLock();
        try {
            if (this.file == null) {
                throw new UnsupportedOperationException("No backing file specified for config file.");
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.charset);
            try {
                this.serializeTo(out);
                this.hasBeenModified = false;
                this.modifiedTimestamp = this.file.lastModified();
            }
            finally {
                ((Writer)out).close();
            }
            for (ConfigFileListener l : this.listeners) {
                l.onSave(this);
            }
            ConfigFileImpl configFileImpl = this;
            return configFileImpl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFileImpl serializeTo(Writer out, ConfigFileFormat format) throws IOException {
        this.readLock();
        try {
            PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            for (Section s : this.sections.values()) {
                s.writeTo(pw, format);
            }
            pw.flush();
            pw.close();
            out.close();
        }
        finally {
            this.readUnlock();
        }
        return this;
    }

    void setHasBeenModified() {
        this.hasBeenModified = true;
    }

    @Override
    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            this.toWritable().writeTo(sw);
            return sw.toString();
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    @Override
    public ConfigFile addListener(ConfigFileListener listener) {
        ThrowableUtils.assertFieldNotNull(listener, "listener");
        this.writeLock();
        try {
            this.listeners.add(listener);
            ConfigFileImpl configFileImpl = this;
            return configFileImpl;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<ConfigFileListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Writable toWritable() {
        return new ConfigFileWritable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFile merge(ConfigFile cf) {
        ThrowableUtils.assertFieldNotNull(cf, "cf");
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            for (String string : this.keySet()) {
                if (cf.containsKey(string)) continue;
                this.remove((Object)string, changes);
            }
            for (Map.Entry entry : cf.entrySet()) {
                this.put((String)entry.getKey(), (Section)entry.getValue(), changes);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
        return this;
    }

    Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    protected BeanSession getBeanSession() {
        return this.pBeanSession;
    }

    @Override
    protected void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify read-only ConfigFile.");
        }
        this.lock.writeLock().lock();
        this.hasBeenModified = true;
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public ConfigFile getResolving(VarResolver vr) {
        ThrowableUtils.assertFieldNotNull(vr, "vr");
        return new ConfigFileWrapped(this, vr);
    }

    @Override
    public ConfigFile getResolving(VarResolverSession vs) {
        ThrowableUtils.assertFieldNotNull(vs, "vs");
        return new ConfigFileWrapped(this, vs);
    }

    @Override
    public ConfigFile getResolving() {
        return this.getResolving(new VarResolverBuilder().vars(SystemPropertiesVar.class, EnvVariablesVar.class, SwitchVar.class, IfVar.class, ConfigFileVar.class, IfVar.class, SwitchVar.class).contextObject("config", this).build());
    }

    private static void findChanges(Set<String> s, Section a, Section b) {
        String sname;
        if (s == null) {
            return;
        }
        String string = sname = a == null ? b.name : a.name;
        if (a == null) {
            for (String k : b.keySet()) {
                s.add(ConfigUtils.getFullKey(sname, k));
            }
        } else if (b == null) {
            for (String k : a.keySet()) {
                s.add(ConfigUtils.getFullKey(sname, k));
            }
        } else {
            for (String k : a.keySet()) {
                ConfigFileImpl.addChange(s, sname, k, a.get(k), b.get(k));
            }
            for (String k : b.keySet()) {
                ConfigFileImpl.addChange(s, sname, k, a.get(k), b.get(k));
            }
        }
    }

    private static void addChange(Set<String> changes, String section, String key, String oldVal, String newVal) {
        if (!StringUtils.isEquals(oldVal, newVal)) {
            changes.add(ConfigUtils.getFullKey(section, key));
        }
    }

    private Set<String> createChanges() {
        return this.listeners.size() > 0 ? new LinkedHashSet() : null;
    }

    private void signalChanges(Set<String> changes) {
        if (changes != null && !changes.isEmpty()) {
            for (ConfigFileListener l : this.listeners) {
                l.onChange(this, changes);
            }
        }
    }
}

