/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.XmlWriter;

public class HtmlWriter
extends XmlWriter {
    public HtmlWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver, false, null);
    }

    public HtmlWriter attrUri(String name, Object value) throws IOException {
        super.attrUri((String)null, name, value);
        return this;
    }

    @Override
    public HtmlWriter text(Object o, boolean preserveWhitespace) throws IOException {
        if (o == null) {
            this.append("<null/>");
            return this;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            this.append("<sp/>");
            return this;
        }
        for (int i = 0; i < s.length(); ++i) {
            char test = s.charAt(i);
            if (test == '&') {
                this.append("&amp;");
                continue;
            }
            if (test == '<') {
                this.append("&lt;");
                continue;
            }
            if (test == '>') {
                this.append("&gt;");
                continue;
            }
            if (test == '\n') {
                this.append(preserveWhitespace ? "\n" : "<br/>");
                continue;
            }
            if (test == '\f') {
                this.append(preserveWhitespace ? "\f" : "<ff/>");
                continue;
            }
            if (test == '\b') {
                this.append(preserveWhitespace ? "\b" : "<bs/>");
                continue;
            }
            if (test == '\t') {
                this.append(preserveWhitespace ? "\t" : "<sp>&#x2003;</sp>");
                continue;
            }
            if ((i == 0 || i == s.length() - 1) && Character.isWhitespace(test)) {
                if (preserveWhitespace) {
                    this.append(test);
                    continue;
                }
                if (test == ' ') {
                    this.append("<sp> </sp>");
                    continue;
                }
                this.append("<sp>&#x").append(StringUtils.toHex(test)).append(";</sp>");
                continue;
            }
            if (Character.isISOControl(test)) {
                this.append("&#" + test + ";");
                continue;
            }
            this.append(test);
        }
        return this;
    }

    @Override
    public HtmlWriter oTag(String ns, String name, boolean needsEncoding) throws IOException {
        super.oTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oTag(String ns, String name) throws IOException {
        super.oTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter oTag(String name) throws IOException {
        super.oTag(name);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        super.oTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String ns, String name) throws IOException {
        super.oTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String name) throws IOException {
        super.oTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter tag(String ns, String name, boolean needsEncoding) throws IOException {
        super.tag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter tag(String ns, String name) throws IOException {
        super.tag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter tag(String name) throws IOException {
        super.tag(name);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String name) throws IOException {
        super.tag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        super.tag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String ns, String name) throws IOException {
        super.tag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String ns, String name) throws IOException {
        super.sTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String ns, String name, boolean needsEncoding) throws IOException {
        super.sTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String ns, String name) throws IOException {
        super.sTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String name) throws IOException {
        super.sTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String name) throws IOException {
        super.sTag(name);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        super.sTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter eTag(String ns, String name) throws IOException {
        super.eTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(String ns, String name, boolean needsEncoding) throws IOException {
        super.eTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String ns, String name) throws IOException {
        super.eTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String name) throws IOException {
        super.eTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(String name) throws IOException {
        super.eTag(name);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        super.eTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter attr(String name, Object value) throws IOException {
        super.attr(name, value);
        return this;
    }

    @Override
    public HtmlWriter attr(String ns, String name, Object value) throws IOException {
        super.attr(ns, name, value);
        return this;
    }

    @Override
    public HtmlWriter attr(String ns, String name, Object value, boolean valNeedsEncoding) throws IOException {
        super.attr(ns, name, value, valNeedsEncoding);
        return this;
    }

    @Override
    public HtmlWriter attr(String name, Object value, boolean valNeedsEncoding) throws IOException {
        super.attr(null, name, value, valNeedsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oAttr(String ns, String name) throws IOException {
        super.oAttr(ns, name);
        return this;
    }

    @Override
    public HtmlWriter cr(int depth) throws IOException {
        if (depth > 0) {
            super.cr(depth);
        }
        return this;
    }

    @Override
    public HtmlWriter cre(int depth) throws IOException {
        if (depth > 0) {
            super.cre(depth);
        }
        return this;
    }

    @Override
    public HtmlWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public HtmlWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public HtmlWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public HtmlWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public HtmlWriter s() throws IOException {
        super.s();
        return this;
    }

    @Override
    public HtmlWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public HtmlWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public HtmlWriter nl(int indent) throws IOException {
        super.nl(indent);
        return this;
    }

    @Override
    public HtmlWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public HtmlWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public HtmlWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }
}

