/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.xml.XmlSerializer;

public class HtmlSerializer
extends XmlSerializer {
    public static final HtmlSerializer DEFAULT = new HtmlSerializer(PropertyStore.create());
    public static final HtmlSerializer DEFAULT_SQ = new Sq(PropertyStore.create());
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.create());
    final HtmlSerializerContext ctx = this.createContext(HtmlSerializerContext.class);
    private volatile HtmlSchemaDocSerializer schemaSerializer;

    public HtmlSerializer(PropertyStore propertyStore) {
        this(propertyStore, "text/html", new String[0]);
    }

    public HtmlSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore, produces, accept);
    }

    @Override
    public HtmlSerializerBuilder builder() {
        return new HtmlSerializerBuilder(this.propertyStore);
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new HtmlSchemaDocSerializer(this.propertyStore);
        }
        return this.schemaSerializer;
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlSerializerSession(this.ctx, args);
    }

    public static class SqReadable
    extends HtmlSerializer {
        public SqReadable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true));
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.quoteChar", Character.valueOf('\'')));
        }
    }
}

