/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlStrippedDocSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class HtmlDocSerializerSession
extends HtmlStrippedDocSerializerSession {
    private final String header;
    private final String nav;
    private final String aside;
    private final String footer;
    private final String noResultsMessage;
    private final String[] style;
    private final String[] stylesheet;
    private final String[] script;
    private final String[] links;
    private final boolean nowrap;
    private final HtmlDocTemplate template;

    protected HtmlDocSerializerSession(HtmlDocSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.header = ctx.header;
            this.nav = ctx.nav;
            this.aside = ctx.aside;
            this.footer = ctx.footer;
            this.links = ctx.links;
            this.style = ctx.style;
            this.stylesheet = ctx.stylesheet;
            this.script = ctx.script;
            this.nowrap = ctx.nowrap;
            this.noResultsMessage = ctx.noResultsMessage;
            this.template = ClassUtils.newInstance(HtmlDocTemplate.class, ctx.template, new Object[0]);
        } else {
            this.header = p.getString("HtmlDocSerializer.header", ctx.nav);
            this.nav = p.getString("HtmlDocSerializer.nav", ctx.nav);
            this.aside = p.getString("HtmlDocSerializer.aside", ctx.aside);
            this.footer = p.getString("HtmlDocSerializer.footer", ctx.footer);
            this.links = p.getStringArray("HtmlDocSerializer.links.list", ctx.links);
            this.style = p.getStringArray("HtmlDocSerializer.style.list", ctx.style);
            this.stylesheet = p.getStringArray("HtmlDocSerializer.stylesheet", ctx.stylesheet);
            this.script = p.getStringArray("HtmlDocSerializer.script.list", ctx.script);
            this.nowrap = p.getBoolean("HtmlDocSerializer.nowrap", ctx.nowrap);
            this.noResultsMessage = p.getString("HtmlDocSerializer.noResultsMessage", ctx.noResultsMessage);
            this.template = ClassUtils.newInstance(HtmlDocTemplate.class, p.getWithDefault("HtmlDocSerializer.template", ctx.template), new Object[0]);
        }
    }

    public final String[] getStyle() {
        return this.style;
    }

    public final String[] getStylesheet() {
        return this.stylesheet;
    }

    public final String[] getScript() {
        return this.script;
    }

    public final boolean isNoWrap() {
        return this.nowrap;
    }

    public final String getHeader() {
        return this.header;
    }

    public final String[] getLinks() {
        return this.links;
    }

    public final HtmlDocTemplate getTemplate() {
        return this.template;
    }

    public final String getNav() {
        return this.nav;
    }

    public final String getAside() {
        return this.aside;
    }

    public final String getFooter() {
        return this.footer;
    }

    public final String getNoResultsMessage() {
        return this.noResultsMessage;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        HtmlWriter w = this.getHtmlWriter(out);
        HtmlDocTemplate t = this.getTemplate();
        w.sTag("html").nl(0);
        w.sTag(1, "head").nl(1);
        t.head(this, w, o);
        w.eTag(1, "head").nl(1);
        w.sTag(1, "body").nl(1);
        t.body(this, w, o);
        w.eTag(1, "body").nl(1);
        w.eTag("html").nl(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parentSerialize(Object out, Object o) throws Exception {
        SerializerPipe pipe = this.createPipe(out);
        try {
            super.doSerialize(pipe, o);
        }
        finally {
            pipe.close();
        }
    }
}

