/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.Context;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.annotation.Overrideable;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializeException;

public abstract class Session {
    private JuneauLogger logger;
    private final ObjectMap properties;
    private final Context ctx;
    private Map<String, Object> cache;
    private boolean closed;
    private List<String> warnings;

    protected Session(Context ctx, SessionArgs args) {
        this.ctx = ctx;
        this.properties = args.properties != null ? args.properties : ObjectMap.EMPTY_MAP;
    }

    protected final ObjectMap getProperties() {
        return this.properties;
    }

    public final String getStringProperty(String key) {
        return this.getStringProperty(key, null);
    }

    public final String getStringProperty(String key, String def) {
        Object v = this.properties.get(key);
        if (v == null) {
            v = this.ctx.getPropertyStore().getProperty(key, String.class, null);
        }
        if (v == null) {
            v = def;
        }
        return StringUtils.toString(v);
    }

    public final <T> T getProperty(String key, Class<T> type) {
        return this.getPropertyWithDefault(key, null, type);
    }

    public final <T> T getPropertyWithDefault(String key, T def, Class<T> type) {
        T t = this.properties.get(key, type);
        if (t == null) {
            t = this.ctx.getPropertyStore().getProperty(key, type, def);
        }
        return t;
    }

    public final void addToCache(String key, Object val) {
        if (this.cache == null) {
            this.cache = new TreeMap<String, Object>();
        }
        this.cache.put(key, val);
    }

    public final void addToCache(Map<String, Object> cacheObjects) {
        if (cacheObjects != null) {
            if (this.cache == null) {
                this.cache = new TreeMap<String, Object>();
            }
            this.cache.putAll(cacheObjects);
        }
    }

    public final <T> T getFromCache(Class<T> c, String key) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    public final void addWarning(String msg, Object ... args) {
        if (this.warnings == null) {
            this.warnings = new LinkedList<String>();
        }
        this.getLogger().warning(msg, args);
        this.warnings.add(this.warnings.size() + 1 + ": " + StringUtils.format(msg, args));
    }

    public final boolean hasWarnings() {
        return this.warnings != null && this.warnings.size() > 0;
    }

    public final List<String> getWarnings() {
        return this.warnings;
    }

    protected final JuneauLogger getLogger() {
        if (this.logger == null) {
            this.logger = JuneauLogger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Overrideable
    public ObjectMap asMap() {
        return new ObjectMap();
    }

    public String toString() {
        try {
            return this.asMap().toString(JsonSerializer.DEFAULT_LAX_READABLE);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }

    public boolean close() throws BeanRuntimeException {
        if (this.closed) {
            return false;
        }
        this.closed = true;
        return true;
    }

    protected void finalize() throws Throwable {
    }
}

