/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlWriter;

public class XmlSerializerSession
extends SerializerSession {
    private final boolean autoDetectNamespaces;
    private final boolean enableNamespaces;
    private final boolean addNamespaceUrlsToRoot;
    private final boolean addBeanTypeProperties;
    private Namespace defaultNamespace;
    private final Namespace xsNamespace;
    private Namespace[] namespaces = new Namespace[0];

    public XmlSerializerSession(XmlSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.enableNamespaces = ctx.enableNamespaces;
            this.autoDetectNamespaces = ctx.autoDetectNamespaces;
            this.addNamespaceUrlsToRoot = ctx.addNamespaceUrlsToRoot;
            this.addNamespaces(ctx.namespaces);
            this.defaultNamespace = XmlSerializerSession.findDefaultNamespace(ctx.defaultNamespace);
            this.xsNamespace = ctx.xsNamespace;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.enableNamespaces = op.getBoolean("XmlSerializer.enableNamespaces", ctx.enableNamespaces);
            this.autoDetectNamespaces = op.getBoolean("XmlSerializer.autoDetectNamespaces", ctx.autoDetectNamespaces);
            this.addNamespaceUrlsToRoot = op.getBoolean("XmlSerializer.addNamespaceUrisToRoot", ctx.addNamespaceUrlsToRoot);
            this.namespaces = op.containsKey("XmlSerializer.namespaces.list") ? NamespaceFactory.parseNamespaces(op.get("XmlSerializer.namespaces.list")) : ctx.namespaces;
            this.defaultNamespace = XmlSerializerSession.findDefaultNamespace(op.containsKey("XmlSerializer.defaultNamespace") ? op.getString("XmlSerializer.defaultNamespace") : ctx.defaultNamespace);
            this.xsNamespace = op.containsKey("XmlSerializer.xsNamespace") ? NamespaceFactory.parseNamespace(op.get("XmlSerializer.xsNamespace")) : ctx.xsNamespace;
            this.addBeanTypeProperties = op.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
    }

    private static Namespace findDefaultNamespace(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.startsWith(s, '{')) {
            return NamespaceFactory.parseNamespace(s);
        }
        if (!s.startsWith("http://")) {
            return NamespaceFactory.get(s, "http://unknown");
        }
        return NamespaceFactory.get(null, s);
    }

    private void addNamespaces(Namespace ... namespaces) {
        for (Namespace ns : namespaces) {
            this.addNamespace(ns);
        }
    }

    public void addNamespace(Namespace ns) {
        if (ns == this.defaultNamespace) {
            return;
        }
        for (Namespace n : this.namespaces) {
            if (n != ns) continue;
            return;
        }
        if (this.defaultNamespace != null && (ns.uri.equals(this.defaultNamespace.uri) || ns.name.equals(this.defaultNamespace.name))) {
            this.defaultNamespace = ns;
        } else {
            this.namespaces = ArrayUtils.append(this.namespaces, ns);
        }
    }

    public Namespace[] getNamespaces() {
        return this.namespaces;
    }

    public final boolean isAutoDetectNamespaces() {
        return this.enableNamespaces && this.autoDetectNamespaces;
    }

    public final boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    public final boolean isAddNamespaceUrlsToRoot() {
        return this.addNamespaceUrlsToRoot;
    }

    @Override
    public boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    public final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public final Namespace getXsNamespace() {
        return this.xsNamespace;
    }

    public boolean isHtmlMode() {
        return false;
    }

    @Override
    public XmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof XmlWriter) {
            return (XmlWriter)output;
        }
        return new XmlWriter(super.getWriter(), this.isUseWhitespace(), this.isTrimStrings(), this.getQuoteChar(), this.getRelativeUriBase(), this.getAbsolutePathUriBase(), this.isEnableNamespaces(), this.getDefaultNamespace());
    }
}

