/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.DelegateBeanMap;
import org.apache.juneau.internal.DelegateList;
import org.apache.juneau.internal.DelegateMap;
import org.apache.juneau.internal.StringUtils;

public final class PojoQuery {
    private Object input;
    private ClassMeta type;
    private BeanSession session;
    private SimpleDateFormat[] validTimestampFormats = new SimpleDateFormat[0];

    public PojoQuery(Object input, BeanSession session) {
        this.setValidTimestampFormats("yyyy.MM.dd.HH.mm.ss", "yyyy.MM.dd.HH.mm", "yyyy.MM.dd.HH", "yyyy.MM.dd", "yyyy.MM", "yyyy");
        this.input = input;
        this.type = session.getClassMetaForObject(input);
        this.session = session;
    }

    public Map filterMap(List view) {
        if (this.input == null) {
            return null;
        }
        if (!this.type.isMapOrBean()) {
            throw new RuntimeException("Cannot call filterMap() on class type " + this.type);
        }
        Map m = (Map)this.replaceWithMutables(this.input);
        this.doView(m, view);
        return m;
    }

    public List filterCollection(Map query, List view, List sort, int pos, int limit, boolean ignoreCase) {
        if (this.input == null) {
            return null;
        }
        if (!this.type.isCollectionOrArray()) {
            throw new RuntimeException("Cannot call filterCollection() on class type " + this.type);
        }
        if (view == null) {
            view = Collections.EMPTY_LIST;
        }
        if (sort == null) {
            sort = Collections.EMPTY_LIST;
        }
        DelegateList l = (DelegateList)this.replaceWithMutables(this.input);
        CollectionFilter filter = new CollectionFilter(query, ignoreCase);
        filter.doQuery(l);
        if (!sort.isEmpty() || !view.isEmpty()) {
            if (!sort.isEmpty()) {
                PojoQuery.doSort(l, sort);
            }
            if (!view.isEmpty()) {
                this.doView(l, view);
            }
        }
        if (pos != 0 || limit != 0) {
            int end = limit == 0 || limit + pos >= l.size() ? l.size() : limit + pos;
            DelegateList l2 = new DelegateList(((DelegateList)l).getClassMeta());
            l2.addAll(l.subList(pos, end));
            l = l2;
        }
        return l;
    }

    private Object replaceWithMutables(Object o) {
        if (o == null) {
            return null;
        }
        ClassMeta<Object> cm = this.session.getClassMetaForObject(o);
        if (cm.isCollection()) {
            DelegateList<Object> l = new DelegateList<Object>(this.session.getClassMetaForObject(o));
            for (Object o2 : (Collection)o) {
                l.add(this.replaceWithMutables(o2));
            }
            return l;
        }
        if (cm.isMap() && o instanceof BeanMap) {
            BeanMap bm = (BeanMap)o;
            DelegateBeanMap dbm = new DelegateBeanMap(bm.getBean(), this.session);
            for (BeanMapEntry beanMapEntry : bm.entrySet()) {
                ClassMeta<?> ct1 = beanMapEntry.getMeta().getClassMeta();
                if (ct1.isCollectionOrArray() || ct1.isMapOrBean() || ct1.isObject()) {
                    dbm.put(beanMapEntry.getKey(), this.replaceWithMutables(beanMapEntry.getValue()));
                    continue;
                }
                dbm.addKey(beanMapEntry.getKey());
            }
            return dbm;
        }
        if (cm.isBean()) {
            BeanMap<Object> bm = this.session.toBeanMap(o);
            DelegateBeanMap<Object> dbm = new DelegateBeanMap<Object>(bm.getBean(), this.session);
            for (BeanMapEntry beanMapEntry : bm.entrySet()) {
                ClassMeta<?> ct1 = beanMapEntry.getMeta().getClassMeta();
                if (ct1.isCollectionOrArray() || ct1.isMapOrBean() || ct1.isObject()) {
                    Object val = null;
                    try {
                        val = beanMapEntry.getValue();
                    }
                    catch (BeanRuntimeException beanRuntimeException) {
                        // empty catch block
                    }
                    dbm.put(beanMapEntry.getKey(), this.replaceWithMutables(val));
                    continue;
                }
                dbm.addKey(beanMapEntry.getKey());
            }
            return dbm;
        }
        if (cm.isMap()) {
            Map m = (Map)o;
            DelegateMap<Map> dm = new DelegateMap<Map>(this.session.getClassMetaForObject(m));
            for (Map.Entry entry : m.entrySet()) {
                dm.put(entry.getKey().toString(), this.replaceWithMutables(entry.getValue()));
            }
            return dm;
        }
        if (cm.isArray()) {
            return this.replaceWithMutables(Arrays.asList((Object[])o));
        }
        return o;
    }

    private static void doSort(List list, List sortList) {
        LinkedHashMap<Object, String> sort = new LinkedHashMap<Object, String>();
        for (Object s : sortList) {
            if (s instanceof String) {
                sort.put(s, "a");
                continue;
            }
            if (!(s instanceof Map)) continue;
            Map sm = (Map)s;
            for (Map.Entry e : sm.entrySet()) {
                sort.put(e.getKey(), e.getValue().toString().toLowerCase(Locale.ENGLISH));
            }
        }
        ArrayList columns = new ArrayList(sort.keySet());
        Collections.reverse(columns);
        for (final String c : columns) {
            final boolean isDesc = StringUtils.startsWith(sort.get(c).toString(), 'd');
            Comparator<Map> comp = new Comparator<Map>(){

                @Override
                public int compare(Map m1, Map m2) {
                    Comparable v1 = (Comparable)m1.get(c);
                    Comparable v2 = (Comparable)m2.get(c);
                    if (v1 == null && v2 == null) {
                        return 0;
                    }
                    if (v1 == null) {
                        return isDesc ? -1 : 1;
                    }
                    if (v2 == null) {
                        return isDesc ? 1 : -1;
                    }
                    return isDesc ? v2.compareTo(v1) : v1.compareTo(v2);
                }
            };
            Collections.sort(list, comp);
        }
    }

    private void doView(List list, List view) {
        ListIterator i = list.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            Map m = (Map)o;
            this.doView(m, view);
        }
    }

    private void doView(Map m, List view) {
        LinkedList<String> filterKeys = new LinkedList<String>();
        for (Object v : view) {
            if (v instanceof String) {
                filterKeys.add(v.toString());
                continue;
            }
            if (!(v instanceof ObjectMap)) continue;
            ObjectMap vm = (ObjectMap)v;
            for (Map.Entry<String, Object> e : vm.entrySet()) {
                String vmKey = e.getKey();
                Object vmVal = e.getValue();
                Object mv = m.get(vmKey);
                filterKeys.add(vmKey);
                if (!(vmVal instanceof List)) continue;
                List l = (List)vmVal;
                if (mv instanceof List) {
                    this.doView((List)mv, l);
                    continue;
                }
                if (!(mv instanceof Map)) continue;
                this.doView((Map)mv, l);
            }
        }
        if (m instanceof DelegateMap) {
            ((DelegateMap)m).filterKeys(filterKeys);
        } else {
            ((DelegateBeanMap)m).filterKeys(filterKeys);
        }
    }

    private IMatcher getObjectMatcherForType(String queryString, boolean ignoreCase, ClassMeta cm) {
        if (cm.isDate()) {
            return new DateMatcher(queryString);
        }
        if (cm.isNumber()) {
            return new NumberMatcher(queryString);
        }
        if (cm.isObject()) {
            return new ObjectMatcher(queryString, ignoreCase);
        }
        return new StringMatcher(queryString, ignoreCase);
    }

    public void setValidTimestampFormats(String ... s) {
        this.validTimestampFormats = new SimpleDateFormat[s.length];
        for (int i = 0; i < s.length; ++i) {
            this.validTimestampFormats[i] = new SimpleDateFormat(s[i]);
        }
    }

    private static int getPrecisionField(String pattern) {
        if (pattern.indexOf(115) != -1) {
            return 13;
        }
        if (pattern.indexOf(109) != -1) {
            return 12;
        }
        if (pattern.indexOf(72) != -1) {
            return 11;
        }
        if (pattern.indexOf(100) != -1) {
            return 5;
        }
        if (pattern.indexOf(77) != -1) {
            return 2;
        }
        if (pattern.indexOf(121) != -1) {
            return 1;
        }
        return 14;
    }

    protected CalendarP parseDate(String seg, ParsePosition pp) {
        CalendarP cal = null;
        for (int i = 0; i < this.validTimestampFormats.length && cal == null; ++i) {
            char c;
            pp.setIndex(0);
            SimpleDateFormat f = this.validTimestampFormats[i];
            Date d = f.parse(seg, pp);
            int idx = pp.getIndex();
            if (idx == 0) continue;
            char c2 = c = seg.length() == idx ? (char)'\u0000' : seg.charAt(idx);
            if (c != '\u0000' && c != '-' && !Character.isWhitespace(c)) continue;
            cal = new CalendarP(d, PojoQuery.getPrecisionField(f.toPattern()));
        }
        if (cal == null) {
            throw new RuntimeException("Invalid date encountered:  [" + seg + "]");
        }
        return cal;
    }

    private static String[] splitQuoted(String s, char c) {
        if (s == null || s.matches("\\s*")) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (sArray[i] == '\'' && !inDoubleQuote) {
                    inSingleQuote = !inSingleQuote;
                } else if (sArray[i] == '\"' && !inSingleQuote) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (sArray[i] == c && !inSingleQuote && !inDoubleQuote) {
                    String s2 = new String(sArray, x1, i - x1).trim();
                    l.add(s2);
                    x1 = i + 1;
                }
            }
            if (sArray[i] == '\\') continue;
            escapeCount = 0;
        }
        String s2 = new String(sArray, x1, sArray.length - x1).trim();
        l.add(s2);
        return l.toArray(new String[l.size()]);
    }

    static String replace(String s, char from, char to, boolean ignoreEscapedChars) {
        if (s == null) {
            return null;
        }
        char[] sArray = s.toCharArray();
        int escapeCount = 0;
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        for (int i = 0; i < sArray.length; ++i) {
            char c = sArray[i];
            if (c == '\\' && ignoreEscapedChars) {
                ++escapeCount;
            } else if (escapeCount % 2 == 0 && c == from && singleQuoteCount % 2 == 0 && doubleQuoteCount % 2 == 0) {
                sArray[i] = to;
            }
            if (sArray[i] == '\\') continue;
            escapeCount = 0;
        }
        return new String(sArray);
    }

    static String unEscapeChars(String s, char[] toEscape) {
        char escapeChar = '\\';
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        for (int i = 0; i < sArray.length; ++i) {
            char c = sArray[i];
            if (c == escapeChar && i + 1 != sArray.length) {
                char c2 = sArray[i + 1];
                boolean isOneOf = false;
                for (int j = 0; j < toEscape.length && !isOneOf; ++j) {
                    isOneOf = c2 == toEscape[j];
                }
                if (isOneOf) {
                    ++i;
                } else if (c2 == escapeChar) {
                    sb.append(escapeChar);
                    ++i;
                }
            }
            sb.append(sArray[i]);
        }
        return sb.toString();
    }

    private static class SearchPattern {
        Pattern[] orPatterns;
        Pattern[] andPatterns;
        Pattern[] notPatterns;

        public SearchPattern(String searchPattern, boolean ignoreCase) {
            LinkedList<Pattern> ors = new LinkedList<Pattern>();
            LinkedList<Pattern> ands = new LinkedList<Pattern>();
            LinkedList<Pattern> nots = new LinkedList<Pattern>();
            for (String arg : SearchPattern.breakUpTokens(searchPattern)) {
                char prefix = arg.charAt(0);
                String token = arg.substring(1);
                token = token.replaceAll("([\\?\\*\\+\\\\\\[\\]\\{\\}\\(\\)\\^\\$\\.])", "\\\\$1");
                token = token.replace("\u9997", ".*");
                if (!(token = token.replace("\u9996", ".?")).startsWith(".*")) {
                    token = "^" + token;
                }
                if (!token.endsWith(".*")) {
                    token = token + "$";
                }
                int flags = 32;
                if (ignoreCase) {
                    flags |= 2;
                }
                Pattern p = Pattern.compile(token, flags);
                if (prefix == '^') {
                    ors.add(p);
                    continue;
                }
                if (prefix == '+') {
                    ands.add(p);
                    continue;
                }
                if (prefix != '-') continue;
                nots.add(p);
            }
            this.orPatterns = ors.toArray(new Pattern[ors.size()]);
            this.andPatterns = ands.toArray(new Pattern[ands.size()]);
            this.notPatterns = nots.toArray(new Pattern[nots.size()]);
        }

        private static List<String> breakUpTokens(String s) {
            if (s == null || s.trim().length() == 0) {
                return Collections.emptyList();
            }
            s = " " + s + " ";
            int escapeCount = 0;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            char[] ca = s.toCharArray();
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == '\\') {
                    ++escapeCount;
                } else if (escapeCount % 2 == 0) {
                    if (ca[i] == '\'') {
                        inSingleQuote = !inSingleQuote;
                    } else if (ca[i] == '\"') {
                        inDoubleQuote = !inDoubleQuote;
                    } else if (ca[i] == '+' && (inSingleQuote || inDoubleQuote)) {
                        ca[i] = 39321;
                    } else if (ca[i] == '-' && (inSingleQuote || inDoubleQuote)) {
                        ca[i] = 39320;
                    }
                }
                if (ca[i] == '\\') continue;
                escapeCount = 0;
            }
            s = new String(ca);
            s = s.replaceAll("([\\+\\-])\\s+", "$1");
            s = PojoQuery.replace(s, '*', '\u9997', true);
            s = PojoQuery.replace(s, '?', '\u9996', true);
            s = PojoQuery.unEscapeChars(s, new char[]{'*', '?'});
            s = s.trim();
            s = s.replace('\u9999', '+');
            s = s.replace('\u9998', '-');
            String[] sa = PojoQuery.splitQuoted(s, ' ');
            ArrayList<String> l = new ArrayList<String>(sa.length);
            int numOrs = 0;
            for (int i = 0; i < sa.length; ++i) {
                String token = sa[i];
                int len = token.length();
                if (len <= 0) continue;
                char c = token.charAt(0);
                String s2 = null;
                if ((c == '+' || c == '-') && len > 1) {
                    s2 = token.substring(1);
                } else {
                    s2 = token;
                    c = '^';
                    ++numOrs;
                }
                if (s2.matches("\".*\"") || s2.matches("'.*'")) {
                    s2 = s2.substring(1, s2.length() - 1);
                }
                s2 = PojoQuery.unEscapeChars(s2, new char[]{'\"', '\''});
                s2 = PojoQuery.unEscapeChars(s2, new char[]{'\\'});
                l.add(c + s2);
            }
            if (numOrs == 1) {
                int ii = l.size();
                for (int i = 0; i < ii; ++i) {
                    String x = (String)l.get(i);
                    if (x.charAt(0) != '^') continue;
                    l.set(i, '+' + x.substring(1));
                }
            }
            return l;
        }

        public boolean matches(String input) {
            int i;
            if (input == null) {
                return false;
            }
            for (i = 0; i < this.andPatterns.length; ++i) {
                if (this.andPatterns[i].matcher(input).matches()) continue;
                return false;
            }
            for (i = 0; i < this.notPatterns.length; ++i) {
                if (!this.notPatterns[i].matcher(input).matches()) continue;
                return false;
            }
            for (i = 0; i < this.orPatterns.length; ++i) {
                if (!this.orPatterns[i].matcher(input).matches()) continue;
                return true;
            }
            return this.orPatterns.length == 0;
        }
    }

    private static class StringMatcher
    implements IMatcher<Object> {
        private SearchPattern[] searchPatterns = new SearchPattern[1];

        public StringMatcher(String searchPattern, boolean ignoreCase) {
            this.searchPatterns[0] = new SearchPattern(searchPattern, ignoreCase);
        }

        @Override
        public boolean matches(Object in) {
            if (in == null) {
                return false;
            }
            for (int i = 0; i < this.searchPatterns.length; ++i) {
                if (this.searchPatterns[i].matches(in.toString())) continue;
                return false;
            }
            return true;
        }
    }

    private static class CalendarP {
        public Calendar c = Calendar.getInstance();
        public int precision;

        public CalendarP(Date date, int precision) {
            this.c.setTime(date);
            this.precision = precision;
        }

        public CalendarP copy() {
            return new CalendarP(this.c.getTime(), this.precision);
        }

        public CalendarP roll(int field, int amount) {
            this.c.add(field, amount);
            return this;
        }

        public CalendarP roll(int amount) {
            return this.roll(this.precision, amount);
        }

        public Calendar getCalendar() {
            return this.c;
        }
    }

    private static class TimestampRange {
        Calendar start;
        Calendar end;

        public TimestampRange(CalendarP start, CalendarP end) {
            this.start = start.copy().roll(14, -1).getCalendar();
            this.end = end.roll(1).getCalendar();
        }

        public TimestampRange(CalendarP singleDate) {
            this.start = singleDate.copy().roll(14, -1).getCalendar();
            this.end = singleDate.roll(1).getCalendar();
        }

        public TimestampRange(String op, CalendarP singleDate) {
            if (op.equals(">")) {
                this.start = singleDate.roll(1).roll(14, -1).getCalendar();
                this.end = new CalendarP(new Date(Long.MAX_VALUE), 0).getCalendar();
            } else if (op.equals("<")) {
                this.start = new CalendarP(new Date(0L), 0).getCalendar();
                this.end = singleDate.getCalendar();
            } else if (op.equals(">=")) {
                this.start = singleDate.roll(14, -1).getCalendar();
                this.end = new CalendarP(new Date(Long.MAX_VALUE), 0).getCalendar();
            } else if (op.equals("<=")) {
                this.start = new CalendarP(new Date(0L), 0).getCalendar();
                this.end = singleDate.roll(1).getCalendar();
            }
        }

        public boolean matches(Calendar c) {
            boolean b = c.after(this.start) && c.before(this.end);
            return b;
        }
    }

    private class TimestampPattern {
        TimestampRange[] ranges;
        List<TimestampRange> l = new LinkedList<TimestampRange>();

        public TimestampPattern(String s) {
            if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
                s = s.substring(1, s.length() - 1);
            }
            Pattern p1 = Pattern.compile("^\\s*([<>](?:=)?)\\s*(\\S+.*)$");
            Pattern p2 = Pattern.compile("^(\\s*-\\s*)(\\S+.*)$");
            int state = 1;
            String op = null;
            CalendarP startDate = null;
            ParsePosition pp = new ParsePosition(0);
            Matcher m = null;
            String seg = s;
            while (!seg.equals("") || state != 1) {
                if (state == 1) {
                    m = p1.matcher(seg);
                    if (m.matches()) {
                        op = m.group(1);
                        seg = m.group(2);
                        state = 2;
                        continue;
                    }
                    state = 3;
                    continue;
                }
                if (state == 2) {
                    this.l.add(new TimestampRange(op, PojoQuery.this.parseDate(seg, pp)));
                    seg = seg.substring(pp.getIndex()).trim();
                    pp.setIndex(0);
                    state = 1;
                    continue;
                }
                if (state == 3) {
                    startDate = PojoQuery.this.parseDate(seg, pp);
                    seg = seg.substring(pp.getIndex()).trim();
                    pp.setIndex(0);
                    state = 4;
                    continue;
                }
                if (state == 4) {
                    m = p2.matcher(seg);
                    if (m.matches()) {
                        state = 5;
                        seg = m.group(2);
                        continue;
                    }
                    this.l.add(new TimestampRange(startDate));
                    state = 1;
                    continue;
                }
                if (state != 5) continue;
                this.l.add(new TimestampRange(startDate, PojoQuery.this.parseDate(seg, pp)));
                seg = seg.substring(pp.getIndex()).trim();
                pp.setIndex(0);
                state = 1;
            }
            this.ranges = this.l.toArray(new TimestampRange[this.l.size()]);
        }

        public boolean matches(Calendar c) {
            if (this.ranges.length == 0) {
                return true;
            }
            for (int i = 0; i < this.ranges.length; ++i) {
                if (!this.ranges[i].matches(c)) continue;
                return true;
            }
            return false;
        }
    }

    private class DateMatcher
    implements IMatcher<Object> {
        private TimestampPattern[] patterns = new TimestampPattern[1];

        DateMatcher(String searchPattern) {
            this.patterns[0] = new TimestampPattern(searchPattern);
        }

        @Override
        public boolean matches(Object in) {
            if (in == null) {
                return false;
            }
            Calendar c = null;
            if (in instanceof Calendar) {
                c = (Calendar)in;
            } else if (in instanceof Date) {
                c = Calendar.getInstance();
                c.setTime((Date)in);
            } else {
                return false;
            }
            for (int i = 0; i < this.patterns.length; ++i) {
                if (this.patterns[i].matches(c)) continue;
                return false;
            }
            return true;
        }
    }

    private static class NumberRange {
        int start;
        int end;
        boolean isNot;

        public NumberRange(String arg, String start, String end, boolean isNot) {
            this.isNot = isNot;
            if (arg.equals("") && end == null) {
                this.end = this.start = Integer.parseInt(start);
            } else if (arg.equals(">")) {
                this.start = Integer.parseInt(start) + 1;
                this.end = Integer.MAX_VALUE;
            } else if (arg.equals(">=")) {
                this.start = Integer.parseInt(start);
                this.end = Integer.MAX_VALUE;
            } else if (arg.equals("<")) {
                this.start = Integer.MIN_VALUE;
                this.end = Integer.parseInt(start) - 1;
            } else if (arg.equals("<=")) {
                this.start = Integer.MIN_VALUE;
                this.end = Integer.parseInt(start);
            } else {
                this.start = Integer.parseInt(start);
                this.end = Integer.parseInt(end);
            }
        }

        public boolean matches(Number n) {
            boolean b;
            long i = n.longValue();
            boolean bl = b = i >= (long)this.start && i <= (long)this.end;
            if (this.isNot) {
                b = !b;
            }
            return b;
        }
    }

    private static class NumberPattern {
        NumberRange[] numberRanges;

        public NumberPattern(String searchPattern) {
            LinkedList<NumberRange> l = new LinkedList<NumberRange>();
            for (String s : NumberPattern.breakUpTokens(searchPattern)) {
                boolean isNot = s.charAt(0) == '!';
                String token = s.substring(1);
                Pattern p = Pattern.compile("(([<>]=?)?)(-?\\d+)(-?(-?\\d+)?)");
                Matcher m = p.matcher(token);
                if (!m.matches()) {
                    throw new RuntimeException("Numeric value didn't match pattern:  [" + token + "]");
                }
                String arg1 = m.group(1);
                String start = m.group(3);
                String end = m.group(5);
                l.add(new NumberRange(arg1, start, end, isNot));
            }
            this.numberRanges = l.toArray(new NumberRange[l.size()]);
        }

        private static List<String> breakUpTokens(String s) {
            s = s.replaceAll("(-?\\d+)\\s*-\\s*(-?\\d+)", "$1-$2");
            s = s.replaceAll("([<>]=?)\\s+(-?\\d+)", "$1$2");
            s = s.replaceAll("(!)\\s+(-?\\d+)", "$1$2");
            s = s.replaceAll(",", " ");
            String[] s2 = s.split("\\s+");
            for (int i = 0; i < s2.length; ++i) {
                if (StringUtils.startsWith(s2[i], '!')) continue;
                s2[i] = "^" + s2[i];
            }
            LinkedList<String> l = new LinkedList<String>();
            l.addAll(Arrays.asList(s2));
            return l;
        }

        public boolean matches(Number number) {
            if (this.numberRanges.length == 0) {
                return true;
            }
            for (int i = 0; i < this.numberRanges.length; ++i) {
                if (!this.numberRanges[i].matches(number)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NumberMatcher
    implements IMatcher<Number> {
        private NumberPattern[] numberPatterns = new NumberPattern[1];

        public NumberMatcher(String searchPattern) {
            this.numberPatterns[0] = new NumberPattern(searchPattern);
        }

        @Override
        public boolean matches(Number in) {
            for (int i = 0; i < this.numberPatterns.length; ++i) {
                if (this.numberPatterns[i].matches(in)) continue;
                return false;
            }
            return true;
        }
    }

    private class ObjectMatcher
    implements IMatcher<Object> {
        String searchPattern;
        boolean ignoreCase;
        DateMatcher dateMatcher;
        NumberMatcher numberMatcher;
        StringMatcher stringMatcher;

        ObjectMatcher(String searchPattern, boolean ignoreCase) {
            this.searchPattern = searchPattern;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean matches(Object o) {
            if (o instanceof Number) {
                return this.getNumberMatcher().matches(o);
            }
            if (o instanceof Date || o instanceof Calendar) {
                return this.getDateMatcher().matches(o);
            }
            return this.getStringMatcher().matches(o);
        }

        private IMatcher getNumberMatcher() {
            if (this.numberMatcher == null) {
                this.numberMatcher = new NumberMatcher(this.searchPattern);
            }
            return this.numberMatcher;
        }

        private IMatcher getStringMatcher() {
            if (this.stringMatcher == null) {
                this.stringMatcher = new StringMatcher(this.searchPattern, this.ignoreCase);
            }
            return this.stringMatcher;
        }

        private IMatcher getDateMatcher() {
            if (this.dateMatcher == null) {
                this.dateMatcher = new DateMatcher(this.searchPattern);
            }
            return this.dateMatcher;
        }
    }

    private class MapMatcher
    implements IMatcher<Map> {
        Map<String, IMatcher> entryMatchers = new HashMap<String, IMatcher>();

        public MapMatcher(Map query, boolean ignoreCase) {
            for (Map.Entry e : query.entrySet()) {
                String key = e.getKey().toString();
                Object value = e.getValue();
                IMatcher matcher = null;
                if (value instanceof String) {
                    matcher = PojoQuery.this.getObjectMatcherForType((String)value, ignoreCase, PojoQuery.this.session.object());
                } else if (value instanceof ObjectMap) {
                    matcher = new MapMatcher((ObjectMap)value, ignoreCase);
                } else {
                    throw new RuntimeException("Invalid value type: " + value);
                }
                this.entryMatchers.put(key, matcher);
            }
        }

        @Override
        public boolean matches(Map m) {
            if (m == null) {
                return false;
            }
            for (Map.Entry<String, IMatcher> e : this.entryMatchers.entrySet()) {
                String key = e.getKey();
                Object val = m.get(key);
                if (e.getValue().matches(val)) continue;
                return false;
            }
            return true;
        }
    }

    private static interface IMatcher<E> {
        public boolean matches(E var1);
    }

    private class CollectionFilter {
        IMatcher entryMatcher;

        public CollectionFilter(Map query, boolean ignoreCase) {
            if (query != null && !query.isEmpty()) {
                this.entryMatcher = new MapMatcher(query, ignoreCase);
            }
        }

        public void doQuery(List in) {
            if (in == null || this.entryMatcher == null) {
                return;
            }
            Iterator i = in.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (this.entryMatcher.matches(o)) continue;
                i.remove();
            }
        }
    }
}

