/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.uon.UonParserContext;
import org.apache.juneau.uon.UonReader;

public class UonParserSession
extends ParserSession {
    private final boolean decodeChars;
    private UonReader reader;

    public UonParserSession(UonParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
        this.decodeChars = op == null || op.isEmpty() ? ctx.decodeChars : op.getBoolean("UonParser.decodeChars", ctx.decodeChars);
    }

    public UonParserSession(UonParserContext ctx, Object input) {
        super(ctx, null, input, null, null, null, null, null);
        this.decodeChars = false;
    }

    public final boolean isDecodeChars() {
        return this.decodeChars;
    }

    @Override
    public UonReader getReader() throws Exception {
        if (this.reader == null) {
            Object input = this.getInput();
            this.reader = input instanceof UonReader ? (UonReader)input : (input instanceof CharSequence ? new UonReader((CharSequence)input, this.decodeChars) : new UonReader(super.getReader(), this.decodeChars));
        }
        return this.reader;
    }

    @Override
    public Map<String, Object> getLastLocation() {
        Map<String, Object> m = super.getLastLocation();
        if (this.reader != null) {
            m.put("line", this.reader.getLine());
            m.put("column", this.reader.getColumn());
        }
        return m;
    }
}

