/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.StringSwap;

public class DateSwap
extends StringSwap<java.util.Date> {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final int dateStyle;
    private final int timeStyle;
    private final String pattern;
    private final TimeZone timeZone;

    protected DateSwap(String pattern, int dateStyle, int timeStyle, TimeZone timeZone) {
        this.pattern = pattern;
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.timeZone = timeZone;
    }

    protected DateFormat getDateFormat(BeanSession session) {
        DateFormat df = session.getFromCache(DateFormat.class, this.getClass().getName());
        if (df == null) {
            df = this.pattern != null ? new SimpleDateFormat(this.pattern, session.getLocale()) : (this.dateStyle == -1 && this.timeStyle != -1 ? DateFormat.getTimeInstance(this.timeStyle, session.getLocale()) : (this.dateStyle != -1 && this.timeStyle == -1 ? DateFormat.getDateInstance(this.dateStyle, session.getLocale()) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, session.getLocale())));
            if (this.timeZone != null) {
                df.setTimeZone(this.timeZone);
            } else if (session.getTimeZone() != null) {
                df.setTimeZone(session.getTimeZone());
            }
            session.addToCache(this.getClass().getName(), df);
        }
        return df;
    }

    @Override
    public String swap(BeanSession session, java.util.Date o) {
        return this.getDateFormat(session).format(o.getTime());
    }

    @Override
    public java.util.Date unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
        try {
            if (StringUtils.isEmpty(o)) {
                return null;
            }
            return DateSwap.convert(new java.util.Date(this.getDateFormat(session).parse(o).getTime()), hint);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static java.util.Date convert(java.util.Date in, ClassMeta<?> hint) throws Exception {
        if (in == null) {
            return null;
        }
        if (hint == null || hint.isInstance(in)) {
            return in;
        }
        Class<?> c = hint.getInnerClass();
        if (c == java.util.Date.class) {
            return in;
        }
        if (c == Date.class) {
            return new Date(in.getTime());
        }
        if (c == Time.class) {
            return new Time(in.getTime());
        }
        if (c == Timestamp.class) {
            return new Timestamp(in.getTime());
        }
        throw new ParseException("DateSwap is unable to narrow object of type ''{0}''", c);
    }

    private static Calendar setTimeZone(BeanSession session, Calendar c) {
        TimeZone tz = session.getTimeZone();
        if (tz != null && !tz.equals(c.getTimeZone())) {
            c = (Calendar)c.clone();
            c.setTimeZone(tz);
        }
        return c;
    }

    public static class DateTimeShort
    extends DateSwap {
        public DateTimeShort() {
            super(null, 3, 3, null);
        }
    }

    public static class DateTimeMedium
    extends DateSwap {
        public DateTimeMedium() {
            super(null, 2, 2, null);
        }
    }

    public static class DateTimeLong
    extends DateSwap {
        public DateTimeLong() {
            super(null, 1, 1, null);
        }
    }

    public static class DateTimeFull
    extends DateSwap {
        public DateTimeFull() {
            super(null, 0, 0, null);
        }
    }

    public static class TimeShort
    extends DateSwap {
        public TimeShort() {
            super(null, -1, 3, null);
        }
    }

    public static class TimeMedium
    extends DateSwap {
        public TimeMedium() {
            super(null, -1, 2, null);
        }
    }

    public static class TimeLong
    extends DateSwap {
        public TimeLong() {
            super(null, -1, 1, null);
        }
    }

    public static class TimeFull
    extends DateSwap {
        public TimeFull() {
            super(null, -1, 0, null);
        }
    }

    public static class DateShort
    extends DateSwap {
        public DateShort() {
            super(null, 3, -1, null);
        }
    }

    public static class DateMedium
    extends DateSwap {
        public DateMedium() {
            super(null, 2, -1, null);
        }
    }

    public static class DateLong
    extends DateSwap {
        public DateLong() {
            super(null, 1, -1, null);
        }
    }

    public static class DateFull
    extends DateSwap {
        public DateFull() {
            super(null, 0, -1, null);
        }
    }

    public static class TimeSimple
    extends DateSwap {
        public TimeSimple() {
            super("HH:mm:ss", -1, -1, null);
        }
    }

    public static class DateSimple
    extends DateSwap {
        public DateSimple() {
            super("yyyy/MM/dd", -1, -1, null);
        }
    }

    public static class DateTimeSimple
    extends DateSwap {
        public DateTimeSimple() {
            super("yyyy/MM/dd HH:mm:ss", -1, -1, null);
        }
    }

    public static class RFC2822D
    extends DateSwap {
        public RFC2822D() {
            super("dd MMM yyyy", -1, -1, null);
        }
    }

    public static class RFC2822DTZ
    extends DateSwap {
        public RFC2822DTZ() {
            super("EEE, dd MMM yyyy HH:mm:ss 'GMT'", -1, -1, GMT);
        }
    }

    public static class RFC2822DT
    extends DateSwap {
        public RFC2822DT() {
            super("EEE, dd MMM yyyy HH:mm:ss Z", -1, -1, null);
        }
    }

    public static class ISO8601DTPZ
    extends ISO8601DTZ {
        @Override
        public String swap(BeanSession session, java.util.Date o) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(o);
            String s = super.swap(session, o);
            return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
        }
    }

    public static class ISO8601DTP
    extends ISO8601DT {
        @Override
        public String swap(BeanSession session, java.util.Date o) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(o);
            String s = super.swap(session, o);
            return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
        }
    }

    public static class ISO8601DTZ
    extends DateSwap {
        public ISO8601DTZ() {
            super(null, -1, -1, null);
        }

        @Override
        public java.util.Date unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return DateSwap.convert(DatatypeConverter.parseDateTime((String)o).getTime(), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(BeanSession session, java.util.Date o) {
            Calendar c = new GregorianCalendar();
            c.setTime(o);
            if (((Calendar)c).getTimeZone().getRawOffset() != 0) {
                Calendar c2 = Calendar.getInstance(GMT);
                c2.setTime(c.getTime());
                c = c2;
            }
            return DatatypeConverter.printDateTime((Calendar)c);
        }
    }

    public static class ISO8601DT
    extends DateSwap {
        public ISO8601DT() {
            super(null, -1, -1, null);
        }

        @Override
        public java.util.Date unswap(BeanSession session, String o, ClassMeta<?> hint) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return DateSwap.convert(DatatypeConverter.parseDateTime((String)o).getTime(), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(BeanSession session, java.util.Date o) {
            Calendar c = new GregorianCalendar();
            c.setTime(o);
            c = DateSwap.setTimeZone(session, c);
            return DatatypeConverter.printDateTime((Calendar)c);
        }
    }

    public static class ToString
    extends DateSwap {
        public ToString() {
            super("EEE MMM dd HH:mm:ss zzz yyyy", -1, -1, null);
        }
    }
}

