/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;

public final class AnnotationBeanFilterBuilder
extends BeanFilterBuilder {
    public AnnotationBeanFilterBuilder(Class<?> annotatedClass, Map<Class<?>, Bean> annotations) throws Exception {
        super(annotatedClass);
        ListIterator<Bean> li = new ArrayList<Bean>(annotations.values()).listIterator(annotations.size());
        while (li.hasPrevious()) {
            Bean b = li.previous();
            if (!b.properties().isEmpty()) {
                this.properties(StringUtils.split(b.properties(), ','));
            }
            if (!b.typeName().isEmpty()) {
                this.typeName(b.typeName());
            }
            if (b.sort()) {
                this.sortProperties(true);
            }
            if (!b.excludeProperties().isEmpty()) {
                this.excludeProperties(StringUtils.split(b.excludeProperties(), ','));
            }
            if (b.propertyNamer() != PropertyNamerDefault.class) {
                this.propertyNamer(b.propertyNamer());
            }
            if (b.interfaceClass() != Object.class) {
                this.interfaceClass(b.interfaceClass());
            }
            if (b.stopClass() != Object.class) {
                this.stopClass(b.stopClass());
            }
            if (b.beanDictionary().length <= 0) continue;
            this.beanDictionary(b.beanDictionary());
        }
    }
}

