/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;

public final class SerializerGroup {
    private final Map<String, SerializerMatch> cache = new ConcurrentHashMap<String, SerializerMatch>();
    final Serializer[] serializers;
    private final PropertyStore propertyStore;

    public SerializerGroup(PropertyStore propertyStore, Serializer[] serializers) {
        this.propertyStore = PropertyStore.create(propertyStore);
        this.serializers = ArrayUtils.reverse(serializers);
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (sm != null) {
            return sm;
        }
        MediaRange[] mr = MediaRange.parse(acceptHeader);
        if (mr.length == 0) {
            mr = MediaRange.parse("*/*");
        }
        TreeMap m = null;
        for (MediaRange a : mr) {
            for (Serializer s : this.serializers) {
                for (MediaType a2 : s.getMediaTypes()) {
                    float q = a.matches(a2);
                    if (q == 1.0f) {
                        sm = new SerializerMatch(a2, s);
                        this.cache.put(acceptHeader, sm);
                        return sm;
                    }
                    if (!(q > 0.0f)) continue;
                    if (m == null) {
                        m = new TreeMap(Collections.reverseOrder());
                    }
                    m.put(Float.valueOf(q), new SerializerMatch(a2, s));
                }
            }
        }
        return m == null ? null : (SerializerMatch)m.values().iterator().next();
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public List<MediaType> getSupportedMediaTypes() {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        for (Serializer s : this.serializers) {
            for (MediaType mt : s.getMediaTypes()) {
                if (l.contains(mt)) continue;
                l.add(mt);
            }
        }
        return l;
    }

    public PropertyStore createPropertyStore() {
        return PropertyStore.create(this.propertyStore);
    }

    public Serializer[] getSerializers() {
        return ArrayUtils.reverse(this.serializers);
    }
}

