/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.response;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

public class DefaultHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        String accept;
        SerializerGroup g = res.getSerializerGroup();
        SerializerMatch sm = g.getSerializerMatch(accept = req.getHeader("Accept", ""));
        if (sm != null) {
            Serializer s = sm.getSerializer();
            MediaType mediaType = res.getMediaType();
            if (mediaType == null) {
                mediaType = sm.getMediaType();
            }
            res.setContentType(mediaType.toString());
            ObjectMap headers = s.getResponseHeaders(res.getProperties());
            if (headers != null) {
                for (String key : headers.keySet()) {
                    res.setHeader(key, headers.getString(key));
                }
            }
            try {
                Serializer s2;
                ObjectMap p = res.getProperties();
                if (req.isPlainText()) {
                    p.put("Serializer.useWhitespace", true);
                    res.setContentType("text/plain");
                }
                p.append("mediaType", mediaType).append("characterEncoding", res.getCharacterEncoding());
                if (!s.isWriterSerializer()) {
                    s2 = (OutputStreamSerializer)s;
                    ServletOutputStream os = res.getNegotiatedOutputStream();
                    SerializerSession session = s.createSession(os, p, req.getJavaMethod(), req.getLocale(), req.getTimeZone(), mediaType);
                    s2.serialize(session, output);
                    os.close();
                }
                s2 = (WriterSerializer)s;
                PrintWriter w = res.getNegotiatedWriter();
                SerializerSession session = s.createSession(w, p, req.getJavaMethod(), req.getLocale(), req.getTimeZone(), mediaType);
                s2.serialize(session, output);
                ((Writer)w).close();
            }
            catch (SerializeException e) {
                throw new RestException(500, (Throwable)e);
            }
        } else {
            throw new RestException(406, "Unsupported media-type in request header ''Accept'': ''{0}''\n\tSupported media-types: {1}", req.getHeader("Accept", ""), g.getSupportedMediaTypes());
        }
        return true;
    }
}

