/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;

public class ParserGroupBuilder {
    private final List<Object> parsers;
    private final PropertyStore propertyStore;

    public ParserGroupBuilder() {
        this.parsers = new ArrayList<Object>();
        this.propertyStore = PropertyStore.create();
    }

    public ParserGroupBuilder(PropertyStore propertyStore) {
        this.parsers = new ArrayList<Object>();
        this.propertyStore = propertyStore;
    }

    public ParserGroupBuilder(ParserGroup copyFrom) {
        this.parsers = new ArrayList<Parser>(Arrays.asList(copyFrom.parsers));
        this.propertyStore = copyFrom.createPropertyStore();
    }

    public ParserGroupBuilder append(Class<?> ... p) {
        this.parsers.addAll(Arrays.asList(p));
        return this;
    }

    public ParserGroupBuilder append(Parser ... p) {
        this.parsers.addAll(Arrays.asList(p));
        return this;
    }

    public ParserGroupBuilder append(List<Parser> p) {
        this.parsers.addAll(p);
        return this;
    }

    public ParserGroup build() {
        ArrayList l = new ArrayList();
        for (Object p : this.parsers) {
            Class<?> c = null;
            PropertyStore ps = this.propertyStore;
            if (p instanceof Class) {
                c = (Class<?>)p;
            } else {
                Parser p2 = (Parser)p;
                ps = p2.createPropertyStore().copyFrom(this.propertyStore);
                c = p2.getClass();
            }
            try {
                l.add(c.getConstructor(PropertyStore.class).newInstance(ps));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate parser " + c.getName(), e);
            }
        }
        return new ParserGroup(this.propertyStore, l.toArray(new Parser[l.size()]));
    }

    public ParserGroupBuilder property(String name, Object value) {
        this.propertyStore.setProperty(name, value);
        return this;
    }

    public ParserGroupBuilder properties(ObjectMap properties) {
        this.propertyStore.setProperties(properties);
        return this;
    }

    public ParserGroupBuilder addToProperty(String name, Object value) {
        this.propertyStore.addToProperty(name, value);
        return this;
    }

    public ParserGroupBuilder putToProperty(String name, Object key, Object value) {
        this.propertyStore.putToProperty(name, key, value);
        return this;
    }

    public ParserGroupBuilder putToProperty(String name, Object value) {
        this.propertyStore.putToProperty(name, value);
        return this;
    }

    public ParserGroupBuilder removeFromProperty(String name, Object value) {
        this.propertyStore.removeFromProperty(name, value);
        return this;
    }

    public ParserGroupBuilder trimStrings(boolean value) {
        return this.property("Parser.trimStrings", value);
    }

    public ParserGroupBuilder strict(boolean value) {
        return this.property("Parser.strict", value);
    }

    public ParserGroupBuilder inputStreamCharset(String value) {
        return this.property("Parser.inputStreamCharset", value);
    }

    public ParserGroupBuilder fileCharset(String value) {
        return this.property("Parser.fileCharset", value);
    }

    public ParserGroupBuilder beansRequireDefaultConstructor(boolean value) {
        return this.property("BeanContext.beansRequireDefaultConstructor", value);
    }

    public ParserGroupBuilder beansRequireSerializable(boolean value) {
        return this.property("BeanContext.beansRequireSerializable", value);
    }

    public ParserGroupBuilder beansRequireSettersForGetters(boolean value) {
        return this.property("BeanContext.beansRequireSettersForGetters", value);
    }

    public ParserGroupBuilder beansRequireSomeProperties(boolean value) {
        return this.property("BeanContext.beansRequireSomeProperties", value);
    }

    public ParserGroupBuilder beanMapPutReturnsOldValue(boolean value) {
        return this.property("BeanContext.beanMapPutReturnsOldValue", value);
    }

    public ParserGroupBuilder beanConstructorVisibility(Visibility value) {
        return this.property("BeanContext.beanConstructorVisibility", (Object)value);
    }

    public ParserGroupBuilder beanClassVisibility(Visibility value) {
        return this.property("BeanContext.beanClassVisibility", (Object)value);
    }

    public ParserGroupBuilder beanFieldVisibility(Visibility value) {
        return this.property("BeanContext.beanFieldVisibility", (Object)value);
    }

    public ParserGroupBuilder methodVisibility(Visibility value) {
        return this.property("BeanContext.methodVisibility", (Object)value);
    }

    public ParserGroupBuilder useJavaBeanIntrospector(boolean value) {
        return this.property("BeanContext.useJavaBeanIntrospector", value);
    }

    public ParserGroupBuilder useInterfaceProxies(boolean value) {
        return this.property("BeanContext.useInterfaceProxies", value);
    }

    public ParserGroupBuilder ignoreUnknownBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownBeanProperties", value);
    }

    public ParserGroupBuilder ignoreUnknownNullBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownNullBeanProperties", value);
    }

    public ParserGroupBuilder ignorePropertiesWithoutSetters(boolean value) {
        return this.property("BeanContext.ignorePropertiesWithoutSetters", value);
    }

    public ParserGroupBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnGetters", value);
    }

    public ParserGroupBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnSetters", value);
    }

    public ParserGroupBuilder sortProperties(boolean value) {
        return this.property("BeanContext.sortProperties", value);
    }

    public ParserGroupBuilder notBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set.add", values);
    }

    public ParserGroupBuilder notBeanPackages(Collection<String> value) {
        return this.property("BeanContext.notBeanPackages.set.add", value);
    }

    public ParserGroupBuilder setNotBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public ParserGroupBuilder setNotBeanPackages(Collection<String> values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public ParserGroupBuilder removeNotBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set.remove", values);
    }

    public ParserGroupBuilder removeNotBeanPackages(Collection<String> values) {
        return this.property("BeanContext.notBeanPackages.set.remove", values);
    }

    public ParserGroupBuilder notBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set.add", values);
    }

    public ParserGroupBuilder notBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set.add", values);
    }

    public ParserGroupBuilder setNotBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public ParserGroupBuilder setNotBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public ParserGroupBuilder removeNotBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set.remove", values);
    }

    public ParserGroupBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set.remove", values);
    }

    public ParserGroupBuilder beanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list.add", values);
    }

    public ParserGroupBuilder beanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list.add", values);
    }

    public ParserGroupBuilder setBeanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public ParserGroupBuilder setBeanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public ParserGroupBuilder removeBeanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list.remove", values);
    }

    public ParserGroupBuilder removeBeanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list.remove", values);
    }

    public ParserGroupBuilder pojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list.add", values);
    }

    public ParserGroupBuilder pojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list.add", values);
    }

    public ParserGroupBuilder setPojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public ParserGroupBuilder setPojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public ParserGroupBuilder removePojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list.remove", values);
    }

    public ParserGroupBuilder removePojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list.remove", values);
    }

    public ParserGroupBuilder implClasses(Map<Class<?>, Class<?>> values) {
        return this.property("BeanContext.implClasses.map", values);
    }

    public <T> ParserGroupBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        return this.putToProperty("BeanContext.implClasses.map", interfaceClass, implClass);
    }

    public ParserGroupBuilder beanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list.add", values);
    }

    public ParserGroupBuilder beanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list.add", values);
    }

    public ParserGroupBuilder setBeanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public ParserGroupBuilder setBeanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public ParserGroupBuilder removeFromBeanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list.remove", values);
    }

    public ParserGroupBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list.remove", values);
    }

    public ParserGroupBuilder beanTypePropertyName(String value) {
        return this.property("BeanContext.beanTypePropertyName", value);
    }

    public ParserGroupBuilder defaultParser(Class<?> value) {
        return this.property("BeanContext.defaultParser", value);
    }

    public ParserGroupBuilder locale(Locale value) {
        return this.property("BeanContext.locale", value);
    }

    public ParserGroupBuilder timeZone(TimeZone value) {
        return this.property("BeanContext.timeZone", value);
    }

    public ParserGroupBuilder mediaType(MediaType value) {
        return this.property("BeanContext.mediaType", value);
    }

    public ParserGroupBuilder debug(boolean value) {
        return this.property("BeanContext.debug", value);
    }

    public ParserGroupBuilder classLoader(ClassLoader classLoader) {
        this.propertyStore.setClassLoader(classLoader);
        return this;
    }
}

