/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonSerializerContext;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializerSession;

public final class JsonSerializerSession
extends SerializerSession {
    private final boolean simpleMode;
    private final boolean escapeSolidus;
    private final boolean addBeanTypeProperties;

    protected JsonSerializerSession(JsonSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.simpleMode = ctx.simpleMode;
            this.escapeSolidus = ctx.escapeSolidus;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.simpleMode = op.getBoolean("JsonSerializer.simpleMode", ctx.simpleMode);
            this.escapeSolidus = op.getBoolean("JsonSerializer.escapeSolidus", ctx.escapeSolidus);
            this.addBeanTypeProperties = op.getBoolean("JsonSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
    }

    public final boolean isSimpleMode() {
        return this.simpleMode;
    }

    public final boolean isEscapeSolidus() {
        return this.escapeSolidus;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    @Override
    public JsonWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof JsonWriter) {
            return (JsonWriter)output;
        }
        return new JsonWriter(super.getWriter(), this.isUseWhitespace(), this.isEscapeSolidus(), this.getQuoteChar(), this.isSimpleMode(), this.isTrimStrings(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }
}

