/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.internal.ThrowableUtils;

public final class KeywordSet {
    final char[][][][] store = new char[26][][][];

    public KeywordSet(String ... keywords) {
        for (String keyword : keywords) {
            char[][] x2;
            char[][][] x1;
            if (keyword.length() < 2) {
                ThrowableUtils.illegalArg("Invalid keyword '{0}' passed to KeywordStore.", keyword);
            }
            int c0 = keyword.charAt(0) - 97;
            int c1 = keyword.charAt(1) - 97;
            if (c0 < 0 || c0 > 25 || c1 < 0 || c1 > 25) {
                ThrowableUtils.illegalArg("Invalid keyword '{0}' passed to KeywordStore.", keyword);
            }
            if (this.store[c0] == null) {
                this.store[c0] = new char[26][][];
            }
            if ((x1 = this.store[c0])[c1] == null) {
                x2 = new char[1][];
            } else {
                x2 = new char[x1[c1].length + 1][];
                System.arraycopy(x1[c1], 0, x2, 0, x1[c1].length);
            }
            x2[x2.length - 1] = keyword.toCharArray();
            x1[c1] = x2;
        }
    }

    public boolean contains(String s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        int c0 = s.charAt(0) - 97;
        int c1 = s.charAt(1) - 97;
        if (c0 < 0 || c0 > 25 || c1 < 0 || c1 > 25) {
            return false;
        }
        char[][][] x1 = this.store[c0];
        if (x1 == null) {
            return false;
        }
        char[][] x2 = x1[c1];
        if (x2 == null) {
            return false;
        }
        for (int i = 0; i < x2.length; ++i) {
            char[] keyword = x2[i];
            if (keyword.length != s.length()) continue;
            for (int j = 0; j < keyword.length; ++j) {
                if (keyword[j] == s.charAt(j)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

