/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.juneau.internal.ThrowableUtils;

public class FileUtils {
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final List<Locale> ROOT_LOCALE = Arrays.asList(Locale.ROOT);

    public static File mkdirs(File f, boolean clean) {
        ThrowableUtils.assertFieldNotNull(f, "f");
        if (f.exists()) {
            if (clean) {
                if (!FileUtils.delete(f)) {
                    throw new RuntimeException("Could not clean directory '" + f.getAbsolutePath() + "'");
                }
            } else {
                return f;
            }
        }
        if (!f.mkdirs()) {
            throw new RuntimeException("Could not create directory '" + f.getAbsolutePath() + "'");
        }
        return f;
    }

    public static File mkdirs(String path, boolean clean) {
        ThrowableUtils.assertFieldNotNull(path, "path");
        return FileUtils.mkdirs(new File(path), clean);
    }

    public static boolean delete(File f) {
        File[] cf;
        if (f == null) {
            return true;
        }
        if (f.isDirectory() && (cf = f.listFiles()) != null) {
            for (File c : cf) {
                FileUtils.delete(c);
            }
        }
        return f.delete();
    }

    public static void create(File f) {
        if (f.exists()) {
            return;
        }
        try {
            if (!f.createNewFile()) {
                throw new RuntimeException("Could not create file '" + f.getAbsolutePath() + "'");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyTimestamp(File f) {
        long l;
        long lm = f.lastModified();
        if (lm == (l = System.currentTimeMillis())) {
            ++l;
        }
        if (!f.setLastModified(l)) {
            throw new RuntimeException("Could not modify timestamp on file '" + f.getAbsolutePath() + "'");
        }
        if (lm == f.lastModified() && !f.setLastModified(l += 1000L)) {
            throw new RuntimeException("Could not modify timestamp on file '" + f.getAbsolutePath() + "'");
        }
    }

    public static File createTempFile(String name) throws IOException {
        String[] parts = name.split("\\.");
        File f = File.createTempFile(parts[0], "." + parts[1]);
        f.deleteOnExit();
        return f;
    }

    public static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static Iterable<String> getCandidateFileNames(final String fileName, final Locale l) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final Iterator<Locale> locales;
                    String baseName;
                    String ext;
                    {
                        this.locales = FileUtils.getCandidateLocales(l).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.locales.hasNext();
                    }

                    @Override
                    public String next() {
                        Locale l2 = this.locales.next();
                        if (l2.toString().isEmpty()) {
                            return fileName;
                        }
                        if (this.baseName == null) {
                            this.baseName = FileUtils.getBaseName(fileName);
                        }
                        if (this.ext == null) {
                            this.ext = FileUtils.getExtension(fileName);
                        }
                        return this.baseName + "_" + l2.toString() + (this.ext.isEmpty() ? "" : '.' + this.ext);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List<Locale> getCandidateLocales(Locale locale) {
        if (locale == null) {
            return ROOT_LOCALE;
        }
        return RB_CONTROL.getCandidateLocales("", locale);
    }
}

