/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ThrowableUtils;

public final class ArrayUtils {
    public static <T> T[] append(T[] array, T ... newElements) {
        int i;
        if (array == null) {
            return newElements;
        }
        if (newElements.length == 0) {
            return array;
        }
        Object[] a = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newElements.length);
        for (i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        for (i = 0; i < newElements.length; ++i) {
            a[i + array.length] = newElements[i];
        }
        return a;
    }

    public static <T> T[] append(T[] array, Collection<T> newElements) {
        ThrowableUtils.assertFieldNotNull(array, "array");
        if (newElements.size() == 0) {
            return array;
        }
        Object[] a = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newElements.size());
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        int l = array.length;
        for (T t : newElements) {
            a[l++] = t;
        }
        return a;
    }

    public static <T> T[] combine(T[] ... arrays) {
        ThrowableUtils.assertFieldNotNull(arrays, "arrays");
        int l = 0;
        T[] a1 = null;
        for (T[] a : arrays) {
            if (a1 == null && a != null) {
                a1 = a;
            }
            l += a == null ? 0 : a.length;
        }
        if (a1 == null) {
            return null;
        }
        Object[] a = (Object[])Array.newInstance(a1.getClass().getComponentType(), l);
        int i = 0;
        for (T[] aa : arrays) {
            if (aa == null) continue;
            for (T t : aa) {
                a[i++] = t;
            }
        }
        return a;
    }

    public static <T> T[] reverse(T[] array) {
        ThrowableUtils.assertFieldNotNull(array, "array");
        Class<?> c = array.getClass().getComponentType();
        Object[] a2 = (Object[])Array.newInstance(c, array.length);
        for (int i = 0; i < array.length; ++i) {
            a2[a2.length - i - 1] = array[i];
        }
        return a2;
    }

    public static <T> Set<T> asSet(final T[] array) {
        ThrowableUtils.assertFieldNotNull(array, "array");
        return new AbstractSet<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        if (this.i >= array.length) {
                            throw new NoSuchElementException();
                        }
                        Object t = array[this.i];
                        ++this.i;
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static Iterator<Object> iterator(final Object array) {
        return new Iterator<Object>(){
            int i = 0;
            int length = array == null ? 0 : Array.getLength(array);

            @Override
            public boolean hasNext() {
                return this.i < this.length;
            }

            @Override
            public Object next() {
                if (this.i >= this.length) {
                    throw new NoSuchElementException();
                }
                return Array.get(array, this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Object toArray(Collection<?> c, Class<T> componentType) {
        Object a = Array.newInstance(componentType, c.size());
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Array.set(a, i++, it.next());
        }
        return a;
    }

    public static <T> T[] toObjectArray(Collection<?> c, Class<T> componentType) {
        Object a = Array.newInstance(componentType, c.size());
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Array.set(a, i++, it.next());
        }
        return (Object[])a;
    }

    public static void copyToList(Object array, List list) {
        if (array != null) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
        }
    }

    public static <T> boolean contains(T element, T[] array) {
        return ArrayUtils.indexOf(element, array) != -1;
    }

    public static <T> int indexOf(T element, T[] array) {
        if (element == null) {
            return -1;
        }
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static Object toPrimitiveArray(Object o) {
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            throw new IllegalArgumentException("Cannot pass non-array objects to toPrimitiveArray()");
        }
        int l = Array.getLength(o);
        Class<?> tc = ClassUtils.getPrimitiveForWrapper(c.getComponentType());
        if (tc == null) {
            throw new IllegalArgumentException("Array type is not a primitive wrapper array.");
        }
        Object a = Array.newInstance(tc, l);
        for (int i = 0; i < l; ++i) {
            Array.set(a, i, Array.get(o, i));
        }
        return a;
    }
}

