/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.html.HtmlParserBuilder;
import org.apache.juneau.html.HtmlParserContext;
import org.apache.juneau.html.HtmlParserSession;
import org.apache.juneau.html.HtmlTag;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlUtils;

@Consumes(value="text/html,text/html+stripped")
public class HtmlParser
extends XmlParser {
    public static final HtmlParser DEFAULT = new HtmlParser(PropertyStore.create());
    private final HtmlParserContext ctx = this.createContext(HtmlParserContext.class);

    public HtmlParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public HtmlParserBuilder builder() {
        return new HtmlParserBuilder(this.propertyStore);
    }

    private <T> T parseAnything(HtmlParserSession session, ClassMeta<T> eType, XMLStreamReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws Exception {
        HtmlTag tag;
        boolean isEmpty;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, Object> transform = eType.getPojoSwap();
        ClassMeta<Object> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        int event = r.getEventType();
        if (event != 1) {
            throw new XMLStreamException("parseAnything must be called on outer start element.", r.getLocation());
        }
        if (!isRoot) {
            event = r.next();
        }
        boolean bl = isEmpty = event == 2;
        if (!isEmpty) {
            event = HtmlParser.skipWs(r);
        }
        if (event == 8) {
            throw new XMLStreamException("Unexpected end of stream in parseAnything for type '" + eType + "'", r.getLocation());
        }
        HtmlClassMeta hcm = sType.getExtendedMeta(HtmlClassMeta.class);
        if (hcm.isAsXml()) {
            return (T)super.parseAnything(session, eType, null, r, outer, false, pMeta);
        }
        Object o = null;
        boolean isValid = true;
        HtmlTag htmlTag = tag = event == 4 ? null : HtmlTag.forString(r.getName().getLocalPart(), false);
        if (tag == HtmlTag.HTML) {
            tag = HtmlParser.skipToData(r);
        }
        if (isEmpty) {
            o = "";
        } else if (tag == null || tag.isOneOf(HtmlTag.BR, HtmlTag.BS, HtmlTag.FF, HtmlTag.SP)) {
            String text = session.parseText(r);
            if (sType.isObject() || sType.isCharSequence()) {
                o = text;
            } else if (sType.isChar()) {
                o = Character.valueOf(text.charAt(0));
            } else if (sType.isBoolean()) {
                o = Boolean.parseBoolean(text);
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber(text, eType.getInnerClass());
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, text);
            } else if (sType.canCreateNewInstanceFromNumber(outer)) {
                o = sType.newInstanceFromNumber(session, outer, StringUtils.parseNumber(text, sType.getNewInstanceFromNumberClass()));
            } else {
                isValid = false;
            }
        } else if (tag == HtmlTag.STRING) {
            String text = session.getElementText(r);
            if (sType.isObject() || sType.isCharSequence()) {
                o = text;
            } else if (sType.isChar()) {
                o = Character.valueOf(text.charAt(0));
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, text);
            } else if (sType.canCreateNewInstanceFromNumber(outer)) {
                o = sType.newInstanceFromNumber(session, outer, StringUtils.parseNumber(text, sType.getNewInstanceFromNumberClass()));
            } else {
                isValid = false;
            }
            HtmlParser.skipTag(r, HtmlTag.xSTRING);
        } else if (tag == HtmlTag.NUMBER) {
            String text = session.getElementText(r);
            if (sType.isObject()) {
                o = StringUtils.parseNumber(text, Number.class);
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber(text, sType.getInnerClass());
            } else if (sType.canCreateNewInstanceFromNumber(outer)) {
                o = sType.newInstanceFromNumber(session, outer, StringUtils.parseNumber(text, sType.getNewInstanceFromNumberClass()));
            } else {
                isValid = false;
            }
            HtmlParser.skipTag(r, HtmlTag.xNUMBER);
        } else if (tag == HtmlTag.BOOLEAN) {
            String text = session.getElementText(r);
            if (sType.isObject() || sType.isBoolean()) {
                o = Boolean.parseBoolean(text);
            } else {
                isValid = false;
            }
            HtmlParser.skipTag(r, HtmlTag.xBOOLEAN);
        } else if (tag == HtmlTag.P) {
            String text = session.getElementText(r);
            if (!"No Results".equals(text)) {
                isValid = false;
            }
            HtmlParser.skipTag(r, HtmlTag.xP);
        } else if (tag == HtmlTag.NULL) {
            HtmlParser.skipTag(r, HtmlTag.NULL);
            HtmlParser.skipTag(r, HtmlTag.xNULL);
        } else if (tag == HtmlTag.A) {
            o = HtmlParser.parseAnchor(session, r, eType);
            HtmlParser.skipTag(r, HtmlTag.xA);
        } else if (tag == HtmlTag.TABLE) {
            String typeName = HtmlParser.getAttribute(r, session.getBeanTypePropertyName(eType), "object");
            ClassMeta<?> cm = session.getClassMeta(typeName, pMeta, eType);
            if (cm != null) {
                eType = cm;
                sType = eType;
                typeName = sType.isArray() ? "array" : "object";
            } else if (!"array".equals(typeName)) {
                typeName = "object";
            }
            if (typeName.equals("object")) {
                if (sType.isObject()) {
                    o = this.parseIntoMap(session, r, new ObjectMap(session), sType.getKeyType(), sType.getValueType(), pMeta);
                } else if (sType.isMap()) {
                    o = this.parseIntoMap(session, r, (Map)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectMap(session)), sType.getKeyType(), sType.getValueType(), pMeta);
                } else if (sType.canCreateNewBean(outer)) {
                    BeanMap<?> m = session.newBeanMap(outer, sType.getInnerClass());
                    o = this.parseIntoBean(session, r, m).getBean();
                } else {
                    isValid = false;
                }
                HtmlParser.skipTag(r, HtmlTag.xTABLE);
            } else if (typeName.equals("array")) {
                if (sType.isObject()) {
                    o = this.parseTableIntoCollection(session, r, new ObjectList(session), sType, pMeta);
                } else if (sType.isCollection()) {
                    o = this.parseTableIntoCollection(session, r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectList(session)), sType, pMeta);
                } else if (sType.isArray() || sType.isArgs()) {
                    ArrayList l = (ArrayList)this.parseTableIntoCollection(session, r, new ArrayList(), sType, pMeta);
                    o = session.toArray(sType, l);
                } else {
                    isValid = false;
                }
                HtmlParser.skipTag(r, HtmlTag.xTABLE);
            } else {
                isValid = false;
            }
        } else if (tag == HtmlTag.UL) {
            String typeName = HtmlParser.getAttribute(r, session.getBeanTypePropertyName(eType), "array");
            ClassMeta<?> cm = session.getClassMeta(typeName, pMeta, eType);
            if (cm != null) {
                eType = cm;
                sType = eType;
            }
            if (sType.isObject()) {
                o = this.parseIntoCollection(session, r, new ObjectList(session), sType, pMeta);
            } else if (sType.isCollection() || sType.isObject()) {
                o = this.parseIntoCollection(session, r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectList(session)), sType, pMeta);
            } else if (sType.isArray() || sType.isArgs()) {
                o = session.toArray(sType, this.parseIntoCollection(session, r, new ArrayList(), sType, pMeta));
            } else {
                isValid = false;
            }
            HtmlParser.skipTag(r, HtmlTag.xUL);
        }
        if (!isValid) {
            throw new XMLStreamException("Unexpected tag '" + (Object)((Object)tag) + "' for type '" + eType + "'", r.getLocation());
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer != null) {
            this.setParent(eType, o, outer);
        }
        HtmlParser.skipWs(r);
        return (T)o;
    }

    private static HtmlTag skipToData(XMLStreamReader r) throws XMLStreamException {
        boolean isEmpty;
        int event;
        while ((event = r.next()) != 1 || !"div".equals(r.getLocalName()) || !"data".equals(r.getAttributeValue(null, "id"))) {
        }
        r.nextTag();
        event = r.getEventType();
        boolean bl = isEmpty = event == 2;
        if (!isEmpty) {
            event = HtmlParser.skipWs(r);
        }
        if (event == 8) {
            throw new XMLStreamException("Unexpected end of stream looking for data.", r.getLocation());
        }
        return event == 4 ? null : HtmlTag.forString(r.getName().getLocalPart(), false);
    }

    private static String getAttribute(XMLStreamReader r, String name, String def) {
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            if (!r.getAttributeLocalName(i).equals(name)) continue;
            return r.getAttributeValue(i);
        }
        return def;
    }

    private static <T> T parseAnchor(HtmlParserSession session, XMLStreamReader r, ClassMeta<T> beanType) throws XMLStreamException {
        String href = r.getAttributeValue(null, "href");
        String name = session.getElementText(r);
        Class<T> beanClass = beanType.getInnerClass();
        if (beanClass.isAnnotationPresent(HtmlLink.class)) {
            HtmlLink h = beanClass.getAnnotation(HtmlLink.class);
            BeanMap<T> m = session.newBeanMap(beanClass);
            m.put(h.hrefProperty(), (Object)href);
            m.put(h.nameProperty(), (Object)name);
            return m.getBean();
        }
        return session.convertToType((Object)href, beanType);
    }

    private static Map<String, String> getAttributes(XMLStreamReader r) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            m.put(r.getAttributeLocalName(i), r.getAttributeValue(i));
        }
        return m;
    }

    private <K, V> Map<K, V> parseIntoMap(HtmlParserSession session, XMLStreamReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        HtmlTag tag;
        while ((tag = HtmlParser.nextTag(r, HtmlTag.TR, HtmlTag.xTABLE)) != HtmlTag.xTABLE) {
            tag = HtmlParser.nextTag(r, HtmlTag.TD, HtmlTag.TH);
            if (tag == HtmlTag.TH) {
                HtmlParser.skipTag(r);
                r.nextTag();
                HtmlParser.skipTag(r);
            } else {
                K key = this.parseAnything(session, keyType, r, m, false, pMeta);
                HtmlParser.nextTag(r, HtmlTag.TD);
                V value = this.parseAnything(session, valueType, r, m, false, pMeta);
                this.setName(valueType, value, key);
                m.put(key, value);
            }
            HtmlParser.nextTag(r, HtmlTag.xTR);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(HtmlParserSession session, XMLStreamReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        HtmlTag tag;
        int argIndex = 0;
        while ((tag = HtmlParser.nextTag(r, HtmlTag.LI, HtmlTag.xUL)) != HtmlTag.xUL) {
            ClassMeta<?> elementType = type.isArgs() ? type.getArg(argIndex++) : type.getElementType();
            l.add(this.parseAnything(session, elementType, r, l, false, pMeta));
        }
        return l;
    }

    private <E> Collection<E> parseTableIntoCollection(HtmlParserSession session, XMLStreamReader r, Collection<E> l, ClassMeta<E> type, BeanPropertyMeta pMeta) throws Exception {
        HtmlTag tag = HtmlParser.nextTag(r, HtmlTag.TR);
        ArrayList<String> keys = new ArrayList<String>();
        while ((tag = HtmlParser.nextTag(r, HtmlTag.TH, HtmlTag.xTR)) != HtmlTag.xTR) {
            keys.add(session.getElementText(r));
        }
        int argIndex = 0;
        while (true) {
            Object value;
            r.nextTag();
            tag = HtmlTag.forEvent(r);
            if (tag == HtmlTag.xTABLE) break;
            ClassMeta<Object> elementType = null;
            String beanType = HtmlParser.getAttribute(r, session.getBeanTypePropertyName(type), null);
            if (beanType != null) {
                elementType = session.getClassMeta(beanType, pMeta, null);
            }
            if (elementType == null) {
                ClassMeta<Object> classMeta = elementType = type.isArgs() ? type.getArg(argIndex++) : type.getElementType();
            }
            if (elementType == null) {
                elementType = session.object();
            }
            if (elementType.canCreateNewBean(l)) {
                BeanMap<Object> m = session.newBeanMap(l, elementType.getInnerClass());
                for (int i = 0; i < keys.size(); ++i) {
                    tag = HtmlParser.nextTag(r, HtmlTag.TD, HtmlTag.NULL);
                    if (tag == HtmlTag.NULL) {
                        m = null;
                        HtmlParser.nextTag(r, HtmlTag.xNULL);
                        break;
                    }
                    String key = (String)keys.get(i);
                    BeanMapEntry e = m.getProperty(key);
                    if (e == null) {
                        this.parseAnything(session, this.object(), r, l, false, null);
                        continue;
                    }
                    BeanPropertyMeta bpm = e.getMeta();
                    ClassMeta<?> cm = bpm.getClassMeta();
                    value = this.parseAnything(session, cm, r, m.getBean(false), false, bpm);
                    this.setName(cm, value, key);
                    bpm.set(m, value);
                }
                l.add(m == null ? null : m.getBean());
            } else {
                String c = HtmlParser.getAttributes(r).get(session.getBeanTypePropertyName(type.getElementType()));
                Map m = (Map)(elementType.isMap() && elementType.canCreateNewInstance(l) ? elementType.newInstance(l) : new ObjectMap(session));
                for (int i = 0; i < keys.size(); ++i) {
                    tag = HtmlParser.nextTag(r, HtmlTag.TD, HtmlTag.NULL);
                    if (tag == HtmlTag.NULL) {
                        m = null;
                        HtmlParser.nextTag(r, HtmlTag.xNULL);
                        break;
                    }
                    String key = (String)keys.get(i);
                    if (m == null) continue;
                    ClassMeta<?> kt = elementType.getKeyType();
                    ClassMeta<?> vt = elementType.getValueType();
                    value = this.parseAnything(session, vt, r, l, false, pMeta);
                    this.setName(vt, value, key);
                    m.put(session.convertToType((Object)key, kt), value);
                }
                if (m != null && c != null) {
                    ObjectMap m2 = m instanceof ObjectMap ? (ObjectMap)m : new ObjectMap((Map<?, ?>)m).setBeanSession(session);
                    m2.put(session.getBeanTypePropertyName(type.getElementType()), c);
                    l.add(session.cast(m2, pMeta, elementType));
                } else {
                    l.add(m);
                }
            }
            HtmlParser.nextTag(r, HtmlTag.xTR);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBean(HtmlParserSession session, XMLStreamReader r, BeanMap<T> m) throws Exception {
        HtmlTag tag;
        while ((tag = HtmlParser.nextTag(r, HtmlTag.TR, HtmlTag.xTABLE)) != HtmlTag.xTABLE) {
            tag = HtmlParser.nextTag(r, HtmlTag.TD, HtmlTag.TH);
            if (tag == HtmlTag.TH) {
                HtmlParser.skipTag(r);
                r.nextTag();
                HtmlParser.skipTag(r);
            } else {
                String key = session.getElementText(r);
                HtmlParser.nextTag(r, HtmlTag.TD);
                BeanPropertyMeta pMeta = m.getPropertyMeta(key);
                if (pMeta == null) {
                    this.onUnknownProperty(session, key, m, -1, -1);
                    this.parseAnything(session, this.object(), r, null, false, null);
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    Object value = this.parseAnything(session, cm, r, m.getBean(false), false, pMeta);
                    this.setName(cm, value, key);
                    pMeta.set(m, value);
                }
            }
            HtmlParser.nextTag(r, HtmlTag.xTR);
        }
        return m;
    }

    private static HtmlTag nextTag(XMLStreamReader r, HtmlTag ... expected) throws XMLStreamException {
        int et = r.next();
        while (et != 1 && et != 2 && et != 8) {
            et = r.next();
        }
        if (et == 8) {
            throw new XMLStreamException("Unexpected end of document: " + r.getLocation());
        }
        HtmlTag tag = HtmlTag.forEvent(r);
        if (expected.length == 0) {
            return tag;
        }
        for (HtmlTag t : expected) {
            if (t != tag) continue;
            return tag;
        }
        throw new XMLStreamException("Unexpected tag: " + (Object)((Object)tag) + ".  Expected one of the following: " + JsonSerializer.DEFAULT.toString(expected), r.getLocation());
    }

    private static void skipTag(XMLStreamReader r) throws XMLStreamException {
        int et = r.getEventType();
        if (et != 1) {
            throw new XMLStreamException("skipToNextTag() call on invalid event [" + XmlUtils.toReadableEvent(r) + "].  Must only be called on START_ELEMENT events.");
        }
        String n = r.getLocalName();
        int depth = 0;
        while (true) {
            String n2;
            if ((et = r.next()) == 1) {
                n2 = r.getLocalName();
                if (!n.equals(n2)) continue;
                ++depth;
                continue;
            }
            if (et != 2) continue;
            n2 = r.getLocalName();
            if (n.equals(n2)) {
                --depth;
            }
            if (depth < 0) break;
        }
    }

    private static void skipTag(XMLStreamReader r, HtmlTag ... expected) throws XMLStreamException {
        HtmlTag tag = HtmlTag.forEvent(r);
        if (!tag.isOneOf(expected)) {
            throw new XMLStreamException("Unexpected tag: " + (Object)((Object)tag) + ".  Expected one of the following: " + JsonSerializer.DEFAULT.toString(expected), r.getLocation());
        }
        r.next();
    }

    private static int skipWs(XMLStreamReader r) throws XMLStreamException {
        int event = r.getEventType();
        while (event != 1 && event != 2 && event != 8 && r.isWhiteSpace()) {
            event = r.next();
        }
        return event;
    }

    @Override
    public HtmlParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new HtmlParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseAnything(s, type, s.getXmlStreamReader(), s.getOuter(), true, null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseIntoMap(s, s.getXmlStreamReader(), m, s.getClassMeta(keyType, new Type[0]), s.getClassMeta(valueType, new Type[0]), null);
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseIntoCollection(s, s.getXmlStreamReader(), c, s.getClassMeta(elementType, new Type[0]), null);
    }
}

