/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.MediaType;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.StringUtils;

public final class HtmlDocSerializerSession
extends HtmlSerializerSession {
    private final String title;
    private final String text;
    private final String cssUrl;
    private final String[] cssImports;
    private final Map<String, String> links;
    private final boolean nowrap;

    protected HtmlDocSerializerSession(HtmlDocSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType);
        if (op == null || op.isEmpty()) {
            this.title = ctx.title;
            this.text = ctx.text;
            this.links = ctx.links;
            this.cssUrl = ctx.cssUrl;
            this.cssImports = ctx.cssImports;
            this.nowrap = ctx.nowrap;
        } else {
            this.title = op.getString("HtmlSerializer.title", ctx.title);
            this.text = op.getString("HtmlSerializer.description", ctx.text);
            this.links = new LinkedHashMap(op.getMap("HtmlDocSerializer.links.map", ctx.links));
            this.cssUrl = op.getString("HtmlDocSerializer.cssUrl", ctx.cssUrl);
            this.cssImports = StringUtils.split(op.getString("HtmlDocSerializer.cssImports.list", null), ',');
            this.nowrap = op.getBoolean("HtmlDocSerializer.cssUrl", ctx.nowrap);
        }
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getText() {
        return this.text;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getCssUrl() {
        return this.cssUrl;
    }

    public final String[] getCssImports() {
        return this.cssImports;
    }

    public final boolean isNoWrap() {
        return this.nowrap;
    }

    @Override
    public HtmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        return new HtmlWriter(super.getWriter(), this.isUseWhitespace(), this.isTrimStrings(), this.getQuoteChar(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }
}

