/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.PojoRest;

public class ObjectList
extends LinkedList<Object> {
    private static final long serialVersionUID = 1L;
    private transient BeanSession session = null;
    private transient PojoRest pojoRest;
    public static final ObjectList EMPTY_LIST = new ObjectList(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<Object> listIterator(int location) {
            return Collections.emptyList().listIterator(location);
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Object> subList(int start, int end) {
            return Collections.emptyList().subList(start, end);
        }
    };

    public ObjectList(CharSequence s, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT.createSession() : p.getBeanContext().createSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (s != null) {
            p.parseIntoCollection(s, this, this.session.object());
        }
    }

    public ObjectList(CharSequence s) throws ParseException {
        this(s, null);
    }

    public ObjectList(Reader r, Parser p) throws ParseException, IOException {
        this.parseReader(r, p);
    }

    private void parseReader(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoCollection(r, this, this.session.object());
    }

    public ObjectList() {
        this(BeanContext.DEFAULT.createSession());
    }

    public ObjectList(BeanSession session) {
        this.session = session;
    }

    public ObjectList(Object ... o) {
        super(Arrays.asList(o));
    }

    public ObjectList(Collection<?> c) {
        super(c);
    }

    public ObjectList setBeanSession(BeanSession session) {
        this.session = session;
        return this;
    }

    public ObjectList append(Object ... o) {
        for (Object o2 : o) {
            this.add(o2);
        }
        return this;
    }

    public <T> T get(Class<T> type, int index) {
        return this.session.convertToType(this.get(index), type);
    }

    public String getString(int index) {
        return this.get(String.class, index);
    }

    public Integer getInt(int index) {
        return this.get(Integer.class, index);
    }

    public Boolean getBoolean(int index) {
        return this.get(Boolean.class, index);
    }

    public Long getLong(int index) {
        return this.get(Long.class, index);
    }

    public Map<?, ?> getMap(int index) {
        return this.get(Map.class, index);
    }

    public List<?> getList(int index) {
        return this.get(List.class, index);
    }

    public ObjectMap getObjectMap(int index) {
        return this.get(ObjectMap.class, index);
    }

    public ObjectList getObjectList(int index) {
        return this.get(ObjectList.class, index);
    }

    public <T> T getAt(Class<T> type, String path) {
        return this.getPojoRest().get(type, path);
    }

    public Object putAt(String path, Object o) {
        return this.getPojoRest().put(path, o);
    }

    public Object postAt(String path, Object o) {
        return this.getPojoRest().post(path, o);
    }

    public Object deleteAt(String path) {
        return this.getPojoRest().delete(path);
    }

    public <E> Iterable<E> elements(final Class<E> childType) {
        final Iterator i = this.iterator();
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public E next() {
                        return ObjectList.this.session.convertToType(i.next(), childType);
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    public ClassMeta<?> getClassMeta(int index) {
        return this.session.getClassMetaForObject(this.get(index));
    }

    private PojoRest getPojoRest() {
        if (this.pojoRest == null) {
            this.pojoRest = new PojoRest(this);
        }
        return this.pojoRest;
    }

    public String toString(WriterSerializer serializer) throws SerializeException {
        return serializer.serialize(this);
    }

    @Override
    public String toString() {
        try {
            return this.toString(JsonSerializer.DEFAULT_LAX);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }

    public void serializeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this);
    }
}

