/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanProxyInvocationHandler;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.Delegate;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.annotation.Pojo;
import org.apache.juneau.annotation.URI;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.remoteable.RemoteMethod;
import org.apache.juneau.remoteable.Remoteable;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.AnnotationBeanFilterBuilder;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.MetadataMap;

@Bean(properties="innerClass,classCategory,elementType,keyType,valueType,notABeanReason,initException,beanMeta")
public final class ClassMeta<T>
implements Type {
    final Class<T> innerClass;
    private final Class<? extends T> implClass;
    private final ClassCategory cc;
    private final Method fromStringMethod;
    private final Constructor<? extends T> noArgConstructor;
    private final Constructor<T> stringConstructor;
    private final Constructor<T> numberConstructor;
    private final Constructor<T> swapConstructor;
    private final Class<?> swapMethodType;
    private final Class<?> numberConstructorType;
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Method namePropertyMethod;
    private final Method parentPropertyMethod;
    private final boolean isDelegate;
    private final boolean isAbstract;
    private final boolean isMemberClass;
    private final Object primitiveDefault;
    private final Map<String, Method> remoteableMethods;
    private final Map<String, Method> publicMethods;
    private final PojoSwap<?, ?>[] childPojoSwaps;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
    private final PojoSwap<T, ?> pojoSwap;
    private final BeanFilter beanFilter;
    private final MetadataMap extMeta;
    private final BeanContext beanContext;
    private final ClassMeta<?> serializedClassMeta;
    private final ClassMeta<?> elementType;
    private final ClassMeta<?> keyType;
    private final ClassMeta<?> valueType;
    private final BeanMeta<T> beanMeta;
    private final String typePropertyName;
    private final String notABeanReason;
    private final String dictionaryName;
    private final Throwable initException;
    private final InvocationHandler invocationHandler;
    private final BeanRegistry beanRegistry;
    private final ClassMeta<?>[] args;
    private static final Boolean BOOLEAN_DEFAULT = false;
    private static final Character CHARACTER_DEFAULT = Character.valueOf('\u0000');
    private static final Short SHORT_DEFAULT = 0;
    private static final Integer INTEGER_DEFAULT = 0;
    private static final Long LONG_DEFAULT = 0L;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Byte BYTE_DEFAULT = 0;

    ClassMeta(Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?> pojoSwap, PojoSwap<?, ?>[] childPojoSwaps) {
        this.innerClass = innerClass;
        this.beanContext = beanContext;
        if (beanContext != null && beanContext.cmCache != null) {
            beanContext.cmCache.put(innerClass, this);
        }
        ClassMetaBuilder builder = new ClassMetaBuilder(this, innerClass, beanContext, implClass, beanFilter, pojoSwap, childPojoSwaps);
        this.cc = builder.cc;
        this.isDelegate = builder.isDelegate;
        this.fromStringMethod = builder.fromStringMethod;
        this.swapMethod = builder.swapMethod;
        this.unswapMethod = builder.unswapMethod;
        this.swapMethodType = builder.swapMethodType;
        this.parentPropertyMethod = builder.parentPropertyMethod;
        this.namePropertyMethod = builder.namePropertyMethod;
        this.noArgConstructor = builder.noArgConstructor;
        this.stringConstructor = builder.stringConstructor;
        this.swapConstructor = builder.swapConstructor;
        this.numberConstructor = builder.numberConstructor;
        this.numberConstructorType = builder.numberConstructorType;
        this.primitiveDefault = builder.primitiveDefault;
        this.publicMethods = builder.publicMethods;
        this.remoteableMethods = builder.remoteableMethods;
        this.beanFilter = beanFilter;
        this.pojoSwap = builder.pojoSwap;
        this.extMeta = new MetadataMap();
        this.keyType = builder.keyType;
        this.valueType = builder.valueType;
        this.elementType = builder.elementType;
        this.notABeanReason = builder.notABeanReason;
        this.beanMeta = builder.beanMeta;
        this.initException = builder.initException;
        this.typePropertyName = builder.typePropertyName;
        this.dictionaryName = builder.dictionaryName;
        this.serializedClassMeta = builder.serializedClassMeta;
        this.invocationHandler = builder.invocationHandler;
        this.beanRegistry = builder.beanRegistry;
        this.isMemberClass = builder.isMemberClass;
        this.isAbstract = builder.isAbstract;
        this.implClass = builder.implClass;
        this.childUnswapMap = builder.childUnswapMap;
        this.childSwapMap = builder.childSwapMap;
        this.childPojoSwaps = builder.childPojoSwaps;
        this.args = null;
    }

    ClassMeta(ClassMeta<T> mainType, ClassMeta<?> keyType, ClassMeta<?> valueType, ClassMeta<?> elementType) {
        this.innerClass = mainType.innerClass;
        this.implClass = mainType.implClass;
        this.childPojoSwaps = mainType.childPojoSwaps;
        this.childSwapMap = mainType.childSwapMap;
        this.childUnswapMap = mainType.childUnswapMap;
        this.cc = mainType.cc;
        this.fromStringMethod = mainType.fromStringMethod;
        this.noArgConstructor = mainType.noArgConstructor;
        this.stringConstructor = mainType.stringConstructor;
        this.numberConstructor = mainType.numberConstructor;
        this.swapConstructor = mainType.swapConstructor;
        this.swapMethodType = mainType.swapMethodType;
        this.numberConstructorType = mainType.numberConstructorType;
        this.swapMethod = mainType.swapMethod;
        this.unswapMethod = mainType.unswapMethod;
        this.namePropertyMethod = mainType.namePropertyMethod;
        this.parentPropertyMethod = mainType.parentPropertyMethod;
        this.isDelegate = mainType.isDelegate;
        this.isAbstract = mainType.isAbstract;
        this.isMemberClass = mainType.isMemberClass;
        this.primitiveDefault = mainType.primitiveDefault;
        this.remoteableMethods = mainType.remoteableMethods;
        this.publicMethods = mainType.publicMethods;
        this.beanContext = mainType.beanContext;
        this.serializedClassMeta = this;
        this.elementType = elementType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.invocationHandler = mainType.invocationHandler;
        this.beanMeta = mainType.beanMeta;
        this.typePropertyName = mainType.typePropertyName;
        this.dictionaryName = mainType.dictionaryName;
        this.notABeanReason = mainType.notABeanReason;
        this.pojoSwap = mainType.pojoSwap;
        this.beanFilter = mainType.beanFilter;
        this.extMeta = mainType.extMeta;
        this.initException = mainType.initException;
        this.beanRegistry = mainType.beanRegistry;
        this.args = null;
    }

    ClassMeta(ClassMeta<?>[] args) {
        this.innerClass = Object[].class;
        this.args = args;
        this.implClass = null;
        this.childPojoSwaps = null;
        this.childSwapMap = null;
        this.childUnswapMap = null;
        this.cc = ClassCategory.ARGS;
        this.fromStringMethod = null;
        this.noArgConstructor = null;
        this.stringConstructor = null;
        this.numberConstructor = null;
        this.swapConstructor = null;
        this.swapMethodType = null;
        this.numberConstructorType = null;
        this.swapMethod = null;
        this.unswapMethod = null;
        this.namePropertyMethod = null;
        this.parentPropertyMethod = null;
        this.isDelegate = false;
        this.isAbstract = false;
        this.isMemberClass = false;
        this.primitiveDefault = null;
        this.remoteableMethods = null;
        this.publicMethods = null;
        this.beanContext = null;
        this.serializedClassMeta = this;
        this.elementType = null;
        this.keyType = null;
        this.valueType = null;
        this.invocationHandler = null;
        this.beanMeta = null;
        this.typePropertyName = null;
        this.dictionaryName = null;
        this.notABeanReason = null;
        this.pojoSwap = null;
        this.beanFilter = null;
        this.extMeta = new MetadataMap();
        this.initException = null;
        this.beanRegistry = null;
    }

    public String getBeanTypePropertyName() {
        return this.typePropertyName;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public ClassCategory getClassCategory() {
        return this.cc;
    }

    public boolean isAssignableFrom(Class<?> c) {
        return ClassUtils.isParentClass(this.innerClass, c);
    }

    public boolean isInstanceOf(Class<?> c) {
        return ClassUtils.isParentClass(c, this.innerClass);
    }

    protected boolean hasChildPojoSwaps() {
        return this.childPojoSwaps != null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForSwap(Class<?> normalClass) {
        if (this.childSwapMap != null) {
            PojoSwap s = this.childSwapMap.get(normalClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !ClassUtils.isParentClass(pojoSwap.getNormalClass(), normalClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childSwapMap.putIfAbsent(normalClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForUnswap(Class<?> swapClass) {
        if (this.childUnswapMap != null) {
            PojoSwap s = this.childUnswapMap.get(swapClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !ClassUtils.isParentClass(pojoSwap.getSwapClass(), swapClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childUnswapMap.putIfAbsent(swapClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected static <T> Constructor<? extends T> findNoArgConstructor(Class<?> c, Visibility v) {
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            mod = cc.getModifiers();
            if (cc.getParameterTypes().length != (isMemberClass ? 1 : 0) || !v.isVisible(mod) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    public Class<T> getInnerClass() {
        return this.innerClass;
    }

    @BeanIgnore
    public ClassMeta<?> getSerializedClassMeta() {
        return this.serializedClassMeta;
    }

    public ClassMeta<?> getElementType() {
        return this.elementType;
    }

    public ClassMeta<?> getKeyType() {
        return this.keyType;
    }

    public ClassMeta<?> getValueType() {
        return this.valueType;
    }

    public boolean isDelegate() {
        return this.isDelegate;
    }

    public boolean isMap() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP;
    }

    public boolean isMapOrBean() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP || this.beanMeta != null;
    }

    public boolean isBeanMap() {
        return this.cc == ClassCategory.BEANMAP;
    }

    public boolean isCollection() {
        return this.cc == ClassCategory.COLLECTION;
    }

    public boolean isCollectionOrArray() {
        return this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.ARRAY;
    }

    public boolean isClass() {
        return this.cc == ClassCategory.CLASS;
    }

    public boolean isEnum() {
        return this.cc == ClassCategory.ENUM;
    }

    public boolean isArray() {
        return this.cc == ClassCategory.ARRAY;
    }

    public boolean isBean() {
        return this.beanMeta != null;
    }

    public boolean isObject() {
        return this.cc == ClassCategory.OBJ;
    }

    public boolean isNotObject() {
        return this.cc != ClassCategory.OBJ;
    }

    public boolean isNumber() {
        return this.cc == ClassCategory.NUMBER || this.cc == ClassCategory.DECIMAL;
    }

    public boolean isDecimal() {
        return this.cc == ClassCategory.DECIMAL;
    }

    public boolean isBoolean() {
        return this.cc == ClassCategory.BOOLEAN;
    }

    public boolean isCharSequence() {
        return this.cc == ClassCategory.STR || this.cc == ClassCategory.CHARSEQ;
    }

    public boolean isString() {
        return this.cc == ClassCategory.STR;
    }

    public boolean isChar() {
        return this.cc == ClassCategory.CHAR;
    }

    public boolean isPrimitive() {
        return this.innerClass.isPrimitive();
    }

    public boolean isDate() {
        return this.cc == ClassCategory.DATE;
    }

    public boolean isUri() {
        return this.cc == ClassCategory.URI;
    }

    public boolean isReader() {
        return this.cc == ClassCategory.READER;
    }

    public boolean isInputStream() {
        return this.cc == ClassCategory.INPUTSTREAM;
    }

    public boolean isVoid() {
        return this.cc == ClassCategory.VOID;
    }

    public boolean isArgs() {
        return this.cc == ClassCategory.ARGS;
    }

    public ClassMeta<?>[] getArgs() {
        return this.args;
    }

    public ClassMeta<?> getArg(int index) {
        if (this.args != null && index >= 0 && index < this.args.length) {
            return this.args[index];
        }
        throw new BeanRuntimeException("Invalid argument index specified:  {0}.  Only {1} arguments are defined.", index, this.args == null ? 0 : this.args.length);
    }

    public boolean isNullable() {
        if (this.innerClass.isPrimitive()) {
            return this.cc == ClassCategory.CHAR;
        }
        return true;
    }

    public boolean isRemoteable() {
        return this.remoteableMethods != null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public Map<String, Method> getRemoteableMethods() {
        return this.remoteableMethods;
    }

    public Map<String, Method> getPublicMethods() {
        return this.publicMethods;
    }

    public PojoSwap<T, ?> getPojoSwap() {
        return this.pojoSwap;
    }

    public BeanMeta<T> getBeanMeta() {
        return this.beanMeta;
    }

    public Constructor<? extends T> getConstructor() {
        return this.noArgConstructor;
    }

    public <M extends ClassMetaExtended> M getExtendedMeta(Class<M> c) {
        return (M)((ClassMetaExtended)this.extMeta.get(c, this));
    }

    public InvocationHandler getProxyInvocationHandler() {
        return this.invocationHandler;
    }

    public boolean canCreateNewInstance() {
        if (this.isMemberClass) {
            return false;
        }
        if (this.noArgConstructor != null) {
            return true;
        }
        if (this.getProxyInvocationHandler() != null) {
            return true;
        }
        return this.isArray() && this.elementType.canCreateNewInstance();
    }

    public boolean canCreateNewInstance(Object outer) {
        if (this.isMemberClass) {
            return outer != null && this.noArgConstructor != null && this.noArgConstructor.getParameterTypes()[0] == outer.getClass();
        }
        return this.canCreateNewInstance();
    }

    public boolean canCreateNewBean(Object outer) {
        if (this.beanMeta == null) {
            return false;
        }
        if (this.beanMeta.constructor == null) {
            return false;
        }
        if (this.isMemberClass) {
            return outer != null && this.beanMeta.constructor.getParameterTypes()[0] == outer.getClass();
        }
        return true;
    }

    public boolean canCreateNewInstanceFromString(Object outer) {
        if (this.fromStringMethod != null) {
            return true;
        }
        if (this.stringConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.stringConstructor.getParameterTypes()[0] == outer.getClass();
            }
            return true;
        }
        return false;
    }

    public boolean canCreateNewInstanceFromNumber(Object outer) {
        if (this.numberConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.numberConstructor.getParameterTypes()[0] == outer.getClass();
            }
            return true;
        }
        return false;
    }

    public Class<? extends Number> getNewInstanceFromNumberClass() {
        return this.numberConstructorType;
    }

    public Method getNameProperty() {
        return this.namePropertyMethod;
    }

    public Method getParentProperty() {
        return this.parentPropertyMethod;
    }

    public synchronized String getNotABeanReason() {
        return this.notABeanReason;
    }

    public Throwable getInitException() {
        return this.initException;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public T getPrimitiveDefault() {
        return (T)this.primitiveDefault;
    }

    public T newInstanceFromString(Object outer, String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method m = this.fromStringMethod;
        if (m != null) {
            return (T)m.invoke(null, arg);
        }
        Constructor<T> c = this.stringConstructor;
        if (c != null) {
            if (this.isMemberClass) {
                return c.newInstance(outer, arg);
            }
            return c.newInstance(arg);
        }
        throw new InstantiationError("No string constructor or valueOf(String) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstanceFromNumber(BeanSession session, Object outer, Number arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> c = this.numberConstructor;
        if (c != null) {
            Object arg2 = session.convertToType((Object)arg, this.numberConstructor.getParameterTypes()[0]);
            if (this.isMemberClass) {
                return c.newInstance(outer, arg2);
            }
            return c.newInstance(arg2);
        }
        throw new InstantiationError("No string constructor or valueOf(Number) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstance() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isArray()) {
            return (T)Array.newInstance(this.getInnerClass().getComponentType(), 0);
        }
        Constructor<T> c = this.getConstructor();
        if (c != null) {
            return c.newInstance(null);
        }
        InvocationHandler h = this.getProxyInvocationHandler();
        if (h != null) {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getInnerClass(), Serializable.class}, h);
        }
        if (this.isArray()) {
            return (T)Array.newInstance(this.elementType.innerClass, 0);
        }
        return null;
    }

    public T newInstance(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isMemberClass) {
            return this.noArgConstructor.newInstance(outer);
        }
        return this.newInstance();
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof ClassMeta)) {
            return false;
        }
        ClassMeta t2 = (ClassMeta)t;
        return t2.getInnerClass() == this.getInnerClass();
    }

    public boolean same(ClassMeta<?> cm) {
        if (this.equals(cm)) {
            return true;
        }
        return this.isPrimitive() && this.cc == cm.cc;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        return this.toString(new StringBuilder(), simple).toString();
    }

    protected StringBuilder toString(StringBuilder sb, boolean simple) {
        String n = this.innerClass.getName();
        if (simple) {
            int i = n.lastIndexOf(46);
            n = n.substring(i == -1 ? 0 : i + 1).replace('$', '.');
        }
        if (this.cc == ClassCategory.ARRAY) {
            return this.elementType.toString(sb, simple).append('[').append(']');
        }
        if (this.cc == ClassCategory.MAP) {
            return sb.append(n).append(this.keyType.isObject() && this.valueType.isObject() ? "" : "<" + this.keyType.toString(simple) + "," + this.valueType.toString(simple) + ">");
        }
        if (this.cc == ClassCategory.BEANMAP) {
            return sb.append(BeanMap.class.getName()).append('<').append(n).append('>');
        }
        if (this.cc == ClassCategory.COLLECTION) {
            return sb.append(n).append(this.elementType.isObject() ? "" : "<" + this.elementType.toString(simple) + ">");
        }
        if (this.cc == ClassCategory.OTHER && this.beanMeta == null) {
            if (simple) {
                return sb.append(n);
            }
            sb.append("OTHER-").append(n).append(",notABeanReason=").append(this.notABeanReason);
            if (this.initException != null) {
                sb.append(",initException=").append(this.initException);
            }
            return sb;
        }
        return sb.append(n);
    }

    public boolean isInstance(Object o) {
        if (o != null) {
            return ClassUtils.isParentClass(this.innerClass, o.getClass());
        }
        return false;
    }

    public String getReadableName() {
        return ClassUtils.getReadableClassName(this.innerClass);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class LocaleAsString {
        private static Method forLanguageTagMethod;

        private LocaleAsString() {
        }

        public static final Locale fromString(String localeString) {
            if (forLanguageTagMethod != null) {
                if (localeString.indexOf(95) != -1) {
                    localeString = localeString.replace('_', '-');
                }
                try {
                    return (Locale)forLanguageTagMethod.invoke(null, localeString);
                }
                catch (Exception e) {
                    throw new BeanRuntimeException(e);
                }
            }
            String[] v = localeString.toString().split("[\\-\\_]");
            if (v.length == 1) {
                return new Locale(v[0]);
            }
            if (v.length == 2) {
                return new Locale(v[0], v[1]);
            }
            if (v.length == 3) {
                return new Locale(v[0], v[1], v[2]);
            }
            throw new BeanRuntimeException("Could not convert string ''{0}'' to a Locale.", localeString);
        }

        static {
            try {
                forLanguageTagMethod = Locale.class.getMethod("forLanguageTag", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private static class ClassMetaBuilder<T> {
        Class<T> innerClass;
        Class<? extends T> implClass;
        BeanContext beanContext;
        ClassCategory cc;
        boolean isDelegate;
        boolean isMemberClass;
        boolean isAbstract;
        Method fromStringMethod;
        Method swapMethod;
        Method unswapMethod;
        Method parentPropertyMethod;
        Method namePropertyMethod;
        Constructor<T> noArgConstructor;
        Constructor<T> stringConstructor;
        Constructor<T> swapConstructor;
        Constructor<T> numberConstructor;
        Class<?> swapMethodType;
        Class<?> numberConstructorType;
        Object primitiveDefault;
        Map<String, Method> publicMethods;
        Map<String, Method> remoteableMethods;
        ClassMeta<?> keyType;
        ClassMeta<?> valueType;
        ClassMeta<?> elementType;
        ClassMeta<?> serializedClassMeta;
        String typePropertyName;
        String notABeanReason;
        String dictionaryName;
        Throwable initException;
        BeanMeta beanMeta;
        PojoSwap pojoSwap;
        InvocationHandler invocationHandler;
        BeanRegistry beanRegistry;
        PojoSwap<?, ?>[] childPojoSwaps;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
        final /* synthetic */ ClassMeta this$0;

        private ClassMetaBuilder(final ClassMeta classMeta, Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?> pojoSwap, PojoSwap<?, ?>[] childPojoSwaps) {
            Bean b;
            Class<T> c;
            block108: {
                String mName;
                this.this$0 = classMeta;
                this.cc = ClassCategory.OTHER;
                this.isDelegate = false;
                this.isMemberClass = false;
                this.isAbstract = false;
                this.fromStringMethod = null;
                this.swapMethod = null;
                this.unswapMethod = null;
                this.parentPropertyMethod = null;
                this.namePropertyMethod = null;
                this.noArgConstructor = null;
                this.stringConstructor = null;
                this.swapConstructor = null;
                this.numberConstructor = null;
                this.swapMethodType = null;
                this.numberConstructorType = null;
                this.primitiveDefault = null;
                this.publicMethods = new LinkedHashMap<String, Method>();
                this.remoteableMethods = new LinkedHashMap<String, Method>();
                this.keyType = null;
                this.valueType = null;
                this.elementType = null;
                this.serializedClassMeta = null;
                this.typePropertyName = null;
                this.notABeanReason = null;
                this.dictionaryName = null;
                this.initException = null;
                this.beanMeta = null;
                this.pojoSwap = null;
                this.invocationHandler = null;
                this.beanRegistry = null;
                this.innerClass = innerClass;
                this.beanContext = beanContext;
                this.implClass = implClass;
                this.childPojoSwaps = childPojoSwaps;
                this.childSwapMap = childPojoSwaps == null ? null : new ConcurrentHashMap();
                this.childUnswapMap = childPojoSwaps == null ? null : new ConcurrentHashMap();
                c = innerClass;
                if (c.isPrimitive()) {
                    if (c == Boolean.TYPE) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
                        this.cc = c == Float.TYPE || c == Double.TYPE ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (c == Character.TYPE) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Void.TYPE || c == Void.class) {
                        this.cc = ClassCategory.VOID;
                    }
                } else {
                    if (ClassUtils.isParentClass(Delegate.class, c)) {
                        this.isDelegate = true;
                    }
                    if (c == Object.class) {
                        this.cc = ClassCategory.OBJ;
                    } else if (c.isEnum()) {
                        this.cc = ClassCategory.ENUM;
                    } else if (c.equals(Class.class)) {
                        this.cc = ClassCategory.CLASS;
                    } else if (ClassUtils.isParentClass(CharSequence.class, c)) {
                        this.cc = c.equals(String.class) ? ClassCategory.STR : ClassCategory.CHARSEQ;
                    } else if (ClassUtils.isParentClass(Number.class, c)) {
                        this.cc = ClassUtils.isParentClass(Float.class, c) || ClassUtils.isParentClass(Double.class, c) ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (ClassUtils.isParentClass(Collection.class, c)) {
                        this.cc = ClassCategory.COLLECTION;
                    } else if (ClassUtils.isParentClass(Map.class, c)) {
                        this.cc = ClassUtils.isParentClass(BeanMap.class, c) ? ClassCategory.BEANMAP : ClassCategory.MAP;
                    } else if (c == Character.class) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Boolean.class) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (ClassUtils.isParentClass(Date.class, c) || ClassUtils.isParentClass(Calendar.class, c)) {
                        this.cc = ClassCategory.DATE;
                    } else if (c.isArray()) {
                        this.cc = ClassCategory.ARRAY;
                    } else if (ClassUtils.isParentClass(URL.class, c) || ClassUtils.isParentClass(java.net.URI.class, c) || c.isAnnotationPresent(URI.class)) {
                        this.cc = ClassCategory.URI;
                    } else if (ClassUtils.isParentClass(Reader.class, c)) {
                        this.cc = ClassCategory.READER;
                    } else if (ClassUtils.isParentClass(InputStream.class, c)) {
                        this.cc = ClassCategory.INPUTSTREAM;
                    }
                }
                this.isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
                block7: for (String string : new String[]{"fromString", "valueOf", "parse", "parseString", "forName", "forString"}) {
                    if (this.fromStringMethod != null) continue;
                    for (Method m : c.getMethods()) {
                        Class<?>[] args;
                        String mName2;
                        if (!ClassUtils.isStatic(m) || !ClassUtils.isPublic(m) || !ClassUtils.isNotDeprecated(m) || !(mName2 = m.getName()).equals(string) || m.getReturnType() != c || (args = m.getParameterTypes()).length != 1 || args[0] != String.class) continue;
                        this.fromStringMethod = m;
                        continue block7;
                    }
                }
                try {
                    if (c == TimeZone.class) {
                        this.fromStringMethod = c.getMethod("getTimeZone", String.class);
                    } else if (c == Locale.class) {
                        this.fromStringMethod = LocaleAsString.class.getMethod("fromString", String.class);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                for (Method method : c.getMethods()) {
                    Class<?>[] pt;
                    if (!ClassUtils.isPublic(method) || !ClassUtils.isNotDeprecated(method) || ClassUtils.isStatic(method) || !(mName = method.getName()).equals("swap") || (pt = method.getParameterTypes()).length != 1 || pt[0] != BeanSession.class) continue;
                    this.swapMethod = method;
                    this.swapMethodType = method.getReturnType();
                    break;
                }
                if (this.swapMethod != null) {
                    for (Method method : c.getMethods()) {
                        Class<?>[] pt;
                        if (!ClassUtils.isPublic(method) || !ClassUtils.isNotDeprecated(method) || !ClassUtils.isStatic(method) || !(mName = method.getName()).equals("unswap") || (pt = method.getParameterTypes()).length != 2 || pt[0] != BeanSession.class || pt[1] != this.swapMethodType) continue;
                        this.unswapMethod = method;
                        break;
                    }
                }
                for (Method method : c.getDeclaredMethods()) {
                    if (method.isAnnotationPresent(ParentProperty.class) && method.getParameterTypes().length == 1) {
                        method.setAccessible(true);
                        this.parentPropertyMethod = method;
                    }
                    if (!method.isAnnotationPresent(NameProperty.class) || method.getParameterTypes().length != 1) continue;
                    method.setAccessible(true);
                    this.namePropertyMethod = method;
                }
                this.isAbstract = Modifier.isAbstract(c.getModifiers()) && !c.isPrimitive();
                for (Constructor<?> constructor : c.getConstructors()) {
                    if (!ClassUtils.isPublic(constructor) || !ClassUtils.isNotDeprecated(constructor)) continue;
                    Class<?>[] args = constructor.getParameterTypes();
                    if (args.length == (this.isMemberClass ? 1 : 0) && c != Object.class && !this.isAbstract) {
                        this.noArgConstructor = constructor;
                        continue;
                    }
                    if (args.length != (this.isMemberClass ? 2 : 1)) continue;
                    Class<?> arg = args[this.isMemberClass ? 1 : 0];
                    if (arg == String.class) {
                        this.stringConstructor = constructor;
                        continue;
                    }
                    if (this.swapMethodType != null && this.swapMethodType.isAssignableFrom(arg)) {
                        this.swapConstructor = constructor;
                        continue;
                    }
                    if (this.cc == ClassCategory.NUMBER || !Number.class.isAssignableFrom(arg) && (!arg.isPrimitive() || arg != Integer.TYPE && arg != Short.TYPE && arg != Long.TYPE && arg != Float.TYPE && arg != Double.TYPE)) continue;
                    this.numberConstructor = constructor;
                    this.numberConstructorType = ClassUtils.getWrapperIfPrimitive(arg);
                }
                if (c.isPrimitive()) {
                    if (c == Boolean.TYPE) {
                        this.primitiveDefault = BOOLEAN_DEFAULT;
                    } else if (c == Character.TYPE) {
                        this.primitiveDefault = CHARACTER_DEFAULT;
                    } else if (c == Short.TYPE) {
                        this.primitiveDefault = SHORT_DEFAULT;
                    } else if (c == Integer.TYPE) {
                        this.primitiveDefault = INTEGER_DEFAULT;
                    } else if (c == Long.TYPE) {
                        this.primitiveDefault = LONG_DEFAULT;
                    } else if (c == Float.TYPE) {
                        this.primitiveDefault = FLOAT_DEFAULT;
                    } else if (c == Double.TYPE) {
                        this.primitiveDefault = DOUBLE_DEFAULT;
                    } else if (c == Byte.TYPE) {
                        this.primitiveDefault = BYTE_DEFAULT;
                    }
                } else if (c == Boolean.class) {
                    this.primitiveDefault = BOOLEAN_DEFAULT;
                } else if (c == Character.class) {
                    this.primitiveDefault = CHARACTER_DEFAULT;
                } else if (c == Short.class) {
                    this.primitiveDefault = SHORT_DEFAULT;
                } else if (c == Integer.class) {
                    this.primitiveDefault = INTEGER_DEFAULT;
                } else if (c == Long.class) {
                    this.primitiveDefault = LONG_DEFAULT;
                } else if (c == Float.class) {
                    this.primitiveDefault = FLOAT_DEFAULT;
                } else if (c == Double.class) {
                    this.primitiveDefault = DOUBLE_DEFAULT;
                } else if (c == Byte.class) {
                    this.primitiveDefault = BYTE_DEFAULT;
                }
                for (Method method : c.getMethods()) {
                    if (!ClassUtils.isPublic(method) || !ClassUtils.isNotDeprecated(method)) continue;
                    this.publicMethods.put(ClassUtils.getMethodSignature(method), method);
                }
                LinkedHashMap<Class<T>, Remoteable> remoteableMap = ReflectionUtils.findAnnotationsMap(Remoteable.class, c);
                if (!remoteableMap.isEmpty()) {
                    Map.Entry e = remoteableMap.entrySet().iterator().next();
                    Class ic = (Class)e.getKey();
                    Remoteable remoteable = (Remoteable)e.getValue();
                    String methodPaths = remoteable.methodPaths();
                    String expose = remoteable.expose();
                    for (Method m : "DECLARED".equals(expose) ? ic.getDeclaredMethods() : ic.getMethods()) {
                        RemoteMethod rm;
                        if (!ClassUtils.isPublic(m) || (rm = m.getAnnotation(RemoteMethod.class)) == null && "ANNOTATED".equals(expose)) continue;
                        String path = "NAME".equals(methodPaths) ? m.getName() : ClassUtils.getMethodSignature(m);
                        this.remoteableMethods.put(path, m);
                    }
                }
                if (innerClass != Object.class) {
                    this.noArgConstructor = ClassMeta.findNoArgConstructor(implClass == null ? innerClass : implClass, Visibility.PUBLIC);
                }
                if (beanFilter == null) {
                    beanFilter = this.findBeanFilter();
                }
                if (this.swapMethod != null) {
                    final Method fSwapMethod = this.swapMethod;
                    final Method fUnswapMethod = this.unswapMethod;
                    final Constructor<T> constructor = this.swapConstructor;
                    this.pojoSwap = new PojoSwap<T, Object>(c, this.swapMethod.getReturnType()){

                        @Override
                        public Object swap(BeanSession session, Object o) throws SerializeException {
                            try {
                                return fSwapMethod.invoke(o, session);
                            }
                            catch (Exception e) {
                                throw new SerializeException(e);
                            }
                        }

                        @Override
                        public T unswap(BeanSession session, Object f, ClassMeta<?> hint) throws ParseException {
                            try {
                                if (fUnswapMethod != null) {
                                    return fUnswapMethod.invoke(null, session, f);
                                }
                                if (constructor != null) {
                                    return constructor.newInstance(f);
                                }
                                return super.unswap(session, f, hint);
                            }
                            catch (Exception e) {
                                throw new ParseException(e);
                            }
                        }
                    };
                }
                if (this.pojoSwap == null) {
                    this.pojoSwap = this.findPojoSwap();
                }
                if (this.pojoSwap == null) {
                    this.pojoSwap = pojoSwap;
                }
                try {
                    if (this.cc == ClassCategory.ARRAY) {
                        this.elementType = this.findClassMeta(innerClass.getComponentType());
                        break block108;
                    }
                    if (this.cc == ClassCategory.MAP) {
                        ClassMeta<?>[] parameters = this.findParameters();
                        if (parameters != null && parameters.length == 2) {
                            this.keyType = parameters[0];
                            this.valueType = parameters[1];
                        } else {
                            this.keyType = this.findClassMeta(Object.class);
                            this.valueType = this.findClassMeta(Object.class);
                        }
                        break block108;
                    }
                    if (this.cc == ClassCategory.COLLECTION) {
                        ClassMeta<?>[] parameters = this.findParameters();
                        this.elementType = parameters != null && parameters.length == 1 ? parameters[0] : this.findClassMeta(Object.class);
                        break block108;
                    }
                    if (this.cc != ClassCategory.OTHER) break block108;
                    BeanMeta newMeta = null;
                    try {
                        newMeta = new BeanMeta(classMeta, beanContext, beanFilter, null);
                        this.notABeanReason = newMeta.notABeanReason;
                        this.beanRegistry = newMeta.beanRegistry;
                        this.typePropertyName = newMeta.typePropertyName;
                    }
                    catch (RuntimeException e) {
                        this.notABeanReason = e.getMessage();
                        throw e;
                    }
                    if (this.notABeanReason == null) {
                        this.beanMeta = newMeta;
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.initException = e;
                }
                catch (RuntimeException e) {
                    this.initException = e;
                    throw e;
                }
            }
            if (this.beanMeta != null) {
                this.dictionaryName = this.beanMeta.getDictionaryName();
            }
            ClassMeta<?> classMeta2 = this.serializedClassMeta = this.pojoSwap == null ? classMeta : this.findClassMeta(this.pojoSwap.getSwapClass());
            if (this.serializedClassMeta == null) {
                this.serializedClassMeta = classMeta;
            }
            if (this.beanMeta != null && beanContext != null && beanContext.useInterfaceProxies && innerClass.isInterface()) {
                this.invocationHandler = new BeanProxyInvocationHandler(this.beanMeta);
            }
            if ((b = c.getAnnotation(Bean.class)) != null && b.beanDictionary().length != 0) {
                this.beanRegistry = new BeanRegistry(beanContext, null, b.beanDictionary());
            }
        }

        private BeanFilter findBeanFilter() {
            try {
                LinkedHashMap<Class<?>, Bean> ba = ReflectionUtils.findAnnotationsMap(Bean.class, this.innerClass);
                if (!ba.isEmpty()) {
                    return new AnnotationBeanFilterBuilder(this.innerClass, ba).build();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        private PojoSwap<T, ?> findPojoSwap() {
            try {
                Class<?> c;
                Pojo p = this.innerClass.getAnnotation(Pojo.class);
                if (p != null && (c = p.swap()) != Null.class) {
                    if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                        return (PojoSwap)c.newInstance();
                    }
                    throw new RuntimeException("TODO - Surrogate classes not yet supported.");
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private ClassMeta<?> findClassMeta(Class<?> c) {
            return this.beanContext.getClassMeta(c);
        }

        private ClassMeta<?>[] findParameters() {
            return this.beanContext.findParameters(this.innerClass, this.innerClass);
        }
    }

    static enum ClassCategory {
        MAP,
        COLLECTION,
        CLASS,
        NUMBER,
        DECIMAL,
        BOOLEAN,
        CHAR,
        DATE,
        ARRAY,
        ENUM,
        OTHER,
        CHARSEQ,
        STR,
        OBJ,
        URI,
        BEANMAP,
        READER,
        INPUTSTREAM,
        VOID,
        ARGS;

    }
}

