/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlNs;
import org.apache.juneau.xml.annotation.XmlSchema;

public final class XmlUtils {
    public static final String encodeText(Object o) {
        if (o == null) {
            return "_x0000_";
        }
        String s = o.toString();
        try {
            if (XmlUtils.needsTextEncoding(s)) {
                return XmlUtils.encodeTextInner(new StringBuilderWriter(s.length() * 2), s).toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    public static final String encodeTextInvalidChars(Object o) {
        if (o == null) {
            return "_x0000_";
        }
        String s = o.toString();
        try {
            if (XmlUtils.needsTextEncoding(s)) {
                return XmlUtils.encodeTextInvalidCharsInner(new StringBuilderWriter(s.length() * 2), s).toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    public static final Writer encodeText(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsTextEncoding(s)) {
            return XmlUtils.encodeTextInner(w, s);
        }
        w.append(s);
        return w;
    }

    public static final Writer encodeTextInvalidChars(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsTextEncoding(s)) {
            return XmlUtils.encodeTextInvalidCharsInner(w, s);
        }
        w.append(s);
        return w;
    }

    public static final Writer encodeTextXmlChars(Writer w, Object o) throws IOException {
        if (o == null) {
            return w;
        }
        String s = o.toString();
        if (XmlUtils.needsTextEncoding(s)) {
            return XmlUtils.encodeTextXmlCharsInner(w, s);
        }
        w.append(s);
        return w;
    }

    private static final Writer encodeTextInner(Writer w, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                w.append("&amp;");
                continue;
            }
            if (c == '<') {
                w.append("&lt;");
                continue;
            }
            if (c == '>') {
                w.append("&gt;");
                continue;
            }
            if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                XmlUtils.appendPaddedHexChar(w, c);
                continue;
            }
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                XmlUtils.appendPaddedHexChar(w, c);
                continue;
            }
            if (XmlUtils.isValidXmlCharacter(c)) {
                w.append(c);
                continue;
            }
            if (c == '\t' || c == '\n' || c == '\r') {
                w.append("&#x000").append(Integer.toHexString(c)).append(";");
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static final Writer encodeTextInvalidCharsInner(Writer w, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                XmlUtils.appendPaddedHexChar(w, c);
                continue;
            }
            if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                XmlUtils.appendPaddedHexChar(w, c);
                continue;
            }
            if (XmlUtils.isValidXmlCharacter(c)) {
                w.append(c);
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static final Writer encodeTextXmlCharsInner(Writer w, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                w.append("&amp;");
                continue;
            }
            if (c == '<') {
                w.append("&lt;");
                continue;
            }
            if (c == '>') {
                w.append("&gt;");
                continue;
            }
            w.append(c);
        }
        return w;
    }

    private static final boolean needsTextEncoding(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                return true;
            }
            if (c != '&' && c != '<' && c != '>' && c != '\n' && XmlUtils.isValidXmlCharacter(c) && (c != '_' || !XmlUtils.isEscapeSequence(s, i))) continue;
            return true;
        }
        return false;
    }

    public static final String decode(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.indexOf(95) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                int x = Integer.parseInt(s.substring(i + 2, i + 6), 16);
                if (x == 0) {
                    return null;
                }
                sb.append((char)x);
                i += 6;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final Writer encodeAttr(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsAttributeEncoding(s)) {
            return XmlUtils.encodeAttrInner(w, s);
        }
        w.append(s);
        return w;
    }

    private static final Writer encodeAttrInner(Writer w, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                w.append("&amp;");
                continue;
            }
            if (c == '<') {
                w.append("&lt;");
                continue;
            }
            if (c == '>') {
                w.append("&gt;");
                continue;
            }
            if (c == '\'') {
                w.append("&apos;");
                continue;
            }
            if (c == '\"') {
                w.append("&quot;");
                continue;
            }
            if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                XmlUtils.appendPaddedHexChar(w, c);
                continue;
            }
            if (XmlUtils.isValidXmlCharacter(c)) {
                w.append(c);
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static boolean needsAttributeEncoding(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\n' && c != '\'' && c != '\"' && XmlUtils.isValidXmlCharacter(c)) continue;
            return true;
        }
        return false;
    }

    public static final Writer encodeElementName(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsElementNameEncoding(s)) {
            return XmlUtils.encodeElementNameInner(w, s);
        }
        w.append(s);
        return w;
    }

    public static final String encodeElementName(Object o) {
        if (o == null) {
            return "_x0000_";
        }
        String s = o.toString();
        try {
            if (XmlUtils.needsElementNameEncoding(s)) {
                return XmlUtils.encodeElementNameInner(new StringBuilderWriter(s.length() * 2), s).toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    private static final Writer encodeElementNameInner(Writer w, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' && !XmlUtils.isEscapeSequence(s, i) || c >= 'a' && c <= 'z' || i != 0 && (c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040') || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd') {
                w.append(c);
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static final boolean needsElementNameEncoding(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return true;
            }
            if (i != 0 || c < '0' || c > '9') continue;
            return true;
        }
        return false;
    }

    public static String readXmlContents(XMLStreamReader r) throws XMLStreamException, IOException {
        StringWriter sw = new StringWriter();
        XmlWriter w = new XmlWriter(sw, false, false, '\"', null, null, false, null);
        try {
            int depth = 0;
            while (true) {
                QName n;
                int event;
                if ((event = r.next()) == 1) {
                    int i;
                    ++depth;
                    n = r.getName();
                    w.oTag(n.getPrefix(), n.getLocalPart());
                    for (i = 0; i < r.getNamespaceCount(); ++i) {
                        w.attr(r.getNamespacePrefix(i), "xmlns", (Object)r.getNamespaceURI(i));
                    }
                    for (i = 0; i < r.getAttributeCount(); ++i) {
                        w.attr(r.getAttributePrefix(i), r.getAttributeLocalName(i), (Object)r.getAttributeValue(i));
                    }
                    w.append('>');
                } else if (r.hasText()) {
                    w.encodeTextXmlChars(r.getText());
                } else if (event != 10 && event == 2) {
                    n = r.getName();
                    if (depth > 0) {
                        w.eTag(n.getPrefix(), n.getLocalPart());
                    }
                    --depth;
                }
                if (depth >= 0) continue;
                String string = sw.toString();
                return string;
            }
        }
        finally {
            w.close();
        }
    }

    private static final boolean isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    private static final boolean isEscapeSequence(String s, int i) {
        return s.length() > i + 6 && s.charAt(i) == '_' && s.charAt(i + 1) == 'x' && XmlUtils.isHexCharacter(s.charAt(i + 2)) && XmlUtils.isHexCharacter(s.charAt(i + 3)) && XmlUtils.isHexCharacter(s.charAt(i + 4)) && XmlUtils.isHexCharacter(s.charAt(i + 5)) && s.charAt(i + 6) == '_';
    }

    private static final boolean isHexCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }

    private static final Writer appendPaddedHexChar(Writer out, int num) throws IOException {
        int i;
        out.append("_x");
        char[] n = new char[4];
        int a = num % 16;
        n[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        for (i = 1; i < 4; ++i) {
            a = num / base % 16;
            base <<= 4;
            n[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        }
        for (i = 0; i < 4; ++i) {
            out.append(n[i]);
        }
        return out.append('_');
    }

    public static Namespace findNamespace(List<Xml> xmls, List<XmlSchema> schemas) {
        Namespace ns;
        for (Xml xml : xmls) {
            ns = XmlUtils.findNamespace(xml.prefix(), xml.namespace(), xmls, schemas);
            if (ns == null) continue;
            return ns;
        }
        for (XmlSchema schema : schemas) {
            ns = XmlUtils.findNamespace(schema.prefix(), schema.namespace(), null, schemas);
            if (ns == null) continue;
            return ns;
        }
        return null;
    }

    private static Namespace findNamespace(String prefix, String ns, List<Xml> xmls, List<XmlSchema> schemas) {
        if (!prefix.isEmpty() && !ns.isEmpty()) {
            return NamespaceFactory.get(prefix, ns);
        }
        if (!prefix.isEmpty()) {
            if (xmls != null) {
                for (Xml xml2 : xmls) {
                    if (!xml2.prefix().equals(prefix) || xml2.namespace().isEmpty()) continue;
                    return NamespaceFactory.get(prefix, xml2.namespace());
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.prefix().equals(prefix) && !schema.namespace().isEmpty()) {
                    return NamespaceFactory.get(prefix, schema.namespace());
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.prefix().equals(prefix)) continue;
                    return NamespaceFactory.get(prefix, xmlNs.namespaceURI());
                }
            }
            throw new BeanRuntimeException("Found @Xml.prefix annotation with no matching URI.  prefix='" + prefix + "'");
        }
        if (!ns.isEmpty()) {
            if (xmls != null) {
                for (Xml xml2 : xmls) {
                    if (!xml2.namespace().equals(ns) || xml2.prefix().isEmpty()) continue;
                    return NamespaceFactory.get(xml2.prefix(), ns);
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.namespace().equals(ns) && !schema.prefix().isEmpty()) {
                    return NamespaceFactory.get(schema.prefix(), ns);
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.namespaceURI().equals(ns)) continue;
                    return NamespaceFactory.get(xmlNs.prefix(), ns);
                }
            }
        }
        return null;
    }
}

