/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Method;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlWriter;

public class XmlSerializerSession
extends SerializerSession {
    private final boolean addJsonTypeAttrs;
    private final boolean addJsonStringTypeAttrs;
    private final boolean autoDetectNamespaces;
    private final boolean enableNamespaces;
    private final boolean addNamespaceUrlsToRoot;
    private Namespace defaultNamespace;
    private final Namespace xsiNamespace;
    private final Namespace xsNamespace;
    private Namespace[] namespaces = new Namespace[0];

    public XmlSerializerSession(XmlSerializerContext ctx, BeanContext beanContext, Object output, ObjectMap op, Method javaMethod) {
        super(ctx, beanContext, output, op, javaMethod);
        if (op == null || op.isEmpty()) {
            this.addJsonTypeAttrs = ctx.addJsonTypeAttrs;
            this.addJsonStringTypeAttrs = ctx.addJsonStringTypeAttrs;
            this.enableNamespaces = ctx.enableNamespaces;
            this.autoDetectNamespaces = ctx.autoDetectNamespaces;
            this.addNamespaceUrlsToRoot = ctx.addNamespaceUrlsToRoot;
            this.addNamespaces(ctx.namespaces);
            this.defaultNamespace = this.findDefaultNamespace(ctx.defaultNamespace);
            this.xsiNamespace = ctx.xsiNamespace;
            this.xsNamespace = ctx.xsNamespace;
        } else {
            this.addJsonTypeAttrs = op.getBoolean("XmlSerializer.addJsonTypeAttrs", ctx.addJsonTypeAttrs);
            this.addJsonStringTypeAttrs = op.getBoolean("XmlSerializer.addJsonStringTypeAttrs", ctx.addJsonStringTypeAttrs);
            this.enableNamespaces = op.getBoolean("XmlSerializer.enableNamespaces", ctx.enableNamespaces);
            this.autoDetectNamespaces = op.getBoolean("XmlSerializer.autoDetectNamespaces", ctx.autoDetectNamespaces);
            this.addNamespaceUrlsToRoot = op.getBoolean("XmlSerializer.addNamespaceUrisToRoot", ctx.addNamespaceUrlsToRoot);
            this.namespaces = op.containsKey("XmlSerializer.namespaces") ? NamespaceFactory.parseNamespaces(op.get("XmlSerializer.namespaces")) : ctx.namespaces;
            this.defaultNamespace = this.findDefaultNamespace(op.containsKey("XmlSerializer.defaultNamespaceUri") ? op.getString("XmlSerializer.defaultNamespaceUri") : ctx.defaultNamespace);
            this.xsiNamespace = op.containsKey("XmlSerializer.xsiNamespace") ? NamespaceFactory.parseNamespace(op.get("XmlSerializer.xsiNamespace")) : ctx.xsiNamespace;
            this.xsNamespace = op.containsKey("XmlSerializer.xsNamespace") ? NamespaceFactory.parseNamespace(op.get("XmlSerializer.xsNamespace")) : ctx.xsNamespace;
        }
    }

    private Namespace findDefaultNamespace(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.startsWith(s, '{')) {
            return NamespaceFactory.parseNamespace(s);
        }
        if (!s.startsWith("http://")) {
            return NamespaceFactory.get(s, "http://unknown");
        }
        return NamespaceFactory.get(null, s);
    }

    private void addNamespaces(Namespace ... namespaces) {
        for (Namespace ns : namespaces) {
            this.addNamespace(ns);
        }
    }

    public void addNamespace(Namespace ns) {
        if (ns == this.defaultNamespace) {
            return;
        }
        for (Namespace n : this.namespaces) {
            if (n != ns) continue;
            return;
        }
        if (this.defaultNamespace != null && (ns.uri.equals(this.defaultNamespace.uri) || ns.name.equals(this.defaultNamespace.name))) {
            this.defaultNamespace = ns;
        } else {
            this.namespaces = ArrayUtils.append(this.namespaces, ns);
        }
    }

    public Namespace[] getNamespaces() {
        return this.namespaces;
    }

    public final boolean isAddJsonTypeAttrs() {
        return this.addJsonTypeAttrs;
    }

    public final boolean isAddJsonStringTypeAttrs() {
        return this.addJsonStringTypeAttrs;
    }

    public final boolean isAutoDetectNamespaces() {
        return this.enableNamespaces && this.autoDetectNamespaces;
    }

    public final boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    public final boolean isAddNamespaceUrlsToRoot() {
        return this.addNamespaceUrlsToRoot;
    }

    public final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public final Namespace getXsiNamespace() {
        return this.xsiNamespace;
    }

    public final Namespace getXsNamespace() {
        return this.xsNamespace;
    }

    @Override
    public XmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof XmlWriter) {
            return (XmlWriter)output;
        }
        return new XmlWriter(super.getWriter(), this.isUseIndentation(), this.isTrimStrings(), this.getQuoteChar(), this.getRelativeUriBase(), this.getAbsolutePathUriBase(), this.isEnableNamespaces(), this.getDefaultNamespace());
    }
}

