/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlContentHandler;
import org.apache.juneau.xml.XmlSchemaSerializer;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

@Produces(value="text/xml")
public class XmlSerializer
extends WriterSerializer {
    public static final XmlSerializer DEFAULT = new XmlSerializer().lock();
    public static final XmlSerializer DEFAULT_SQ = new Sq().lock();
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable().lock();
    public static final XmlSerializer DEFAULT_XMLJSON = new XmlJson().lock();
    public static final XmlSerializer DEFAULT_XMLJSON_SQ = new XmlJsonSq().lock();
    public static final XmlSerializer DEFAULT_SIMPLE = new Simple().lock();
    public static final XmlSerializer DEFAULT_SIMPLE_SQ = new SimpleSq().lock();
    public static final XmlSerializer DEFAULT_SIMPLE_XMLJSON_SQ = new SimpleXmlJsonSq().lock();

    protected void findNsfMappings(XmlSerializerSession session, Object o) throws SerializeException {
        Namespace ns;
        BeanContext bc = session.getBeanContext();
        ClassMeta<?> aType = null;
        aType = session.push(null, o, null);
        if (aType != null && (ns = aType.getExtendedMeta(XmlClassMeta.class).getNamespace()) != null) {
            if (ns.uri != null) {
                session.addNamespace(ns);
            } else {
                ns = null;
            }
        }
        if (aType != null && !aType.isPrimitive()) {
            BeanMap<Object> bm = null;
            if (aType.isBeanMap()) {
                bm = (BeanMap<Object>)o;
            } else if (aType.isBean()) {
                bm = bc.forBean(o);
            } else if (aType.isDelegate()) {
                ClassMeta innerType = ((Delegate)o).getClassMeta();
                Namespace ns2 = innerType.getExtendedMeta(XmlClassMeta.class).getNamespace();
                if (ns2 != null) {
                    if (ns2.uri != null) {
                        session.addNamespace(ns2);
                    } else {
                        ns2 = null;
                    }
                }
                if (innerType.isBean()) {
                    for (BeanPropertyMeta bpm : innerType.getBeanMeta().getPropertyMetas()) {
                        ns2 = bpm.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                        if (ns2 == null || ns2.uri == null) continue;
                        session.addNamespace(ns2);
                    }
                } else if (innerType.isMap()) {
                    for (Object o2 : ((Map)o).values()) {
                        this.findNsfMappings(session, o2);
                    }
                } else if (innerType.isCollection()) {
                    for (Object o2 : (Collection)o) {
                        this.findNsfMappings(session, o2);
                    }
                }
            } else if (aType.isMap()) {
                for (BeanPropertyValue o2 : ((Map)o).values()) {
                    this.findNsfMappings(session, o2);
                }
            } else if (aType.isCollection()) {
                for (BeanPropertyValue o2 : (Collection)o) {
                    this.findNsfMappings(session, o2);
                }
            } else if (aType.isArray() && !aType.getElementType().isPrimitive()) {
                for (Object o2 : (Object[])o) {
                    this.findNsfMappings(session, o2);
                }
            }
            if (bm != null) {
                for (BeanPropertyValue p : bm.getValues(session.isTrimNulls(), new BeanPropertyValue[0])) {
                    Namespace ns3 = p.getMeta().getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                    if (ns3 != null && ns3.uri != null) {
                        session.addNamespace(ns3);
                    }
                    try {
                        this.findNsfMappings(session, p.getValue());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        session.pop();
    }

    protected XmlWriter serializeAnything(XmlSerializerSession session, XmlWriter out, Object o, ClassMeta eType, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, BeanPropertyMeta pMeta) throws Exception {
        boolean isNullTag;
        BeanContext bc = session.getBeanContext();
        String ts = null;
        int indent = session.indent;
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        aType = session.push(elementName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType.getSerializedClassMeta();
            PojoSwap<Object, ?> swap = aType.getPojoSwap();
            if (swap != null) {
                o = swap.swap(o, bc);
                if (sType.isObject()) {
                    sType = bc.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta();
        }
        String typeName = null;
        if (session.isAddBeanTypeProperties() && o != null && !eType.equals(aType)) {
            typeName = aType.getDictionaryName();
        }
        if (o != null && sType.isChar() && ((Character)o).charValue() == '\u0000') {
            o = null;
        }
        boolean isCollapsed = false;
        if (sType.isCharSequence() || sType.isChar()) {
            ts = "string";
        } else if (sType.isNumber()) {
            ts = "number";
        } else if (sType.isBoolean()) {
            ts = "boolean";
        } else if (sType.isMap() || sType.isBean() || sType.hasToObjectMapMethod()) {
            isCollapsed = sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED;
            ts = "object";
        } else if (sType.isCollection() || sType.isArray()) {
            isCollapsed = format == XmlFormat.COLLAPSED && !addNamespaceUris;
            ts = "array";
        } else {
            ts = "string";
        }
        if (elementName == null) {
            elementName = sType.getDictionaryName();
        }
        boolean bl = isNullTag = elementName == null && o == null;
        if (isNullTag) {
            ts = "null";
        }
        if (session.isEnableNamespaces()) {
            if (elementNamespace == null) {
                elementNamespace = sType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace == null) {
                elementNamespace = aType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace != null && elementNamespace.uri == null) {
                elementNamespace = null;
            }
            if (elementNamespace == null) {
                elementNamespace = session.getDefaultNamespace();
            }
        } else {
            elementNamespace = null;
        }
        boolean cr = o != null && (sType.isMap() || sType.isCollection() || sType.isArray() || sType.isBean() || sType.hasToObjectMapMethod());
        String en = elementName == null ? ts : elementName;
        boolean encodeEn = elementName != null;
        String ns = elementNamespace == null ? null : elementNamespace.name;
        String xsi = null;
        String dns = null;
        String elementNs = null;
        if (session.isEnableNamespaces()) {
            xsi = session.getXsiNamespace().name;
            dns = elementName == null && session.getDefaultNamespace() != null ? session.getDefaultNamespace().name : null;
            String string = elementNs = elementName == null ? dns : ns;
            if (elementName == null) {
                elementNamespace = null;
            }
        }
        if (!isCollapsed) {
            out.oTag(indent, elementNs, en, encodeEn);
            if (addNamespaceUris) {
                out.attr((String)null, "xmlns", (Object)session.getDefaultNamespace().getUri());
                for (Namespace n : session.getNamespaces()) {
                    out.attr("xmlns", n.getName(), (Object)n.getUri());
                }
                Namespace xsiNs = session.getXsiNamespace();
                if (xsiNs != null) {
                    out.attr("xmlns", xsiNs.name, (Object)xsiNs.uri);
                }
            }
            if (typeName == null && elementName != null && session.isAddJsonTypeAttrs() && (session.isAddJsonStringTypeAttrs() || !ts.equals("string"))) {
                typeName = ts;
            }
            if (typeName != null && !typeName.equals(elementName)) {
                out.attr(dns, bc.getBeanTypePropertyName(), (Object)typeName);
            }
            if (o == null) {
                if (!isNullTag) {
                    out.attr(xsi, "nil", (Object)"true");
                }
                if ((sType.isBoolean() || sType.isNumber()) && !sType.isNullable()) {
                    o = sType.getPrimitiveDefault();
                }
            }
            if (!(o == null || sType.isMap() || sType.isBean() || sType.hasToObjectMapMethod())) {
                out.append('>');
            }
            if (cr && !sType.isMap() && !sType.isBean() && !sType.hasToObjectMapMethod()) {
                out.nl();
            }
        }
        boolean hasChildren = true;
        if (o != null) {
            if (sType.isUri() || pMeta != null && pMeta.isUri()) {
                out.appendUri(o);
            } else if (sType.isCharSequence() || sType.isChar()) {
                out.encodeText(session.trim(o));
            } else if (sType.isNumber() || sType.isBoolean()) {
                out.append(o);
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                hasChildren = o instanceof BeanMap ? this.serializeBeanMap(session, out, (BeanMap)o, elementNamespace, isCollapsed) : this.serializeMap(session, out, (Map)o, sType);
            } else if (sType.hasToObjectMapMethod()) {
                hasChildren = this.serializeMap(session, out, sType.toObjectMap(o), sType);
            } else if (sType.isBean()) {
                hasChildren = this.serializeBeanMap(session, out, bc.forBean(o), elementNamespace, isCollapsed);
            } else if (sType.isCollection() || wType != null && wType.isCollection()) {
                if (isCollapsed) {
                    --session.indent;
                }
                this.serializeCollection(session, out, (Collection)o, sType, pMeta);
                if (isCollapsed) {
                    ++session.indent;
                }
            } else if (sType.isArray()) {
                if (isCollapsed) {
                    --session.indent;
                }
                this.serializeCollection(session, out, this.toList(sType.getInnerClass(), o), sType, pMeta);
                if (isCollapsed) {
                    ++session.indent;
                }
            } else {
                out.encodeText(session.toString(o));
            }
        }
        session.pop();
        if (!isCollapsed) {
            if (o == null || !hasChildren) {
                out.append('/').append('>').nl();
            } else {
                out.i(cr ? indent : 0).eTag(elementNs, en, encodeEn).nl();
            }
        }
        return out;
    }

    private boolean serializeMap(XmlSerializerSession session, XmlWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        boolean hasChildren = false;
        for (Map.Entry e : m.entrySet()) {
            Object k = e.getKey();
            if (k == null) {
                k = "\u0000";
            } else {
                k = session.generalize(k, keyType);
                if (session.isTrimStrings() && k instanceof String) {
                    k = k.toString().trim();
                }
            }
            Object value = e.getValue();
            if (!hasChildren) {
                hasChildren = true;
                out.append('>').nl();
            }
            this.serializeAnything(session, out, value, valueType, session.toString(k), null, false, XmlFormat.NORMAL, null);
        }
        return hasChildren;
    }

    private boolean serializeBeanMap(XmlSerializerSession session, XmlWriter out, BeanMap<?> m, Namespace elementNs, boolean isCollapsed) throws Exception {
        boolean hasChildren = false;
        BeanMeta<?> bm = m.getMeta();
        List<BeanPropertyValue> lp = m.getValues(session.isTrimNulls(), new BeanPropertyValue[0]);
        Map<String, BeanPropertyMeta> xmlAttrs = bm.getExtendedMeta(XmlBeanMeta.class).getXmlAttrProperties();
        Object content = null;
        for (BeanPropertyValue beanPropertyValue : lp) {
            Namespace ns;
            if (!xmlAttrs.containsKey(beanPropertyValue.getName())) continue;
            BeanPropertyMeta pMeta = beanPropertyValue.getMeta();
            ClassMeta<?> cMeta = beanPropertyValue.getClassMeta();
            String key = beanPropertyValue.getName();
            Object value = beanPropertyValue.getValue();
            Throwable t = beanPropertyValue.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            Namespace namespace = ns = session.isEnableNamespaces() && pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() != elementNs ? pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() : null;
            if (pMeta.isUri()) {
                out.attrUri(ns, key, value);
                continue;
            }
            out.attr(ns, key, value);
        }
        boolean hasContent = false;
        for (BeanPropertyValue p : lp) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            XmlFormat xf = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
            if (xf == XmlFormat.CONTENT) {
                content = p.getValue();
                hasContent = true;
                continue;
            }
            if (xf == XmlFormat.ATTR) continue;
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (!hasChildren) {
                hasChildren = true;
                out.appendIf(!isCollapsed, '>').nl();
            }
            this.serializeAnything(session, out, value, cMeta, key, pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace(), false, pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat(), pMeta);
        }
        if (!hasContent || session.canIgnoreValue(this.string(), null, content)) {
            return hasChildren;
        }
        out.append('>').cr(session.indent);
        XmlContentHandler<?> xmlContentHandler = bm.getExtendedMeta(XmlBeanMeta.class).getXmlContentHandler();
        if (xmlContentHandler != null) {
            xmlContentHandler.serialize(out, m.getBean());
        } else {
            out.encodeText(content);
        }
        out.nl();
        return true;
    }

    private XmlWriter serializeCollection(XmlSerializerSession session, XmlWriter out, Collection c, ClassMeta<?> type, BeanPropertyMeta ppMeta) throws Exception {
        c = session.sort(c);
        ClassMeta<?> elementType = type.getElementType();
        String eName = null;
        Namespace eNs = null;
        if (ppMeta != null) {
            eName = ppMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getChildName();
            eNs = ppMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
        }
        if (eName == null) {
            eName = type.getExtendedMeta(XmlClassMeta.class).getChildName();
            eNs = type.getExtendedMeta(XmlClassMeta.class).getNamespace();
        }
        if (eName == null && !elementType.isObject()) {
            eName = elementType.getDictionaryName();
            eNs = elementType.getExtendedMeta(XmlClassMeta.class).getNamespace();
        }
        for (Object value : c) {
            this.serializeAnything(session, out, value, elementType, eName, eNs, false, XmlFormat.NORMAL, null);
        }
        return out;
    }

    public XmlSerializer getSchemaSerializer() {
        XmlSchemaSerializer s = new XmlSchemaSerializer(this.getContextFactory());
        return s;
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        XmlSerializerSession s = (XmlSerializerSession)session;
        if (s.isEnableNamespaces() && s.isAutoDetectNamespaces()) {
            this.findNsfMappings(s, o);
        }
        this.serializeAnything(s, s.getWriter(), o, null, null, null, s.isEnableNamespaces() && s.isAddNamespaceUrlsToRoot(), XmlFormat.NORMAL, null);
    }

    @Override
    public XmlSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new XmlSerializerSession(this.getContext(XmlSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    public XmlSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public XmlSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public XmlSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public XmlSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public XmlSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public XmlSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> XmlSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public XmlSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public XmlSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public XmlSerializer clone() {
        try {
            XmlSerializer c = (XmlSerializer)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SimpleXmlJsonSq
    extends SimpleSq {
        public SimpleXmlJsonSq() {
            this.setProperty("XmlSerializer.addJsonTypeAttrs", true);
        }
    }

    public static class SimpleSq
    extends Simple {
        public SimpleSq() {
            this.setProperty("Serializer.quoteChar", Character.valueOf('\''));
        }
    }

    @Produces(value="text/xml+simple", contentType="text/xml")
    public static class Simple
    extends XmlSerializer {
        public Simple() {
            this.setProperty("XmlSerializer.enableNamespaces", false);
        }
    }

    public static class XmlJsonSq
    extends XmlJson {
        public XmlJsonSq() {
            this.setProperty("Serializer.quoteChar", Character.valueOf('\''));
        }
    }

    @Produces(value="text/xml+json", contentType="text/xml")
    public static class XmlJson
    extends XmlSerializer {
        public XmlJson() {
            this.setProperty("XmlSerializer.addJsonTypeAttrs", true);
        }
    }

    public static class SqReadable
    extends Sq {
        public SqReadable() {
            this.setProperty("Serializer.useIndentation", true);
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq() {
            this.setProperty("Serializer.quoteChar", Character.valueOf('\''));
        }
    }
}

