/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.Reader;
import java.lang.reflect.Method;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.xml.XmlParserContext;
import org.apache.juneau.xml.XmlUtils;

public final class XmlParserSession
extends ParserSession {
    private final String xsiNs;
    private final boolean trimWhitespace;
    private final boolean validating;
    private final boolean coalescing;
    private final boolean replaceEntityReferences;
    private final boolean preserveRootElement;
    private final XMLReporter reporter;
    private final XMLResolver resolver;
    private final XMLEventAllocator eventAllocator;
    private XMLStreamReader xmlStreamReader;

    public XmlParserSession(XmlParserContext ctx, BeanContext beanContext, Object input, ObjectMap op, Method javaMethod, Object outer) {
        super(ctx, beanContext, input, op, javaMethod, outer);
        if (op == null || op.isEmpty()) {
            this.xsiNs = ctx.xsiNs;
            this.trimWhitespace = ctx.trimWhitespace;
            this.validating = ctx.validating;
            this.coalescing = ctx.coalescing;
            this.replaceEntityReferences = ctx.replaceEntityReferences;
            this.reporter = ctx.reporter;
            this.resolver = ctx.resolver;
            this.eventAllocator = ctx.eventAllocator;
            this.preserveRootElement = ctx.preserveRootElement;
        } else {
            this.xsiNs = op.getString("XmlParser.xsiNs", ctx.xsiNs);
            this.trimWhitespace = op.getBoolean("XmlParser.trimWhitespace", ctx.trimWhitespace);
            this.validating = op.getBoolean("XmlParser.validating", ctx.validating);
            this.coalescing = op.getBoolean("XmlParser.coalescing", ctx.coalescing);
            this.replaceEntityReferences = op.getBoolean("XmlParser.replaceEntityReferences", ctx.replaceEntityReferences);
            this.reporter = (XMLReporter)op.get("XmlParser.reporter", ctx.reporter);
            this.resolver = (XMLResolver)op.get("XmlParser.resolver", ctx.resolver);
            this.eventAllocator = (XMLEventAllocator)op.get("XmlParser.eventAllocator", ctx.eventAllocator);
            this.preserveRootElement = op.getBoolean("XmlParser.preserveRootElement", ctx.preserveRootElement);
        }
    }

    public final String getXsiNs() {
        return this.xsiNs;
    }

    public final boolean isPreserveRootElement() {
        return this.preserveRootElement;
    }

    public final XMLStreamReader getXmlStreamReader() throws Exception {
        try {
            Reader r = IOUtils.getBufferedReader(this.getReader());
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", this.validating);
            factory.setProperty("javax.xml.stream.isCoalescing", this.coalescing);
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", this.replaceEntityReferences);
            if (factory.isPropertySupported("javax.xml.stream.reporter") && this.reporter != null) {
                factory.setProperty("javax.xml.stream.reporter", this.reporter);
            }
            if (factory.isPropertySupported("javax.xml.stream.resolver") && this.resolver != null) {
                factory.setProperty("javax.xml.stream.resolver", this.resolver);
            }
            if (factory.isPropertySupported("javax.xml.stream.allocator") && this.eventAllocator != null) {
                factory.setProperty("javax.xml.stream.allocator", this.eventAllocator);
            }
            this.xmlStreamReader = factory.createXMLStreamReader(r);
            this.xmlStreamReader.nextTag();
        }
        catch (Error e) {
            this.close();
            throw new ParseException(e.getLocalizedMessage(), new Object[0]);
        }
        catch (XMLStreamException e) {
            this.close();
            throw new ParseException(e);
        }
        return this.xmlStreamReader;
    }

    public final String decodeString(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (this.trimWhitespace) {
            s = s.trim();
        }
        s = XmlUtils.decode(s);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    public final String decodeLiteral(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        s = s.trim();
        s = XmlUtils.decode(s);
        return s;
    }

    @Override
    public void close() throws ParseException {
        super.close();
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

