/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionary;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlContentHandler;
import org.apache.juneau.xml.XmlParserContext;
import org.apache.juneau.xml.XmlParserSession;
import org.apache.juneau.xml.annotation.XmlFormat;

@Consumes(value="text/xml,application/xml")
public class XmlParser
extends ReaderParser {
    public static final XmlParser DEFAULT = new XmlParser().lock();
    private static final int UNKNOWN = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final int NULL = 6;

    private <T> T parseAnything(XmlParserSession session, ClassMeta<T> eType, String currAttr, XMLStreamReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws Exception {
        BeanContext bc = session.getBeanContext();
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, T> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        BeanDictionary bd = pMeta == null ? bc.getBeanDictionary() : pMeta.getBeanDictionary();
        String wrapperAttr = isRoot && session.isPreserveRootElement() ? r.getName().getLocalPart() : null;
        String typeAttr = r.getAttributeValue(null, bc.getBeanTypePropertyName());
        int jsonType = this.getJsonType(typeAttr);
        String b = r.getAttributeValue(session.getXsiNs(), "nil");
        if (b == null) {
            b = r.getAttributeValue(null, "nil");
        }
        boolean isNull = b != null && b.equals("true");
        String elementName = session.decodeString(r.getLocalName());
        if (jsonType == 0) {
            if (elementName == null || elementName.equals(currAttr)) {
                jsonType = 0;
            } else {
                typeAttr = elementName;
                jsonType = this.getJsonType(elementName);
            }
        }
        if (!sType.canCreateNewInstance(outer)) {
            if (bd.hasName(typeAttr)) {
                eType = bd.getClassMeta(typeAttr);
                sType = eType;
            } else if (bd.hasName(elementName)) {
                eType = bd.getClassMeta(elementName);
                sType = eType;
            }
        }
        Object o = null;
        if (jsonType == 6) {
            r.nextTag();
            return null;
        }
        if (isNull) {
            int e;
            while ((e = r.next()) != 2) {
            }
            return null;
        }
        if (sType.isObject()) {
            if (jsonType == 1) {
                ObjectMap m = new ObjectMap(bc);
                this.parseIntoMap(session, r, m, this.string(), this.object(), pMeta);
                if (wrapperAttr != null) {
                    m = new ObjectMap(bc).append(wrapperAttr, m);
                }
                o = bd.cast(m);
            } else if (jsonType == 2) {
                o = this.parseIntoCollection(session, r, new ObjectList(bc), this.object(), pMeta);
            } else if (jsonType == 3) {
                o = session.decodeString(r.getElementText());
                if (sType.isChar()) {
                    o = Character.valueOf(o.toString().charAt(0));
                }
            } else if (jsonType == 4) {
                o = StringUtils.parseNumber(session.decodeLiteral(r.getElementText()), null);
            } else if (jsonType == 5) {
                o = Boolean.parseBoolean(session.decodeLiteral(r.getElementText()));
            } else if (jsonType == 0) {
                o = this.getUnknown(session, r);
            }
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(session.decodeLiteral(r.getElementText()));
        } else if (sType.isCharSequence()) {
            o = session.decodeString(r.getElementText());
        } else if (sType.isChar()) {
            o = Character.valueOf(session.decodeString(r.getElementText()).charAt(0));
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(bc);
            o = this.parseIntoMap(session, r, m, sType.getKeyType(), sType.getValueType(), pMeta);
            if (wrapperAttr != null) {
                o = new ObjectMap(bc).append(wrapperAttr, m);
            }
        } else if (sType.isCollection()) {
            Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(bc);
            o = this.parseIntoCollection(session, r, l, sType.getElementType(), pMeta);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber(session.decodeLiteral(r.getElementText()), sType.getInnerClass());
        } else if (sType.canCreateNewInstanceFromObjectMap(outer)) {
            ObjectMap m = new ObjectMap(bc);
            this.parseIntoMap(session, r, m, this.string(), this.object(), pMeta);
            o = sType.newInstanceFromObjectMap(outer, m);
        } else if (sType.canCreateNewBean(outer)) {
            if (sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED) {
                String fieldName = r.getLocalName();
                BeanMap<?> m = bc.newBeanMap(outer, sType.getInnerClass());
                BeanPropertyMeta bpm = m.getMeta().getExtendedMeta(XmlBeanMeta.class).getPropertyMeta(fieldName);
                ClassMeta<?> cm = m.getMeta().getClassMeta();
                Object value = this.parseAnything(session, cm, currAttr, r, m.getBean(false), false, null);
                this.setName(cm, value, currAttr);
                bpm.set(m, value);
                o = m.getBean();
            } else {
                BeanMap<?> m = bc.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBean(session, r, m).getBean();
            }
        } else if (sType.isArray()) {
            ArrayList l = (ArrayList)this.parseIntoCollection(session, r, new ArrayList(), sType.getElementType(), pMeta);
            o = bc.toArray(sType, l);
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            o = sType.newInstanceFromString(outer, session.decodeString(r.getElementText()));
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(outer, StringUtils.parseNumber(session.decodeLiteral(r.getElementText()), sType.getNewInstanceFromNumberClass()));
        } else {
            throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
        }
        if (transform != null && o != null) {
            o = transform.unswap(o, eType, bc);
        }
        if (outer != null) {
            this.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(XmlParserSession session, XMLStreamReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        V value;
        K key;
        BeanContext bc = session.getBeanContext();
        int depth = 0;
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String a = r.getAttributeLocalName(i);
            if (a.equals(bc.getBeanTypePropertyName())) continue;
            key = session.trim(this.convertAttrToType(session, m, a, keyType));
            value = session.trim(this.convertAttrToType(session, m, r.getAttributeValue(i), valueType));
            this.setName(valueType, value, key);
            m.put(key, (ObjectList)value);
        }
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                String currAttr = session.decodeString(r.getLocalName());
                key = this.convertAttrToType(session, m, currAttr, keyType);
                value = this.parseAnything(session, valueType, currAttr, r, m, false, pMeta);
                this.setName(valueType, value, currAttr);
                if (valueType.isObject() && m.containsKey(key)) {
                    V o = m.get(key);
                    if (o instanceof List) {
                        ((List)o).add(value);
                        continue;
                    }
                    m.put(key, new ObjectList(o, value).setBeanContext(bc));
                    continue;
                }
                m.put(key, (ObjectList)value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return m;
        } while (depth > 0);
        return m;
    }

    private <E> Collection<E> parseIntoCollection(XmlParserSession session, XMLStreamReader r, Collection<E> l, ClassMeta<E> elementType, BeanPropertyMeta pMeta) throws Exception {
        int depth = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                E value = this.parseAnything(session, elementType, null, r, l, false, pMeta);
                l.add(value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return l;
        } while (depth > 0);
        return l;
    }

    private Object[] doParseArgs(XmlParserSession session, XMLStreamReader r, ClassMeta<?>[] argTypes) throws Exception {
        int depth = 0;
        Object[] o = new Object[argTypes.length];
        int i = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                o[i] = this.parseAnything(session, argTypes[i], null, r, null, false, null);
                ++i;
                continue;
            }
            if (event != 2) continue;
            --depth;
            return o;
        } while (depth > 0);
        return o;
    }

    private int getJsonType(String s) {
        if (s == null) {
            return 0;
        }
        char c = s.charAt(0);
        switch (c) {
            case 'o': {
                return s.equals("object") ? 1 : 0;
            }
            case 'a': {
                return s.equals("array") ? 2 : 0;
            }
            case 's': {
                return s.equals("string") ? 3 : 0;
            }
            case 'b': {
                return s.equals("boolean") ? 5 : 0;
            }
            case 'n': {
                c = s.charAt(2);
                switch (c) {
                    case 'm': {
                        return s.equals("number") ? 4 : 0;
                    }
                    case 'l': {
                        return s.equals("null") ? 6 : 0;
                    }
                }
            }
        }
        return 0;
    }

    private <T> BeanMap<T> parseIntoBean(XmlParserSession session, XMLStreamReader r, BeanMap<T> m) throws Exception {
        BeanMeta<T> bMeta = m.getMeta();
        XmlBeanMeta xmlMeta = bMeta.getExtendedMeta(XmlBeanMeta.class);
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String key = session.decodeString(r.getAttributeLocalName(i));
            String val = r.getAttributeValue(i);
            BeanPropertyMeta bpm = xmlMeta.getPropertyMeta(key);
            if (bpm == null) {
                if (m.getMeta().isSubTyped()) {
                    m.put(key, (Object)val);
                    continue;
                }
                Location l = r.getLocation();
                this.onUnknownProperty(session, key, m, l.getLineNumber(), l.getColumnNumber());
                continue;
            }
            bpm.set(m, val);
        }
        BeanPropertyMeta cp = xmlMeta.getXmlContentProperty();
        if (cp != null) {
            XmlContentHandler<?> h = xmlMeta.getXmlContentHandler();
            if (h != null) {
                h.parse(r, m.getBean());
            } else {
                String text = r.getElementText();
                cp.set(m, session.decodeString(text));
            }
            return m;
        }
        int depth = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                Object value;
                ++depth;
                String currAttr = session.decodeString(r.getLocalName());
                BeanPropertyMeta pMeta = xmlMeta.getPropertyMeta(currAttr);
                if (pMeta == null) {
                    if (m.getMeta().isSubTyped()) {
                        String value2 = this.parseAnything(session, this.string(), currAttr, r, m.getBean(false), false, null);
                        m.put(currAttr, (Object)value2);
                        continue;
                    }
                    Location l = r.getLocation();
                    this.onUnknownProperty(session, currAttr, m, l.getLineNumber(), l.getColumnNumber());
                    this.skipCurrentTag(r);
                    continue;
                }
                session.setCurrentProperty(pMeta);
                XmlFormat xf = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
                if (xf == XmlFormat.COLLAPSED) {
                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                    value = this.parseAnything(session, et, currAttr, r, m.getBean(false), false, pMeta);
                    this.setName(et, value, currAttr);
                    pMeta.add(m, value);
                } else if (xf == XmlFormat.ATTR) {
                    pMeta.set(m, session.decodeString(r.getAttributeValue(0)));
                    r.nextTag();
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    value = this.parseAnything(session, cm, currAttr, r, m.getBean(false), false, pMeta);
                    this.setName(cm, value, currAttr);
                    pMeta.set(m, value);
                }
                session.setCurrentProperty(null);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return m;
        } while (depth > 0);
        return m;
    }

    private void skipCurrentTag(XMLStreamReader r) throws XMLStreamException {
        int depth = 1;
        do {
            int event;
            if ((event = r.next()) == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            --depth;
        } while (depth > 0);
    }

    private Object getUnknown(XmlParserSession session, XMLStreamReader r) throws Exception {
        BeanContext bc = session.getBeanContext();
        if (r.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", r.getLocation());
        }
        ObjectMap m = null;
        if (r.getAttributeCount() > 0) {
            m = new ObjectMap(bc);
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                String key = session.decodeString(r.getAttributeLocalName(i));
                String val = r.getAttributeValue(i);
                if (key.equals(bc.getBeanTypePropertyName())) continue;
                m.put(key, val);
            }
        }
        int eventType = r.next();
        StringBuilder sb = new StringBuilder();
        block1: while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                sb.append(r.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("Unexpected end of document when reading element text content", r.getLocation());
                }
                if (eventType == 1) {
                    if (m == null) {
                        m = new ObjectMap(bc);
                    }
                    int depth = 0;
                    do {
                        int event;
                        int n = event = eventType == -1 ? r.nextTag() : eventType;
                        if (event == 1) {
                            ++depth;
                            String currAttr = session.decodeString(r.getLocalName());
                            String key = this.convertAttrToType(session, null, currAttr, this.string());
                            Object value = this.parseAnything(session, this.object(), currAttr, r, null, false, null);
                            if (m.containsKey(key)) {
                                Object o = m.get(key);
                                if (o instanceof ObjectList) {
                                    ((ObjectList)o).add(value);
                                } else {
                                    m.put(key, new ObjectList(o, value).setBeanContext(bc));
                                }
                            } else {
                                m.put(key, value);
                            }
                        } else if (event == 2) {
                            --depth;
                            break block1;
                        }
                        eventType = -1;
                    } while (depth > 0);
                    break;
                }
                throw new XMLStreamException("Unexpected event type " + eventType, r.getLocation());
            }
            eventType = r.next();
        }
        String s = sb.toString();
        s = session.decodeString(s);
        if (m != null) {
            if (!s.isEmpty()) {
                m.put("contents", s);
            }
            return m;
        }
        return s;
    }

    @Override
    public XmlParserSession createSession(Object input, ObjectMap properties, Method javaMethod, Object outer) {
        return new XmlParserSession(this.getContext(XmlParserContext.class), this.getBeanContext(), input, properties, javaMethod, outer);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        type = s.getBeanContext().normalizeClassMeta(type);
        return this.parseAnything(s, type, null, s.getXmlStreamReader(), s.getOuter(), true, null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        ClassMeta<?> cm = s.getBeanContext().getMapClassMeta(m.getClass(), keyType, valueType);
        return this.parseIntoMap(s, m, cm.getKeyType(), cm.getValueType());
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        ClassMeta<?> cm = s.getBeanContext().getCollectionClassMeta(c.getClass(), elementType);
        return this.parseIntoCollection(s, c, cm.getElementType());
    }

    @Override
    protected Object[] doParseArgs(ParserSession session, ClassMeta<?>[] argTypes) throws Exception {
        XmlParserSession s = (XmlParserSession)session;
        return this.doParseArgs(s, s.getXmlStreamReader(), argTypes);
    }

    @Override
    public XmlParser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public XmlParser setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public XmlParser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public XmlParser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public XmlParser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public XmlParser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> XmlParser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public XmlParser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public XmlParser lock() {
        super.lock();
        return this;
    }

    @Override
    public XmlParser clone() {
        try {
            XmlParser c = (XmlParser)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

