/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlClassMeta
extends ClassMetaExtended {
    private final Namespace namespace;
    private final Xml xml;
    private final XmlFormat format;
    private final String childName;

    public XmlClassMeta(ClassMeta<?> cm) {
        super(cm);
        Class<?> c = this.getInnerClass();
        this.namespace = this.findNamespace(c);
        this.xml = ReflectionUtils.getAnnotation(Xml.class, c);
        if (this.xml != null) {
            this.format = this.xml.format();
            this.childName = StringUtils.nullIfEmpty(this.xml.childName());
        } else {
            this.format = XmlFormat.NORMAL;
            this.childName = null;
        }
    }

    protected Xml getAnnotation() {
        return this.xml;
    }

    protected XmlFormat getFormat() {
        return this.format;
    }

    protected String getChildName() {
        return this.childName;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }

    private Namespace findNamespace(Class<?> c) {
        if (c == null) {
            return null;
        }
        List<Xml> xmls = ReflectionUtils.findAnnotations(Xml.class, c);
        List<XmlSchema> schemas = ReflectionUtils.findAnnotations(XmlSchema.class, c);
        return XmlUtils.findNamespace(xmls, schemas);
    }
}

