/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.List;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyMetaExtended;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlContentHandler;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlBeanPropertyMeta
extends BeanPropertyMetaExtended {
    private Namespace namespace = null;
    private XmlFormat xmlFormat = XmlFormat.NORMAL;
    private XmlContentHandler<?> xmlContentHandler = null;
    private String childName;

    public XmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        super(bpm);
        if (bpm.getField() != null) {
            this.findXmlInfo(bpm.getField().getAnnotation(Xml.class));
        }
        if (bpm.getGetter() != null) {
            this.findXmlInfo(bpm.getGetter().getAnnotation(Xml.class));
        }
        if (bpm.getSetter() != null) {
            this.findXmlInfo(bpm.getSetter().getAnnotation(Xml.class));
        }
        if (this.namespace == null) {
            this.namespace = bpm.getBeanMeta().getClassMeta().getExtendedMeta(XmlClassMeta.class).getNamespace();
        }
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    protected XmlFormat getXmlFormat() {
        return this.xmlFormat;
    }

    protected XmlContentHandler<?> getXmlContentHandler() {
        return this.xmlContentHandler;
    }

    protected String getChildName() {
        return this.childName;
    }

    private void findXmlInfo(Xml xml) {
        if (xml == null) {
            return;
        }
        BeanPropertyMeta bpm = this.getBeanPropertyMeta();
        ClassMeta<?> cmProperty = bpm.getClassMeta();
        ClassMeta<?> cmBean = bpm.getBeanMeta().getClassMeta();
        String name = bpm.getName();
        List<Xml> xmls = bpm.findAnnotations(Xml.class);
        List<XmlSchema> schemas = bpm.findAnnotations(XmlSchema.class);
        this.namespace = XmlUtils.findNamespace(xmls, schemas);
        if (this.xmlFormat == XmlFormat.NORMAL) {
            this.xmlFormat = xml.format();
        }
        boolean isCollection = cmProperty.isCollection() || cmProperty.isArray();
        String cen = xml.childName();
        if (!cen.isEmpty() && !isCollection) {
            throw new BeanRuntimeException(cmProperty.getInnerClass(), "Annotation error on property ''{0}''.  @Xml.childName can only be specified on collections and arrays.", name);
        }
        if (this.xmlFormat == XmlFormat.COLLAPSED) {
            if (isCollection) {
                if (cen.isEmpty()) {
                    cen = cmProperty.getExtendedMeta(XmlClassMeta.class).getChildName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = cmProperty.getElementType().getDictionaryName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = name;
                }
            } else {
                throw new BeanRuntimeException(cmBean.getInnerClass(), "Annotation error on property ''{0}''.  @Xml.format=COLLAPSED can only be specified on collections and arrays.", name);
            }
            if (cen.isEmpty() && isCollection) {
                cen = cmProperty.getDictionaryName();
            }
        }
        try {
            if (this.xmlFormat == XmlFormat.CONTENT && xml.contentHandler() != XmlContentHandler.NULL.class) {
                this.xmlContentHandler = xml.contentHandler().newInstance();
            }
        }
        catch (Exception e) {
            throw new BeanRuntimeException(cmBean.getInnerClass(), "Could not instantiate content handler ''{0}''", xml.contentHandler().getName()).initCause(e);
        }
        if (!cen.isEmpty()) {
            this.childName = cen;
        }
    }
}

