/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlContentHandler;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlBeanMeta
extends BeanMetaExtended {
    private final Map<String, BeanPropertyMeta> xmlAttrs;
    private final BeanPropertyMeta xmlContent;
    private final XmlContentHandler<?> xmlContentHandler;
    private final Map<String, BeanPropertyMeta> childElementProperties;

    public XmlBeanMeta(BeanMeta<?> beanMeta) {
        super(beanMeta);
        Class<?> c = beanMeta.getClassMeta().getInnerClass();
        LinkedHashMap<String, BeanPropertyMeta> tXmlAttrs = new LinkedHashMap<String, BeanPropertyMeta>();
        BeanPropertyMeta tXmlContent = null;
        XmlContentHandler<?> tXmlContentHandler = null;
        LinkedHashMap<String, BeanPropertyMeta> tChildElementProperties = new LinkedHashMap<String, BeanPropertyMeta>();
        for (BeanPropertyMeta p : beanMeta.getPropertyMetas()) {
            String n;
            XmlFormat xf = p.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
            if (xf == XmlFormat.ATTR) {
                tXmlAttrs.put(p.getName(), p);
            } else if (xf == XmlFormat.CONTENT) {
                if (tXmlContent != null) {
                    throw new BeanRuntimeException(c, "Multiple instances of CONTENT properties defined on class.  Only one property can be designated as such.", new Object[0]);
                }
                tXmlContent = p;
                tXmlContentHandler = p.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlContentHandler();
            }
            if ((n = p.getExtendedMeta(XmlBeanPropertyMeta.class).getChildName()) == null) continue;
            if (tChildElementProperties.containsKey(n)) {
                throw new BeanRuntimeException(c, "Multiple properties found with the name ''{0}''.", n);
            }
            tChildElementProperties.put(n, p);
        }
        this.xmlAttrs = Collections.unmodifiableMap(tXmlAttrs);
        this.xmlContent = tXmlContent;
        this.xmlContentHandler = tXmlContentHandler;
        this.childElementProperties = tChildElementProperties.isEmpty() ? null : Collections.unmodifiableMap(tChildElementProperties);
    }

    protected Map<String, BeanPropertyMeta> getXmlAttrProperties() {
        return this.xmlAttrs;
    }

    protected BeanPropertyMeta getXmlContentProperty() {
        return this.xmlContent;
    }

    protected XmlContentHandler<?> getXmlContentHandler() {
        return this.xmlContentHandler;
    }

    protected Map<String, BeanPropertyMeta> getChildElementProperties() {
        return this.childElementProperties;
    }

    protected BeanPropertyMeta getPropertyMeta(String fieldName) {
        BeanPropertyMeta bpm;
        if (this.childElementProperties != null && (bpm = this.childElementProperties.get(fieldName)) != null) {
            return bpm;
        }
        return this.getBeanMeta().getPropertyMeta(fieldName);
    }
}

