/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.utils.PojoIntrospector;
import org.apache.juneau.utils.PojoRestException;

public final class PojoRest {
    private static final int GET = 1;
    private static final int PUT = 2;
    private static final int POST = 3;
    private static final int DELETE = 4;
    private ReaderParser parser = JsonParser.DEFAULT;
    private final BeanContext bc;
    private boolean rootLocked = false;
    private JsonNode root;

    public PojoRest(Object o) {
        this(o, null);
    }

    public PojoRest(Object o, ReaderParser parser) {
        if (parser == null) {
            parser = JsonParser.DEFAULT;
        }
        this.parser = parser;
        this.bc = parser.getBeanContext();
        this.root = new JsonNode(null, null, o, this.bc.object());
    }

    public PojoRest setRootLocked() {
        this.rootLocked = true;
        return this;
    }

    public Object getRootObject() {
        return this.root.o;
    }

    public Object get(String url) {
        return this.get(url, null);
    }

    public Object get(String url, Object defVal) {
        Object o = this.service(1, url, null);
        return o == null ? defVal : o;
    }

    public <T> T get(Class<T> type, String url) {
        return this.get(type, url, null);
    }

    public <T> T get(Class<T> type, String url, T def) {
        Object o = this.service(1, url, null);
        if (o == null) {
            return def;
        }
        return this.bc.convertToType(o, type);
    }

    public String getString(String url) {
        return this.get(String.class, url);
    }

    public String getString(String url, String defVal) {
        return this.get(String.class, url, defVal);
    }

    public Integer getInt(String url) {
        return this.get(Integer.class, url);
    }

    public Integer getInt(String url, Integer defVal) {
        return this.get(Integer.class, url, defVal);
    }

    public Long getLong(String url) {
        return this.get(Long.class, url);
    }

    public Long getLong(String url, Long defVal) {
        return this.get(Long.class, url, defVal);
    }

    public Boolean getBoolean(String url) {
        return this.get(Boolean.class, url);
    }

    public Boolean getBoolean(String url, Boolean defVal) {
        return this.get(Boolean.class, url, defVal);
    }

    public Map<?, ?> getMap(String url) {
        return this.get(Map.class, url);
    }

    public Map<?, ?> getMap(String url, Map<?, ?> defVal) {
        return this.get(Map.class, url, defVal);
    }

    public List<?> getList(String url) {
        return this.get(List.class, url);
    }

    public List<?> getList(String url, List<?> defVal) {
        return this.get(List.class, url, defVal);
    }

    public ObjectMap getObjectMap(String url) {
        return this.get(ObjectMap.class, url);
    }

    public ObjectMap getObjectMap(String url, ObjectMap defVal) {
        return this.get(ObjectMap.class, url, defVal);
    }

    public ObjectList getObjectList(String url) {
        return this.get(ObjectList.class, url);
    }

    public ObjectList getObjectList(String url, ObjectList defVal) {
        return this.get(ObjectList.class, url, defVal);
    }

    public Object invokeMethod(String url, String method, String args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, ParseException, NoSuchMethodException, IOException {
        return new PojoIntrospector(this.get(url), this.parser).invokeMethod(method, args);
    }

    public Collection<String> getPublicMethods(String url) {
        Object o = this.get(url);
        if (o == null) {
            return null;
        }
        return this.bc.getClassMeta(o.getClass()).getPublicMethods().keySet();
    }

    public ClassMeta getClassMeta(String url) {
        JsonNode n = this.getNode(this.normalizeUrl(url), this.root);
        if (n == null) {
            return null;
        }
        return n.cm;
    }

    public Object put(String url, Object val) {
        return this.service(2, url, val);
    }

    public String post(String url, Object val) {
        return (String)this.service(3, url, val);
    }

    public Object delete(String url) {
        return this.service(4, url, null);
    }

    public String toString() {
        return String.valueOf(this.root.o);
    }

    private String normalizeUrl(String url) {
        if (url == null) {
            url = "";
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    private Object service(int method, String url, Object val) throws PojoRestException {
        String childKey;
        url = this.normalizeUrl(url);
        if (method == 1) {
            JsonNode p = this.getNode(url, this.root);
            return p == null ? null : p.o;
        }
        int i = url.lastIndexOf(47);
        String parentUrl = i == -1 ? null : url.substring(0, i);
        String string = childKey = i == -1 ? url : url.substring(i + 1);
        if (method == 2) {
            JsonNode n;
            if (url.length() == 0) {
                if (this.rootLocked) {
                    throw new PojoRestException(403, "Cannot overwrite root object", new Object[0]);
                }
                Object o = this.root.o;
                this.root = new JsonNode(null, null, val, this.bc.object());
                return o;
            }
            JsonNode jsonNode = n = parentUrl == null ? this.root : this.getNode(parentUrl, this.root);
            if (n == null) {
                throw new PojoRestException(404, "Node at URL ''{0}'' not found.", parentUrl);
            }
            ClassMeta cm = n.cm;
            Object[] o = n.o;
            if (cm.isMap()) {
                return ((Map)o).put(childKey, this.convert(val, cm.getValueType()));
            }
            if (cm.isCollection() && o instanceof List) {
                return ((List)o).set(this.parseInt(childKey), this.convert(val, cm.getElementType()));
            }
            if (cm.isArray()) {
                o = this.setArrayEntry(n.o, this.parseInt(childKey), val, cm.getElementType());
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(n.keyName, o);
                    return url;
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.bc.forBean(po);
                    m.put(n.keyName, (Object)o);
                    return url;
                }
                throw new PojoRestException(400, "Cannot perform PUT on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isBean()) {
                return this.bc.forBean(o).put(childKey, val);
            }
            throw new PojoRestException(400, "Cannot perform PUT on ''{0}'' whose parent is of type ''{1}''", url, cm);
        }
        if (method == 3) {
            if (url.length() == 0) {
                ClassMeta cm = this.root.cm;
                Object o = this.root.o;
                if (cm.isCollection()) {
                    Collection c = (Collection)o;
                    c.add(this.convert(val, cm.getElementType()));
                    return c instanceof List ? url + "/" + (c.size() - 1) : null;
                }
                if (cm.isArray()) {
                    Object[] o2 = this.addArrayEntry(o, val, cm.getElementType());
                    this.root = new JsonNode(null, null, o2, null);
                    return url + "/" + (o2.length - 1);
                }
                throw new PojoRestException(400, "Cannot perform POST on ''{0}'' of type ''{1}''", url, cm);
            }
            JsonNode n = this.getNode(url, this.root);
            if (n == null) {
                throw new PojoRestException(404, "Node at URL ''{0}'' not found.", url);
            }
            ClassMeta cm = n.cm;
            Object o = n.o;
            if (cm.isArray()) {
                Object[] o2 = this.addArrayEntry(o, val, cm.getElementType());
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(childKey, o2);
                    return url + "/" + (o2.length - 1);
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.bc.forBean(po);
                    m.put(childKey, (Object)o2);
                    return url + "/" + (o2.length - 1);
                }
                throw new PojoRestException(400, "Cannot perform POST on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isCollection()) {
                Collection c = (Collection)o;
                c.add(this.convert(val, cm.getElementType()));
                return c instanceof List ? url + "/" + (c.size() - 1) : null;
            }
            throw new PojoRestException(400, "Cannot perform POST on ''{0}'' of type ''{1}''", url, cm);
        }
        if (method == 4) {
            if (url.length() == 0) {
                if (this.rootLocked) {
                    throw new PojoRestException(403, "Cannot overwrite root object", new Object[0]);
                }
                Object o = this.root.o;
                this.root = new JsonNode(null, null, null, this.bc.object());
                return o;
            }
            JsonNode n = parentUrl == null ? this.root : this.getNode(parentUrl, this.root);
            ClassMeta cm = n.cm;
            Object o = n.o;
            if (cm.isMap()) {
                return ((Map)o).remove(childKey);
            }
            if (cm.isCollection() && o instanceof List) {
                return ((List)o).remove(this.parseInt(childKey));
            }
            if (cm.isArray()) {
                int index = this.parseInt(childKey);
                Object old = ((Object[])o)[index];
                Object[] o2 = this.removeArrayEntry(o, index);
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(n.keyName, o2);
                    return old;
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.bc.forBean(po);
                    m.put(n.keyName, (Object)o2);
                    return old;
                }
                throw new PojoRestException(400, "Cannot perform POST on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isBean()) {
                return this.bc.forBean(o).put(childKey, (Object)null);
            }
            throw new PojoRestException(400, "Cannot perform PUT on ''{0}'' whose parent is of type ''{1}''", url, cm);
        }
        return null;
    }

    private Object[] setArrayEntry(Object o, int index, Object val, ClassMeta componentType) {
        Object[] a = (Object[])o;
        if (a.length <= index) {
            Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), index + 1);
            System.arraycopy(a, 0, a2, 0, a.length);
            a = a2;
        }
        a[index] = this.convert(val, componentType);
        return a;
    }

    private Object[] addArrayEntry(Object o, Object val, ClassMeta componentType) {
        Object[] a = (Object[])o;
        Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + 1);
        System.arraycopy(a, 0, a2, 0, a.length);
        a2[a.length] = this.convert(val, componentType);
        return a2;
    }

    private Object[] removeArrayEntry(Object o, int index) {
        Object[] a = (Object[])o;
        Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - 1);
        System.arraycopy(a, 0, a2, 0, index);
        System.arraycopy(a, index + 1, a2, index, a.length - index - 1);
        return a2;
    }

    JsonNode getNode(String url, JsonNode n) {
        String parentKey;
        if (url == null || url.isEmpty()) {
            return n;
        }
        int i = url.indexOf(47);
        String childUrl = null;
        if (i == -1) {
            parentKey = url;
        } else {
            parentKey = url.substring(0, i);
            childUrl = url.substring(i + 1);
        }
        Object o = n.o;
        Object o2 = null;
        ClassMeta cm = n.cm;
        ClassMeta<?> ct2 = null;
        if (o == null) {
            return null;
        }
        if (cm.isMap()) {
            o2 = ((Map)o).get(parentKey);
            ct2 = cm.getValueType();
        } else if (cm.isCollection() && o instanceof List) {
            int key = this.parseInt(parentKey);
            List l = (List)o;
            if (l.size() <= key) {
                return null;
            }
            o2 = l.get(key);
            ct2 = cm.getElementType();
        } else if (cm.isArray()) {
            Object[] a = (Object[])o;
            int key = this.parseInt(parentKey);
            if (a.length <= key) {
                return null;
            }
            o2 = a[key];
            ct2 = cm.getElementType();
        } else if (cm.isBean()) {
            BeanMap<Object> m = this.bc.forBean(o);
            o2 = m.get(parentKey);
            BeanPropertyMeta pMeta = m.getPropertyMeta(parentKey);
            if (pMeta == null) {
                throw new PojoRestException(400, "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", parentKey, m.getClassMeta());
            }
            ct2 = pMeta.getClassMeta();
        }
        if (childUrl == null) {
            return new JsonNode(n, parentKey, o2, ct2);
        }
        return this.getNode(childUrl, new JsonNode(n, parentKey, o2, ct2));
    }

    private Object convert(Object in, ClassMeta cm) {
        if (cm == null) {
            return in;
        }
        if (cm.isBean() && in instanceof Map) {
            return this.bc.convertToType(in, cm);
        }
        return in;
    }

    private int parseInt(String key) {
        try {
            return Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            throw new PojoRestException(400, "Cannot address an item in an array with a non-integer key ''{0}''", key);
        }
    }

    class JsonNode {
        Object o;
        ClassMeta cm;
        JsonNode parent;
        String keyName;

        JsonNode(JsonNode parent, String keyName, Object o, ClassMeta cm) {
            this.o = o;
            this.keyName = keyName;
            this.parent = parent;
            if (cm == null || cm.isObject()) {
                cm = o == null ? PojoRest.this.bc.object() : PojoRest.this.bc.getClassMetaForObject(o);
            }
            this.cm = cm;
        }
    }
}

