/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Scanner;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class IOPipe {
    private Object input;
    private Object output;
    private boolean byLines;
    private boolean closeIn = true;
    private boolean closeOut;
    private int buffSize = 1024;
    private LineProcessor lineProcessor;

    private IOPipe(Object input, Object output) {
        ThrowableUtils.assertFieldNotNull(input, "input");
        ThrowableUtils.assertFieldNotNull(output, "output");
        if (input instanceof CharSequence) {
            this.input = new StringReader(input.toString());
        } else if (input instanceof InputStream || input instanceof Reader) {
            this.input = input;
        } else {
            ThrowableUtils.illegalArg("Invalid input class type.  Must be one of the following:  InputStream, Reader, CharSequence", new Object[0]);
        }
        if (output instanceof OutputStream || output instanceof Writer) {
            this.output = output;
        } else {
            ThrowableUtils.illegalArg("Invalid output class type.  Must be one of the following:  OutputStream, Writer", new Object[0]);
        }
    }

    public static IOPipe create(Object input, Object output) {
        return new IOPipe(input, output);
    }

    public IOPipe closeOut() {
        this.closeOut = true;
        return this;
    }

    public IOPipe close(boolean in, boolean out) {
        this.closeIn = in;
        this.closeOut = out;
        return this;
    }

    public IOPipe buffSize(int buffSize) {
        ThrowableUtils.assertFieldPositive(buffSize, "buffSize");
        this.buffSize = buffSize;
        return this;
    }

    public IOPipe byLines(boolean byLines) {
        this.byLines = byLines;
        return this;
    }

    public IOPipe byLines() {
        this.byLines = true;
        return this;
    }

    public IOPipe lineProcessor(LineProcessor lineProcessor) {
        this.lineProcessor = lineProcessor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws IOException {
        int c;
        block12: {
            c = 0;
            try {
                int i;
                if (this.input instanceof InputStream && this.output instanceof OutputStream && this.lineProcessor == null) {
                    int i2;
                    InputStream in = (InputStream)this.input;
                    OutputStream out = (OutputStream)this.output;
                    byte[] b = new byte[this.buffSize];
                    while ((i2 = in.read(b)) > 0) {
                        c += i2;
                        out.write(b, 0, i2);
                    }
                    break block12;
                }
                Reader in = this.input instanceof Reader ? (Reader)this.input : new InputStreamReader((InputStream)this.input, IOUtils.UTF8);
                Writer out = this.output instanceof Writer ? (Writer)this.output : new OutputStreamWriter((OutputStream)this.output, IOUtils.UTF8);
                this.output = out;
                this.input = in;
                if (this.byLines || this.lineProcessor != null) {
                    Scanner s = new Scanner(in);
                    try {
                        while (s.hasNextLine()) {
                            String l = s.nextLine();
                            if (this.lineProcessor != null) {
                                l = this.lineProcessor.process(l);
                            }
                            if (l == null) continue;
                            out.write(l);
                            out.write("\n");
                            out.flush();
                            c += l.length() + 1;
                        }
                        break block12;
                    }
                    finally {
                        s.close();
                    }
                }
                char[] b = new char[this.buffSize];
                while ((i = in.read(b)) > 0) {
                    c += i;
                    out.write(b, 0, i);
                }
            }
            finally {
                this.closeQuietly(this.input, this.output);
            }
        }
        return c;
    }

    private void closeQuietly(Object input, Object output) {
        if (this.closeIn) {
            IOUtils.closeQuietly(input);
        }
        if (this.closeOut) {
            IOUtils.closeQuietly(output);
        }
    }

    public static interface LineProcessor {
        public String process(String var1);
    }
}

