/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.urlencoding.UonSerializer;
import org.apache.juneau.urlencoding.UonWriter;
import org.apache.juneau.urlencoding.UrlEncodingSerializerContext;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

@Produces(value="application/x-www-form-urlencoded")
public class UrlEncodingSerializer
extends UonSerializer {
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer().lock();
    public static final UrlEncodingSerializer DEFAULT_SIMPLE = new Simple().lock();
    public static final UrlEncodingSerializer DEFAULT_SIMPLE_EXPANDED = new SimpleExpanded().lock();
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable().lock();

    public UrlEncodingSerializer() {
        this.setProperty("UonSerializer.encodeChars", true);
    }

    private SerializerWriter serializeAnything(UrlEncodingSerializerSession session, UonWriter out, Object o) throws Exception {
        BeanContext bc = session.getBeanContext();
        ClassMeta<Object> aType = session.push("root", o, this.object());
        --session.indent;
        if (aType == null) {
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        boolean addTypeProperty = session.isAddBeanTypeProperties();
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(o, bc);
            if (sType.isObject()) {
                sType = bc.getClassMetaForObject(o);
            }
        }
        if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, addTypeProperty);
            } else {
                this.serializeMap(session, out, (Map)o, sType);
            }
        } else if (sType.hasToObjectMapMethod()) {
            this.serializeMap(session, out, sType.toObjectMap(o), sType);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, bc.forBean(o), addTypeProperty);
        } else if (sType.isCollection()) {
            this.serializeMap(session, out, this.getCollectionMap((Collection)o), bc.getMapClassMeta(Map.class, (Type)((Object)Integer.class), sType.getElementType()));
        } else {
            out.append("_value=");
            super.serializeAnything(session, out, o, null, null, null, false, true);
        }
        session.pop();
        return out;
    }

    private Map<Integer, Object> getCollectionMap(Collection<?> c) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        int i = 0;
        for (Object o : c) {
            m.put(i++, o);
        }
        return m;
    }

    private SerializerWriter serializeMap(UrlEncodingSerializerSession session, UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        int depth = session.getIndent();
        boolean addAmp = false;
        for (Map.Entry e : m.entrySet()) {
            Object value = e.getValue();
            Object key = session.generalize(e.getKey(), keyType);
            if (session.shouldUseExpandedParams(value)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(depth).append('&');
                    }
                    out.appendObject(key, false, true, true).append('=');
                    super.serializeAnything(session, out, i.next(), null, key == null ? null : key.toString(), null, false, true);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(depth).append('&');
            }
            out.appendObject(key, false, true, true).append('=');
            super.serializeAnything(session, out, value, valueType, key == null ? null : key.toString(), null, false, true);
            addAmp = true;
        }
        return out;
    }

    private SerializerWriter serializeBeanMap(UrlEncodingSerializerSession session, UonWriter out, BeanMap<?> m, boolean addTypeProperty) throws Exception {
        int depth = session.getIndent();
        boolean addAmp = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), addTypeProperty ? session.createBeanTypeNameProperty(m) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (value != null && session.shouldUseExpandedParams(pMeta)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = cMeta.isCollection() || value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(depth).append('&');
                    }
                    out.appendObject(key, false, true, true).append('=');
                    super.serializeAnything(session, out, i.next(), cMeta.getElementType(), key, pMeta, false, true);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(depth).append('&');
            }
            out.appendObject(key, false, true, true).append('=');
            super.serializeAnything(session, out, value, cMeta, key, pMeta, false, true);
            addAmp = true;
        }
        return out;
    }

    public String serializeUrlPart(Object o) {
        try {
            ClassMeta<Object> cm = this.getBeanContext().getClassMetaForObject(o);
            if (cm != null && (cm.isCharSequence() || cm.isNumber() || cm.isBoolean())) {
                return o.toString();
            }
            StringWriter w = new StringWriter();
            UrlEncodingSerializerSession s = this.createSession(w, null, null);
            super.doSerialize(s, o);
            return w.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UrlEncodingSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new UrlEncodingSerializerSession(this.getContext(UrlEncodingSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        UrlEncodingSerializerSession s = (UrlEncodingSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o);
    }

    @Override
    public UrlEncodingSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public UrlEncodingSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public UrlEncodingSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> UrlEncodingSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public UrlEncodingSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public UrlEncodingSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public UrlEncodingSerializer clone() {
        UrlEncodingSerializer c = (UrlEncodingSerializer)super.clone();
        return c;
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable() {
            this.setProperty("UonSerializer.useWhitespace", true);
        }
    }

    @Produces(value="application/x-www-form-urlencoded-simple", contentType="application/x-www-form-urlencoded")
    public static class SimpleExpanded
    extends Simple {
        public SimpleExpanded() {
            this.setProperty("UrlEncoding.expandedParams", true);
        }
    }

    @Produces(value="application/x-www-form-urlencoded-simple", contentType="application/x-www-form-urlencoded")
    public static class Simple
    extends UrlEncodingSerializer {
        public Simple() {
            this.setProperty("UonSerializer.simpleMode", true);
        }
    }
}

