/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionary;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.urlencoding.UonParser;
import org.apache.juneau.urlencoding.UonParserSession;
import org.apache.juneau.urlencoding.UonReader;
import org.apache.juneau.urlencoding.UrlEncodingParserContext;
import org.apache.juneau.urlencoding.UrlEncodingParserSession;

@Consumes(value="application/x-www-form-urlencoded")
public class UrlEncodingParser
extends UonParser {
    public static final UrlEncodingParser DEFAULT = new UrlEncodingParser().lock();
    public static final UrlEncodingParser DEFAULT_WS_AWARE = new UrlEncodingParser().setProperty("UonParser.whitespaceAware", true).lock();

    public UrlEncodingParser() {
        this.setProperty("UonParser.decodeChars", true);
    }

    private <T> T parseAnything(UrlEncodingParserSession session, ClassMeta<T> eType, ParserReader r, Object outer) throws Exception {
        Object o;
        BeanContext bc = session.getBeanContext();
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<T, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        BeanDictionary bd = bc.getBeanDictionary();
        int c = r.peek();
        if (c == 63) {
            r.read();
        }
        if (sType.isObject()) {
            ObjectMap m = new ObjectMap(bc);
            this.parseIntoMap(session, r, m, bc.string(), bc.object());
            o = m.containsKey("_value") ? m.get("_value") : bd.cast(m);
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance() ? (Map)sType.newInstance() : new ObjectMap(bc);
            o = this.parseIntoMap(session, r, m, sType.getKeyType(), sType.getValueType());
        } else if (sType.canCreateNewInstanceFromObjectMap(outer)) {
            ObjectMap m = new ObjectMap(bc);
            this.parseIntoMap(session, r, m, this.string(), this.object());
            o = sType.newInstanceFromObjectMap(outer, m);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<?> m = bc.newBeanMap(outer, sType.getInnerClass());
            o = (m = this.parseIntoBeanMap(session, r, m)) == null ? null : m.getBean();
        } else {
            ObjectMap m = new ObjectMap(bc);
            ClassMeta<Object> valueType = this.object();
            this.parseIntoMap(session, r, m, this.string(), valueType);
            if (m.containsKey(bc.getBeanTypePropertyName())) {
                o = bd.cast(m);
            } else if (m.containsKey("_value")) {
                o = session.getBeanContext().convertToType(m.get("_value"), sType);
            } else if (sType.isCollection()) {
                Collection<Object> c2 = sType.canCreateNewInstance() ? (Collection)sType.newInstance() : new ObjectList(bc);
                TreeMap t = new TreeMap();
                for (Map.Entry<String, Object> e : m.entrySet()) {
                    String k = e.getKey();
                    if (!StringUtils.isNumeric(k)) continue;
                    t.put(Integer.valueOf(k), bc.convertToType(e.getValue(), sType.getElementType()));
                }
                c2.addAll(t.values());
                o = c2;
            } else {
                if (sType.getNotABeanReason() != null) {
                    throw new ParseException(session, "Class ''{0}'' could not be instantiated as application/x-www-form-urlencoded.  Reason: ''{1}''", sType, sType.getNotABeanReason());
                }
                throw new ParseException(session, "Malformed application/x-www-form-urlencoded input for class ''{0}''.", sType);
            }
        }
        if (transform != null && o != null) {
            o = transform.unswap(o, eType, bc);
        }
        if (outer != null) {
            this.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonParserSession session, ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType) throws Exception {
        int c;
        if (keyType == null) {
            keyType = this.string();
        }
        if ((c = r.peek()) == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        Object currAttr = null;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    Object attr = this.parseAttr(session, r, true);
                    currAttr = session.trim(session.getBeanContext().convertToType(attr, keyType));
                    state = 2;
                    c = 0;
                } else if (state == 2) {
                    if (c == 2) {
                        state = 3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, null);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    Object value;
                    if (c == -1 || c == 1) {
                        value = this.convertAttrToType(session, m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        String string = value = valueType.isString() ? super.parseString(session, r.unread(), true) : super.parseAnything(session, valueType, r.unread(), m, true, null);
                        if (m.containsKey(currAttr) && valueType.isObject()) {
                            Object v2 = m.get(currAttr);
                            if (!(v2 instanceof ObjectList)) {
                                v2 = new ObjectList(v2);
                                m.put(currAttr, v2);
                            }
                            ((ObjectList)v2).add(value);
                        } else {
                            m.put(currAttr, value);
                        }
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 1) {
                        state = 1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap(UrlEncodingParserSession session, ParserReader r, BeanMap<T> m) throws Exception {
        BeanContext bc = session.getBeanContext();
        int c = r.peek();
        if (c == -1) {
            return m;
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == -1) {
                        return m;
                    }
                    r.unread();
                    currAttrLine = r.getLine();
                    currAttrCol = r.getColumn();
                    currAttr = this.parseAttrName(session, r, true);
                    if (currAttr == null) {
                        return null;
                    }
                    state = 2;
                } else if (state == 2) {
                    if (c == 2) {
                        state = 3;
                    } else if (c == -1 || c == 1) {
                        m.put(currAttr, (Object)null);
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    ClassMeta<?> cm;
                    BeanPropertyMeta pMeta;
                    if (c == -1 || c == 1) {
                        if (!currAttr.equals(bc.getBeanTypePropertyName())) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                if (m.getMeta().isSubTyped()) {
                                    m.put(currAttr, (Object)"");
                                } else {
                                    this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                                }
                            } else {
                                session.setCurrentProperty(pMeta);
                                cm = pMeta.getClassMeta();
                                if (cm.canCreateNewInstance()) {
                                    pMeta.set(m, cm.newInstance());
                                }
                                session.setCurrentProperty(null);
                            }
                        }
                        if (c == -1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        if (!currAttr.equals(bc.getBeanTypePropertyName())) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                if (m.getMeta().isSubTyped()) {
                                    Object value = this.parseAnything(session, this.object(), r.unread(), m.getBean(false), true, null);
                                    m.put(currAttr, value);
                                } else {
                                    this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                                    this.parseAnything(session, this.object(), r.unread(), m.getBean(false), true, null);
                                }
                            } else {
                                Object value;
                                session.setCurrentProperty(pMeta);
                                if (session.shouldUseExpandedParams(pMeta)) {
                                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                                    value = this.parseAnything(session, et, r.unread(), m.getBean(false), true, pMeta);
                                    this.setName(et, value, currAttr);
                                    pMeta.add(m, value);
                                } else {
                                    cm = pMeta.getClassMeta();
                                    value = this.parseAnything(session, cm, r.unread(), m.getBean(false), true, pMeta);
                                    this.setName(cm, value, currAttr);
                                    pMeta.set(m, value);
                                }
                                session.setCurrentProperty(null);
                            }
                        }
                        state = 4;
                    }
                } else if (state == 4) {
                    if (c == 1) {
                        state = 1;
                    } else if (c == -1) {
                        return m;
                    }
                }
            }
            isInEscape = c == 92 && !isInEscape;
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Could not find value following '=' on object.", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> parseIntoSimpleMap(String qs) throws Exception {
        TreeMap<String, String[]> m = new TreeMap<String, String[]>();
        if (StringUtils.isEmpty(qs)) {
            return m;
        }
        UonReader r = new UonReader(qs, true);
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        try {
            int c = r.peek();
            if (c == 63) {
                r.read();
            }
            int state = 1;
            String currAttr = null;
            while (c != -1) {
                c = r.read();
                if (state == 1) {
                    if (c == -1) continue;
                    r.unread();
                    r.mark();
                    state = 2;
                    continue;
                }
                if (state == 2) {
                    if (c == -1) {
                        UrlEncodingParser.add(m, r.getMarked(), null);
                        continue;
                    }
                    if (c == 1) {
                        m.put(r.getMarked(0, -1), null);
                        state = 1;
                        continue;
                    }
                    if (c != 2) continue;
                    currAttr = r.getMarked(0, -1);
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (c == -1 || c == 1) {
                        UrlEncodingParser.add(m, currAttr, "");
                        continue;
                    }
                    if (c == 2) {
                        r.replace('=');
                    }
                    r.unread();
                    r.mark();
                    state = 4;
                    continue;
                }
                if (state != 4) continue;
                if (c == -1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked());
                    continue;
                }
                if (c == 1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked(0, -1));
                    state = 1;
                    continue;
                }
                if (c != 2) continue;
                r.replace('=');
            }
        }
        finally {
            r.close();
        }
        return m;
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, ArrayUtils.append((Object[])m.get(key), val));
        } else {
            m.put(key, new String[]{val});
        }
    }

    private Object[] parseArgs(UrlEncodingParserSession session, ParserReader r, ClassMeta<?>[] argTypes) throws Exception {
        BeanContext bc = session.getBeanContext();
        ClassMeta<TreeMap> cm = bc.getMapClassMeta(TreeMap.class, Integer.class, String.class);
        TreeMap m = this.parseAnything(session, cm, r, session.getOuter());
        Object[] vals = m.values().toArray(new Object[m.size()]);
        if (vals.length != argTypes.length) {
            throw new ParseException(session, "Argument lengths don't match.  vals={0}, argTypes={1}", vals.length, argTypes.length);
        }
        for (int i = 0; i < vals.length; ++i) {
            String s = String.valueOf(vals[i]);
            vals[i] = super.parseAnything(session, argTypes[i], new UonReader(s, false), session.getOuter(), true, null);
        }
        return vals;
    }

    public <T> T parseParameter(CharSequence in, ClassMeta<T> type) throws ParseException {
        if (in == null) {
            return null;
        }
        UonParserSession session = this.createParameterContext(in);
        try {
            UonReader r = session.getReader();
            T t = super.parseAnything(session, type, r, null, true, null);
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    public <T> T parseParameter(CharSequence in, Class<T> type) throws ParseException {
        return this.parseParameter(in, this.getBeanContext().getClassMeta(type));
    }

    @Override
    public UrlEncodingParserSession createSession(Object input, ObjectMap properties, Method javaMethod, Object outer) {
        return new UrlEncodingParserSession(this.getContext(UrlEncodingParserContext.class), this.getBeanContext(), input, properties, javaMethod, outer);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        UrlEncodingParserSession s = (UrlEncodingParserSession)session;
        type = s.getBeanContext().normalizeClassMeta(type);
        UonReader r = s.getReader();
        T o = this.parseAnything(s, type, r, s.getOuter());
        return o;
    }

    @Override
    protected Object[] doParseArgs(ParserSession session, ClassMeta<?>[] argTypes) throws Exception {
        UrlEncodingParserSession uctx = (UrlEncodingParserSession)session;
        UonReader r = uctx.getReader();
        Object[] a = this.parseArgs(uctx, r, argTypes);
        return a;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        UrlEncodingParserSession s = (UrlEncodingParserSession)session;
        UonReader r = s.getReader();
        if (r.peek() == 63) {
            r.read();
        }
        m = this.parseIntoMap(s, r, m, s.getBeanContext().getClassMeta(keyType), s.getBeanContext().getClassMeta(valueType));
        return m;
    }

    @Override
    public UrlEncodingParser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public UrlEncodingParser setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public UrlEncodingParser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingParser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingParser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public UrlEncodingParser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> UrlEncodingParser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public UrlEncodingParser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public UrlEncodingParser lock() {
        super.lock();
        return this;
    }

    @Override
    public UrlEncodingParser clone() {
        UrlEncodingParser c = (UrlEncodingParser)super.clone();
        return c;
    }
}

