/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.urlencoding.UonSerializerSession;

public final class UonWriter
extends SerializerWriter {
    private final UonSerializerSession session;
    private final boolean simpleMode;
    private final boolean encodeChars;
    private static final AsciiSet unencodedChars = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/?:@-_.!*'$(),~=");
    private static final AsciiSet unencodedCharsAttrName = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/?:@-_.!*'$(),~");
    private static final AsciiSet escapedChars = new AsciiSet(",()~=");
    private static final AsciiSet emptyCharSet = new AsciiSet("");
    private static char[] hexArray = "0123456789ABCDEF".toCharArray();

    protected UonWriter(UonSerializerSession session, Writer out, boolean useIndentation, boolean simpleMode, boolean encodeChars, boolean trimStrings, String relativeUriBase, String absolutePathUriBase) {
        super(out, useIndentation, false, trimStrings, '\'', relativeUriBase, absolutePathUriBase);
        this.session = session;
        this.simpleMode = simpleMode;
        this.encodeChars = encodeChars;
    }

    protected UonWriter appendObject(Object o, boolean quoteEmptyStrings, boolean isTopAttrName, boolean isTop) throws IOException {
        int typeFlag = 0;
        if (o == null) {
            o = "\u0000";
        } else if (o.equals("\u0000")) {
            typeFlag = 115;
        }
        String s = this.session.toString(o);
        if (s.isEmpty()) {
            if (quoteEmptyStrings) {
                typeFlag = 115;
            }
        } else if (s.charAt(0) == '(' || s.charAt(0) == '$') {
            typeFlag = 115;
        } else if (this.useIndentation && (s.indexOf(10) != -1 || s.charAt(0) <= ' ' && s.charAt(0) != '\u0000')) {
            typeFlag = 115;
        } else if (!this.simpleMode) {
            if (o instanceof Boolean) {
                typeFlag = 98;
            } else if (o instanceof Number) {
                typeFlag = 110;
            }
        }
        if (typeFlag != 0) {
            this.startFlag((char)typeFlag);
        }
        AsciiSet unenc = isTopAttrName ? unencodedCharsAttrName : unencodedChars;
        AsciiSet esc = isTop && typeFlag == 0 ? emptyCharSet : escapedChars;
        for (int i = 0; i < s.length(); ++i) {
            int p2;
            int p1;
            char c = s.charAt(i);
            if (esc.contains(c)) {
                this.append('~');
            }
            if (!this.encodeChars || unenc.contains(c)) {
                this.append(c);
                continue;
            }
            if (c == ' ') {
                this.append('+');
                continue;
            }
            int p = s.codePointAt(i);
            if (p < 128) {
                this.appendHex(p);
                continue;
            }
            if (p < 2048) {
                p1 = p >>> 6;
                this.appendHex(p1 + 192).appendHex((p & 0x3F) + 128);
                continue;
            }
            if (p < 65536) {
                p1 = p >>> 6;
                p2 = p1 >>> 6;
                this.appendHex(p2 + 224).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
                continue;
            }
            ++i;
            p1 = p >>> 6;
            p2 = p1 >>> 6;
            int p3 = p2 >>> 6;
            this.appendHex(p3 + 240).appendHex((p2 & 0x3F) + 128).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
        }
        if (typeFlag != 0) {
            this.append(')');
        }
        return this;
    }

    protected UonWriter startFlag(char f) throws IOException {
        if (f != 's' && !this.simpleMode) {
            this.append('$').append(f);
        }
        this.append('(');
        return this;
    }

    private UonWriter appendHex(int b) throws IOException {
        if (b > 255) {
            throw new IOException("Invalid value passed to appendHex.  Must be in the range 0-255.  Value=" + b);
        }
        this.append('%').append(hexArray[b >>> 4]).append(hexArray[b & 0xF]);
        return this;
    }

    public SerializerWriter appendUri(Object uri, boolean isTop) throws IOException {
        String s = uri.toString();
        if (s.indexOf("://") == -1) {
            if (StringUtils.startsWith(s, '/')) {
                if (this.absolutePathUriBase != null) {
                    this.append(this.absolutePathUriBase);
                }
            } else if (this.relativeUriBase != null) {
                this.append(this.relativeUriBase);
                if (!this.relativeUriBase.equals("/")) {
                    this.append("/");
                }
            }
        }
        return this.appendObject(s, false, false, isTop);
    }

    @Override
    public UonWriter cr(int depth) throws IOException {
        super.cr(depth);
        return this;
    }

    @Override
    public UonWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public UonWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public UonWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public UonWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public UonWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public UonWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public UonWriter nl() throws IOException {
        super.nl();
        return this;
    }

    @Override
    public UonWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, String text) throws IOException {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, char c) throws IOException {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public UonWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }
}

