/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.urlencoding.UonSerializerContext;
import org.apache.juneau.urlencoding.UonWriter;

public class UonSerializerSession
extends SerializerSession {
    private final boolean simpleMode;
    private final boolean useWhitespace;
    private final boolean encodeChars;

    protected UonSerializerSession(UonSerializerContext ctx, BeanContext beanContext, Object output, ObjectMap op, Method javaMethod) {
        super(ctx, beanContext, output, op, javaMethod);
        if (op == null || op.isEmpty()) {
            this.simpleMode = ctx.simpleMode;
            this.useWhitespace = ctx.useWhitespace;
            this.encodeChars = ctx.encodeChars;
        } else {
            this.simpleMode = op.getBoolean("UonSerializer.simpleMode", ctx.simpleMode);
            this.useWhitespace = op.getBoolean("UonSerializer.useWhitespace", ctx.useWhitespace);
            this.encodeChars = op.getBoolean("UonSerializer.encodeChars", ctx.encodeChars);
        }
    }

    @Override
    public final UonWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof UonWriter) {
            return (UonWriter)output;
        }
        return new UonWriter(this, super.getWriter(), this.useWhitespace, this.isSimpleMode(), this.isEncodeChars(), this.isTrimStrings(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }

    public final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    public final boolean isSimpleMode() {
        return this.simpleMode;
    }

    public final boolean isEncodeChars() {
        return this.encodeChars;
    }
}

