/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.urlencoding.UonSerializerContext;
import org.apache.juneau.urlencoding.UonSerializerSession;
import org.apache.juneau.urlencoding.UonWriter;

@Produces(value="text/uon")
public class UonSerializer
extends WriterSerializer {
    public static final UonSerializer DEFAULT = new UonSerializer().lock();
    public static final UonSerializer DEFAULT_SIMPLE = new Simple().lock();
    public static final UonSerializer DEFAULT_READABLE = new Readable().lock();
    public static final UonSerializer DEFAULT_ENCODING = new Encoding().lock();
    public static final UonSerializer DEFAULT_SIMPLE_ENCODING = new SimpleEncoding().lock();

    protected SerializerWriter serializeAnything(UonSerializerSession session, UonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta, boolean quoteEmptyStrings, boolean isTop) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        BeanContext bc = session.getBeanContext();
        if (o == null) {
            out.appendObject(null, false, false, isTop);
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        boolean addTypeProperty = session.isAddBeanTypeProperties() && !eType.equals(aType);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(o, bc);
            if (sType.isObject()) {
                sType = bc.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendObject(null, false, false, isTop);
        } else if (sType.hasToObjectMapMethod()) {
            this.serializeMap(session, out, sType.toObjectMap(o), eType);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, bc.forBean(o), addTypeProperty);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendUri(o, isTop);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, addTypeProperty);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, this.toList(sType.getInnerClass(), o), eType);
        } else {
            out.appendObject(o, quoteEmptyStrings, false, isTop);
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(UonSerializerSession session, UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        int depth = session.getIndent();
        out.startFlag('o');
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = session.generalize(e.getKey(), keyType);
            out.cr(depth).appendObject(key, session.isUseWhitespace(), false, false).append('=');
            this.serializeAnything(session, out, value, valueType, key == null ? null : session.toString(key), null, session.isUseWhitespace(), false);
            if (!mapEntries.hasNext()) continue;
            out.append(',');
        }
        if (m.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    private SerializerWriter serializeBeanMap(UonSerializerSession session, UonWriter out, BeanMap<?> m, boolean addTypeProperty) throws Exception {
        int depth = session.getIndent();
        out.startFlag('o');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), addTypeProperty ? session.createBeanTypeNameProperty(m) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',');
            }
            out.cr(depth).appendObject(key, false, false, false).append('=');
            this.serializeAnything(session, out, value, cMeta, key, pMeta, false, false);
            addComma = true;
        }
        if (m.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    private SerializerWriter serializeCollection(UonSerializerSession session, UonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = session.sort(c);
        out.startFlag('a');
        int depth = session.getIndent();
        boolean quoteEmptyString = c.size() == 1 || session.isUseWhitespace();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            out.cr(depth);
            this.serializeAnything(session, out, i.next(), elementType, "<iterator>", null, quoteEmptyString, false);
            if (!i.hasNext()) continue;
            out.append(',');
        }
        if (c.size() > 0) {
            out.cr(depth - 1);
        }
        out.append(')');
        return out;
    }

    @Override
    public UonSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new UonSerializerSession(this.getContext(UonSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        UonSerializerSession s = (UonSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o, null, "root", null, false, true);
    }

    @Override
    public UonSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public UonSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public UonSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public UonSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public UonSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public UonSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> UonSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public UonSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public UonSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public UonSerializer clone() {
        try {
            UonSerializer c = (UonSerializer)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Produces(value="text/uon-simple", contentType="text/uon")
    public static class SimpleEncoding
    extends UonSerializer {
        public SimpleEncoding() {
            this.setProperty("UonSerializer.simpleMode", true);
            this.setProperty("UonSerializer.encodeChars", true);
        }
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding() {
            this.setProperty("UonSerializer.encodeChars", true);
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable() {
            this.setProperty("UonSerializer.useWhitespace", true);
            this.setProperty("Serializer.useIndentation", true);
        }
    }

    @Produces(value="text/uon-simple", contentType="text/uon")
    public static class Simple
    extends UonSerializer {
        public Simple() {
            this.setProperty("UonSerializer.simpleMode", true);
        }
    }
}

