/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.urlencoding.UonParserContext;
import org.apache.juneau.urlencoding.UonReader;

public class UonParserSession
extends ParserSession {
    private final boolean decodeChars;
    private final boolean whitespaceAware;
    private UonReader reader;

    public UonParserSession(UonParserContext ctx, BeanContext beanContext, Object input, ObjectMap op, Method javaMethod, Object outer) {
        super(ctx, beanContext, input, op, javaMethod, outer);
        if (op == null || op.isEmpty()) {
            this.decodeChars = ctx.decodeChars;
            this.whitespaceAware = ctx.whitespaceAware;
        } else {
            this.decodeChars = op.getBoolean("UonParser.decodeChars", ctx.decodeChars);
            this.whitespaceAware = op.getBoolean("UonParser.whitespaceAware", ctx.whitespaceAware);
        }
    }

    public UonParserSession(UonParserContext ctx, BeanContext beanContext, Object input) {
        super(ctx, beanContext, input, null, null, null);
        this.decodeChars = false;
        this.whitespaceAware = ctx.whitespaceAware;
    }

    public final boolean isDecodeChars() {
        return this.decodeChars;
    }

    public final boolean isWhitespaceAware() {
        return this.whitespaceAware;
    }

    @Override
    public UonReader getReader() throws Exception {
        if (this.reader == null) {
            Object input = this.getInput();
            this.reader = input instanceof UonReader ? (UonReader)input : (input instanceof CharSequence ? new UonReader((CharSequence)input, this.decodeChars) : new UonReader(super.getReader(), this.decodeChars));
        }
        return this.reader;
    }

    @Override
    public Map<String, Object> getLastLocation() {
        Map<String, Object> m = super.getLastLocation();
        if (this.reader != null) {
            m.put("line", this.reader.getLine());
            m.put("column", this.reader.getColumn());
        }
        return m;
    }
}

