/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionary;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.urlencoding.UonParserContext;
import org.apache.juneau.urlencoding.UonParserSession;
import org.apache.juneau.urlencoding.UonReader;

@Consumes(value="text/uon")
public class UonParser
extends ReaderParser {
    public static final UonParser DEFAULT = new UonParser().lock();
    public static final UonParser DEFAULT_DECODING = new Decoding().lock();
    public static final UonParser DEFAULT_WS_AWARE = new UonParser().setProperty("UonParser.whitespaceAware", true).lock();
    private static final AsciiSet escapedChars = new AsciiSet(",()~=$\u0001\u0002");
    private static final char NUL = '\u0000';
    private static final char AMP = '\u0001';
    private static final char EQ = '\u0002';
    private static final AsciiSet endCharsParam = new AsciiSet("\u0001");
    private static final AsciiSet endCharsNormal = new AsciiSet(",)\u0001");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T parseAnything(UonParserSession session, ClassMeta<T> eType, ParserReader r, Object outer, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        BeanContext bc = session.getBeanContext();
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        BeanDictionary bd = pMeta == null ? bc.getBeanDictionary() : pMeta.getBeanDictionary();
        Object o = null;
        char flag = UonParser.readFlag(session, r, '\u0000');
        int c = r.peek();
        if (c == -1 || c == 1) {
            if (sType.isArray() || sType.isCollection()) {
                o = sType.newInstance();
            } else if (sType.isString() || sType.isObject()) {
                o = "";
            } else if (sType.isPrimitive()) {
                o = sType.getPrimitiveDefault();
            }
        } else if (sType.isObject()) {
            if (flag == '\u0000' || flag == 's') {
                o = this.parseString(session, r, isUrlParamValue);
            } else if (flag == 'b') {
                o = this.parseBoolean(session, r);
            } else if (flag == 'n') {
                o = this.parseNumber(session, r, null);
            } else if (flag == 'o') {
                ObjectMap objectMap = new ObjectMap(bc);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                o = bd.cast(objectMap);
            } else {
                if (flag != 'a') throw new ParseException(session, "Unexpected flag character ''{0}''.", Character.valueOf(flag));
                ObjectList objectList = new ObjectList(bc);
                o = this.parseIntoCollection(session, r, objectList, sType.getElementType(), isUrlParamValue, pMeta);
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(session, r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(session, r, isUrlParamValue);
        } else if (sType.isChar()) {
            String string = this.parseString(session, r, isUrlParamValue);
            o = string == null ? null : Character.valueOf(string.charAt(0));
        } else if (sType.isNumber()) {
            o = this.parseNumber(session, r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(bc);
            o = this.parseIntoMap(session, r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (flag == 'o') {
                ObjectMap objectMap = new ObjectMap(bc);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(bc.getBeanTypePropertyName())) {
                    o = bd.cast(objectMap);
                } else {
                    Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(bc);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = l;
                }
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(bc);
                o = this.parseIntoCollection(session, r, collection, sType.getElementType(), isUrlParamValue, pMeta);
            }
        } else if (sType.canCreateNewInstanceFromObjectMap(outer)) {
            ObjectMap objectMap = new ObjectMap(bc);
            this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
            o = sType.newInstanceFromObjectMap(outer, objectMap);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<?> beanMap2 = bc.newBeanMap(outer, sType.getInnerClass());
            beanMap2 = this.parseIntoBeanMap(session, r, beanMap2);
            o = beanMap2 == null ? null : beanMap2.getBean();
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            String string = this.parseString(session, r, isUrlParamValue);
            if (string != null) {
                o = sType.newInstanceFromString(outer, string);
            }
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(outer, this.parseNumber(session, r, sType.getNewInstanceFromNumberClass()));
        } else if (sType.isArray()) {
            if (flag == 'o') {
                ObjectMap objectMap = new ObjectMap(bc);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(bc.getBeanTypePropertyName())) {
                    o = bd.cast(objectMap);
                } else {
                    ArrayList l = new ArrayList(1);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = bc.toArray(sType, l);
                }
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection(session, r, new ArrayList(), sType.getElementType(), isUrlParamValue, pMeta);
                o = bc.toArray(sType, arrayList);
            }
        } else {
            if (flag != 'o') throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            ObjectMap objectMap = new ObjectMap(bc);
            this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
            if (!objectMap.containsKey(bc.getBeanTypePropertyName())) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = bd.cast(objectMap);
        }
        if (transform != null && o != null) {
            o = transform.unswap(o, eType, bc);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonParserSession session, ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        int c;
        if (keyType == null) {
            keyType = this.string();
        }
        if ((c = r.read()) == -1 || c == 0 || c == 1) {
            return null;
        }
        if (c != 40) {
            throw new ParseException(session, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        Object currAttr = null;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41) {
                        return m;
                    }
                    if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                        UonParser.skipSpace(r);
                    } else {
                        r.unread();
                        Object attr = this.parseAttr(session, r, session.isDecodeChars());
                        currAttr = session.trim(attr == null ? null : (Object)session.getBeanContext().convertToType(attr, keyType));
                        state = 2;
                        c = 0;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (currAttr == null) {
                            r.unread();
                            return null;
                        }
                        m.put(currAttr, null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    V value;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        value = this.convertAttrToType(session, m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        value = this.parseAnything(session, valueType, r.unread(), m, false, pMeta);
                        this.setName(valueType, value, currAttr);
                        m.put(currAttr, value);
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    private <E> Collection<E> parseIntoCollection(UonParserSession session, ParserReader r, Collection<E> l, ClassMeta<E> elementType, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        boolean isInParens;
        int c = r.read();
        if (c == -1 || c == 0 || c == 1) {
            return null;
        }
        boolean bl = isInParens = c == 40;
        if (!isInParens) {
            if (isUrlParamValue) {
                r.unread();
            } else {
                throw new ParseException(session, "Could not find '(' marking beginning of collection.", new Object[0]);
            }
        }
        if (isInParens) {
            boolean S1 = true;
            int S2 = 2;
            int S3 = 3;
            int state = 1;
            while (c != -1 && c != 1) {
                c = r.read();
                if (state == 1 || state == 2) {
                    if (c == 41) {
                        if (state == 2) {
                            l.add(this.parseAnything(session, elementType, r.unread(), l, false, pMeta));
                            r.read();
                        }
                        return l;
                    }
                    if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                        UonParser.skipSpace(r);
                        continue;
                    }
                    l.add(this.parseAnything(session, elementType, r.unread(), l, false, pMeta));
                    state = 3;
                    continue;
                }
                if (state != 3) continue;
                if (c == 44) {
                    state = 2;
                    continue;
                }
                if (c != 41) continue;
                return l;
            }
            if (state == 1 || state == 2) {
                throw new ParseException(session, "Could not find start of entry in array.", new Object[0]);
            }
            if (state == 3) {
                throw new ParseException(session, "Could not find end of entry in array.", new Object[0]);
            }
        } else {
            boolean S1 = true;
            int S2 = 2;
            int state = 1;
            while (c != -1 && c != 1) {
                c = r.read();
                if (state == 1) {
                    if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                        UonParser.skipSpace(r);
                        continue;
                    }
                    l.add(this.parseAnything(session, elementType, r.unread(), l, false, pMeta));
                    state = 2;
                    continue;
                }
                if (state != 2) continue;
                if (c == 44) {
                    state = 1;
                    continue;
                }
                if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                    UonParser.skipSpace(r);
                    continue;
                }
                if (c != 1 && c != -1) continue;
                r.unread();
                return l;
            }
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap(UonParserSession session, ParserReader r, BeanMap<T> m) throws Exception {
        BeanContext bc = session.getBeanContext();
        int c = r.read();
        if (c == -1 || c == 0 || c == 1) {
            return null;
        }
        if (c != 40) {
            throw new ParseException(session, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                    if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                        UonParser.skipSpace(r);
                    } else {
                        r.unread();
                        currAttrLine = r.getLine();
                        currAttrCol = r.getColumn();
                        currAttr = this.parseAttrName(session, r, session.isDecodeChars());
                        if (currAttr == null) {
                            return null;
                        }
                        state = 2;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        m.put(currAttr, (Object)null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    Object value;
                    BeanPropertyMeta pMeta;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (!currAttr.equals(bc.getBeanTypePropertyName())) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                if (m.getMeta().isSubTyped()) {
                                    m.put(currAttr, (Object)"");
                                } else {
                                    this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                                }
                            } else {
                                value = session.getBeanContext().convertToType((Object)"", pMeta.getClassMeta());
                                pMeta.set(m, value);
                            }
                        }
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        if (!currAttr.equals(bc.getBeanTypePropertyName())) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                if (m.getMeta().isSubTyped()) {
                                    value = this.parseAnything(session, this.object(), r.unread(), m.getBean(false), false, null);
                                    m.put(currAttr, value);
                                } else {
                                    this.onUnknownProperty(session, currAttr, m, currAttrLine, currAttrCol);
                                    this.parseAnything(session, this.object(), r.unread(), m.getBean(false), false, null);
                                }
                            } else {
                                session.setCurrentProperty(pMeta);
                                ClassMeta<?> cm = pMeta.getClassMeta();
                                Object value2 = this.parseAnything(session, cm, r.unread(), m.getBean(false), false, pMeta);
                                this.setName(cm, value2, currAttr);
                                pMeta.set(m, value2);
                                session.setCurrentProperty(null);
                            }
                        }
                        state = 4;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Could not find value following '=' on object.", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    Object parseAttr(UonParserSession session, ParserReader r, boolean encoded) throws Exception {
        char f;
        int c = r.peek();
        Object attr = c == 36 ? ((f = UonParser.readFlag(session, r, '\u0000')) == 'b' ? this.parseBoolean(session, r) : (f == 'n' ? this.parseNumber(session, r, null) : this.parseAttrName(session, r, encoded))) : this.parseAttrName(session, r, encoded);
        return attr;
    }

    String parseAttrName(UonParserSession session, ParserReader r, boolean encoded) throws Exception {
        int c = r.peek();
        if (c == 36) {
            UonParser.readFlag(session, r, 's');
        }
        if (c == 40) {
            return UonParser.parsePString(session, r);
        }
        r.mark();
        boolean isInEscape = false;
        if (encoded) {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    if (c == 1 || c == 2 || c == -1) {
                        String s;
                        if (c != -1) {
                            r.unread();
                        }
                        return (s = r.getMarked()).equals("\u0000") ? null : s;
                    }
                } else if (c == 1) {
                    r.replace('&');
                } else if (c == 2) {
                    r.replace('=');
                }
                isInEscape = UonParser.isInEscape(c, r, isInEscape);
            }
        } else {
            while (c != -1) {
                c = r.read();
                if (!(isInEscape || c != 61 && c != -1)) {
                    String s;
                    if (c != -1) {
                        r.unread();
                    }
                    return (s = r.getMarked()).equals("\u0000") ? null : session.trim(s);
                }
                isInEscape = UonParser.isInEscape(c, r, isInEscape);
            }
        }
        throw new ParseException(session, "Unexpected condition.", new Object[0]);
    }

    private static final boolean isInEscape(int c, ParserReader r, boolean prevIsInEscape) throws Exception {
        if (c == 126 && !prevIsInEscape && escapedChars.contains(c = r.peek())) {
            r.delete();
            return true;
        }
        return false;
    }

    String parseString(UonParserSession session, ParserReader r, boolean isUrlParamValue) throws Exception {
        AsciiSet endChars;
        int c = r.peek();
        if (c == 40) {
            return UonParser.parsePString(session, r);
        }
        r.mark();
        boolean isInEscape = false;
        String s = null;
        AsciiSet asciiSet = endChars = isUrlParamValue ? endCharsParam : endCharsNormal;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && endChars.contains(c)) {
                r.unread();
                c = -1;
            }
            if (c == -1) {
                s = r.getMarked();
            } else if (c == 2) {
                r.replace('=');
            } else if ((c == 10 || c == 13) && session.isWhitespaceAware()) {
                s = r.getMarked(0, -1);
                UonParser.skipSpace(r);
                c = -1;
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        return s == null || s.equals("\u0000") ? null : session.trim(s);
    }

    static String parsePString(UonParserSession session, ParserReader r) throws Exception {
        r.read();
        r.mark();
        int c = 0;
        boolean isInEscape = false;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && c == 41) {
                return session.trim(r.getMarked(0, -1));
            }
            if (c == 2) {
                r.replace('=');
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        throw new ParseException(session, "Unmatched parenthesis", new Object[0]);
    }

    private Boolean parseBoolean(UonParserSession session, ParserReader r) throws Exception {
        UonParser.readFlag(session, r, 'b');
        String s = this.parseString(session, r, false);
        if (s == null) {
            return null;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new ParseException(session, "Unrecognized syntax for boolean.  ''{0}''.", s);
    }

    private Number parseNumber(UonParserSession session, ParserReader r, Class<? extends Number> c) throws Exception {
        UonParser.readFlag(session, r, 'n');
        String s = this.parseString(session, r, false);
        if (s == null) {
            return null;
        }
        return StringUtils.parseNumber(s, c);
    }

    private void validateEnd(UonParserSession session, ParserReader r) throws Exception {
        int c = r.read();
        if (c != -1) {
            throw new ParseException(session, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
        }
    }

    static char readFlag(UonParserSession session, ParserReader r, char expected) throws Exception {
        char c = (char)r.peek();
        if (c == '$') {
            r.read();
            char f = (char)r.read();
            if (expected != '\u0000' && f != expected) {
                throw new ParseException(session, "Unexpected flag character: ''{0}''.  Expected ''{1}''.", Character.valueOf(f), Character.valueOf(expected));
            }
            c = (char)r.peek();
            if (c != '(') {
                throw new ParseException(session, "Unexpected character following flag: ''{0}''.", Character.valueOf(c));
            }
            return f;
        }
        return '\u0000';
    }

    private Object[] parseArgs(UonParserSession session, ParserReader r, ClassMeta<?>[] argTypes) throws Exception {
        boolean S1 = true;
        int S2 = 2;
        Object[] o = new Object[argTypes.length];
        int i = 0;
        int c = r.read();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c != 40) {
            throw new ParseException(session, "Expected '(' at beginning of args array.", new Object[0]);
        }
        int state = 1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (state == 1) {
                if (c == 41) {
                    return o;
                }
                o[i] = this.parseAnything(session, argTypes[i], r.unread(), session.getOuter(), false, null);
                ++i;
                state = 2;
                continue;
            }
            if (state != 2) continue;
            if (c == 44) {
                state = 1;
                continue;
            }
            if (c != 41) continue;
            return o;
        }
        throw new ParseException(session, "Did not find ')' at the end of args array.", new Object[0]);
    }

    private static void skipSpace(ParserReader r) throws Exception {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (c <= 32 && c > 2) continue;
            r.unread();
            return;
        }
    }

    UonParserSession createParameterContext(Object input) {
        return new UonParserSession(this.getContext(UonParserContext.class), this.getBeanContext(), input);
    }

    @Override
    public UonParserSession createSession(Object input, ObjectMap properties, Method javaMethod, Object outer) {
        return new UonParserSession(this.getContext(UonParserContext.class), this.getBeanContext(), input, properties, javaMethod, outer);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        UonParserSession s = (UonParserSession)session;
        type = s.getBeanContext().normalizeClassMeta(type);
        UonReader r = s.getReader();
        T o = this.parseAnything(s, type, r, s.getOuter(), true, null);
        this.validateEnd(s, r);
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        UonParser.readFlag(s, r, 'o');
        m = this.parseIntoMap(s, r, m, s.getBeanContext().getClassMeta(keyType), s.getBeanContext().getClassMeta(valueType), null);
        this.validateEnd(s, r);
        return m;
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        UonParser.readFlag(s, r, 'a');
        c = this.parseIntoCollection(s, r, c, s.getBeanContext().getClassMeta(elementType), false, null);
        this.validateEnd(s, r);
        return c;
    }

    @Override
    protected Object[] doParseArgs(ParserSession session, ClassMeta<?>[] argTypes) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        UonParser.readFlag(s, r, 'a');
        Object[] a = this.parseArgs(s, r, argTypes);
        return a;
    }

    @Override
    public UonParser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public UonParser setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public UonParser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public UonParser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public UonParser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public UonParser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> UonParser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public UonParser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public UonParser lock() {
        super.lock();
        return this;
    }

    @Override
    public UonParser clone() {
        try {
            UonParser c = (UonParser)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Decoding
    extends UonParser {
        public Decoding() {
            this.setProperty("UonParser.decodeChars", true);
        }
    }
}

