/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class XMLGregorianCalendarSwap
extends PojoSwap<XMLGregorianCalendar, String> {
    private DatatypeFactory dtf;

    public XMLGregorianCalendarSwap() {
        try {
            this.dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String swap(XMLGregorianCalendar b) throws SerializeException {
        return b.toXMLFormat();
    }

    @Override
    public XMLGregorianCalendar unswap(String s) throws ParseException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        return this.dtf.newXMLGregorianCalendar(s);
    }
}

