/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.PojoSwap;

public class DateSwap
extends PojoSwap<java.util.Date, String> {
    private DateFormat format;

    public DateSwap(String simpleDateFormat) {
        this(new SimpleDateFormat(simpleDateFormat));
    }

    public DateSwap(String simpleDateFormat, String timeZone) {
        this(new SimpleDateFormat(simpleDateFormat));
        this.format.setTimeZone(TimeZone.getTimeZone(timeZone));
    }

    public DateSwap(DateFormat format) {
        this.format = format;
    }

    @Override
    public String swap(java.util.Date o) {
        return this.format.format(o);
    }

    @Override
    public java.util.Date unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
        try {
            if (StringUtils.isEmpty(o)) {
                return null;
            }
            java.util.Date d = this.format.parse(o);
            return DateSwap.convert(d, hint);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static java.util.Date convert(java.util.Date in, ClassMeta<?> hint) throws Exception {
        if (in == null) {
            return null;
        }
        if (hint == null || hint.isInstance(in)) {
            return in;
        }
        Class<?> c = hint.getInnerClass();
        if (c == java.util.Date.class) {
            return in;
        }
        if (c == Date.class) {
            return new Date(in.getTime());
        }
        if (c == Time.class) {
            return new Time(in.getTime());
        }
        if (c == Timestamp.class) {
            return new Timestamp(in.getTime());
        }
        throw new ParseException("DateSwap is unable to narrow object of type ''{0}''", c);
    }

    public static class Medium
    extends DateSwap {
        public Medium() {
            super(DateFormat.getDateInstance(2));
        }
    }

    public static class SimpleTP
    extends DateSwap {
        public SimpleTP() {
            super("HH:mm:ss.SSS");
        }
    }

    public static class SimpleT
    extends DateSwap {
        public SimpleT() {
            super("HH:mm:ss");
        }
    }

    public static class SimpleDTP
    extends DateSwap {
        public SimpleDTP() {
            super("yyyy/MM/dd HH:mm:ss.SSS");
        }
    }

    public static class SimpleDT
    extends DateSwap {
        public SimpleDT() {
            super("yyyy/MM/dd HH:mm:ss");
        }
    }

    public static class RFC2822D
    extends DateSwap {
        public RFC2822D() {
            super("dd MMM yyyy");
        }
    }

    public static class RFC2822DTZ
    extends DateSwap {
        public RFC2822DTZ() {
            super("EEE, dd MMM yyyy HH:mm:ss z", "GMT");
        }
    }

    public static class RFC2822DT
    extends DateSwap {
        public RFC2822DT() {
            super("EEE, dd MMM yyyy HH:mm:ss z");
        }
    }

    public static class ISO8601DTZP
    extends ISO8601DT {
        public ISO8601DTZP() {
            super("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public static class ISO8601DTZ
    extends DateSwap {
        public ISO8601DTZ() {
            this("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }

        protected ISO8601DTZ(String pattern) {
            super(pattern, "GMT");
        }

        @Override
        public java.util.Date unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return DateSwap.convert(DatatypeConverter.parseDateTime((String)o).getTime(), hint);
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public static class ISO8601DTPNZ
    extends DateSwap {
        public ISO8601DTPNZ() {
            super("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public static class ISO8601DTP
    extends ISO8601DT {
        public ISO8601DTP() {
            super("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public static class ISO8601DT
    extends DateSwap {
        private SimpleDateFormat tzFormat = new SimpleDateFormat("Z");

        public ISO8601DT() {
            this("yyyy-MM-dd'T'HH:mm:ss");
        }

        protected ISO8601DT(String pattern) {
            super(pattern);
        }

        @Override
        public java.util.Date unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return DateSwap.convert(DatatypeConverter.parseDateTime((String)o).getTime(), hint);
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(java.util.Date o) {
            String s = super.swap(o);
            String tz = this.tzFormat.format(o);
            if (tz.equals("+0000")) {
                return s + "Z";
            }
            return s + tz.substring(0, 3) + ':' + tz.substring(3);
        }
    }

    public static class ToString
    extends DateSwap {
        public ToString() {
            super("EEE MMM dd HH:mm:ss zzz yyyy");
        }
    }
}

