/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.PojoSwap;

public class DateLongSwap
extends PojoSwap<Date, Long> {
    @Override
    public Long swap(Date o) {
        return o.getTime();
    }

    @Override
    public Date unswap(Long o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
        Class c;
        Class clazz = c = hint == null ? Date.class : hint.getInnerClass();
        if (c == Date.class) {
            return new Date(o);
        }
        if (c == java.sql.Date.class) {
            return new java.sql.Date(o);
        }
        if (c == Time.class) {
            return new Time(o);
        }
        if (c == Timestamp.class) {
            return new Timestamp(o);
        }
        throw new ParseException("DateLongSwap is unable to narrow object of type ''{0}''", c);
    }
}

