/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.PojoSwap;

public class CalendarSwap
extends PojoSwap<Calendar, String> {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private DateFormat format;
    private TimeZone timeZone;

    public CalendarSwap() {
    }

    public CalendarSwap(String simpleDateFormat) {
        this(new SimpleDateFormat(simpleDateFormat));
    }

    public CalendarSwap(String simpleDateFormat, TimeZone timeZone) {
        this(new SimpleDateFormat(simpleDateFormat));
        this.format.setTimeZone(timeZone);
        this.timeZone = timeZone;
    }

    public CalendarSwap(DateFormat format) {
        this.format = format;
    }

    @Override
    public String swap(Calendar o) {
        DateFormat df = this.format;
        TimeZone tz1 = o.getTimeZone();
        TimeZone tz2 = this.format.getTimeZone();
        if (this.timeZone == null && !tz1.equals(tz2)) {
            df = (DateFormat)this.format.clone();
            df.setTimeZone(tz1);
        }
        return df.format(o.getTime());
    }

    @Override
    public Calendar unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
        try {
            if (StringUtils.isEmpty(o)) {
                return null;
            }
            return CalendarSwap.convert(this.format.parse(o), hint);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static Calendar convert(Calendar in, ClassMeta<?> hint) throws Exception {
        if (hint.isInstance(in) || !hint.canCreateNewInstance()) {
            return in;
        }
        Calendar c = (Calendar)hint.newInstance();
        c.setTime(in.getTime());
        c.setTimeZone(in.getTimeZone());
        return c;
    }

    private static Calendar convert(Date in, ClassMeta<?> hint) throws Exception {
        if (hint == null || !hint.canCreateNewInstance()) {
            hint = BeanContext.DEFAULT.getClassMeta(GregorianCalendar.class);
        }
        Calendar c = (Calendar)hint.newInstance();
        c.setTime(in);
        return c;
    }

    public static class Medium
    extends CalendarSwap {
        public Medium() {
            super(DateFormat.getDateInstance(2));
        }
    }

    public static class Simple
    extends CalendarSwap {
        public Simple() {
            super("yyyy/MM/dd HH:mm:ss");
        }
    }

    public static class RFC2822D
    extends CalendarSwap {
        public RFC2822D() {
            super("dd MMM yyyy");
        }
    }

    public static class RFC2822DTZ
    extends CalendarSwap {
        public RFC2822DTZ() {
            super("EEE, dd MMM yyyy HH:mm:ss 'GMT'", GMT);
        }
    }

    public static class RFC2822DT
    extends CalendarSwap {
        public RFC2822DT() {
            super("EEE, dd MMM yyyy HH:mm:ss Z");
        }
    }

    public static class ISO8601DTZ
    extends CalendarSwap {
        @Override
        public Calendar unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return CalendarSwap.convert(DatatypeConverter.parseDateTime((String)o), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(Calendar o) {
            if (o.getTimeZone().getRawOffset() != 0) {
                Calendar c = Calendar.getInstance(GMT);
                c.setTime(o.getTime());
                o = c;
            }
            return DatatypeConverter.printDateTime((Calendar)o);
        }
    }

    public static class ISO8601DT
    extends CalendarSwap {
        @Override
        public Calendar unswap(String o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
            try {
                if (StringUtils.isEmpty(o)) {
                    return null;
                }
                return CalendarSwap.convert(DatatypeConverter.parseDateTime((String)o), hint);
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }

        @Override
        public String swap(Calendar o) {
            return DatatypeConverter.printDateTime((Calendar)o);
        }
    }

    public static class ToString
    extends CalendarSwap {
        public ToString() {
            super("EEE MMM dd HH:mm:ss zzz yyyy");
        }
    }
}

