/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.PojoSwap;

public class CalendarMapSwap
extends PojoSwap<Calendar, Map> {
    @Override
    public Map swap(Calendar o) {
        ObjectMap m = new ObjectMap();
        m.put("time", o.getTime().getTime());
        m.put("timeZone", o.getTimeZone().getID());
        return m;
    }

    @Override
    public Calendar unswap(Map o, ClassMeta<?> hint, BeanContext bc) throws ParseException {
        try {
            if (hint == null || !hint.canCreateNewInstance()) {
                hint = bc.getClassMeta(GregorianCalendar.class);
            }
            ClassMeta<?> tt = hint;
            long time = Long.parseLong(o.get("time").toString());
            String timeZone = o.get("timeZone").toString();
            Date d = new Date(time);
            Calendar c = (Calendar)tt.newInstance();
            c.setTime(d);
            c.setTimeZone(TimeZone.getTimeZone(timeZone));
            return c;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

