/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;

public abstract class PojoSwap<T, S> {
    private final Class<T> normalClass;
    private final Class<S> swapClass;
    private ClassMeta<S> swapClassMeta;

    protected PojoSwap() {
        ParameterizedType pt;
        Type[] pta;
        Class<?> t_normalClass = null;
        Class t_swapClass = null;
        Type t = this.getClass().getGenericSuperclass();
        for (Class<?> c = this.getClass().getSuperclass(); c != PojoSwap.class; c = c.getSuperclass()) {
            t = c.getGenericSuperclass();
        }
        if (t instanceof ParameterizedType && (pta = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 2) {
            Type nType = pta[0];
            if (nType instanceof Class) {
                t_normalClass = (Class<?>)nType;
            } else if (nType instanceof GenericArrayType) {
                Class cmpntType = (Class)((GenericArrayType)nType).getGenericComponentType();
                t_normalClass = Array.newInstance(cmpntType, 0).getClass();
            } else if (nType instanceof ParameterizedType) {
                t_normalClass = (Class)((ParameterizedType)nType).getRawType();
            } else {
                throw new RuntimeException("Unsupported parameter type: " + nType);
            }
            if (pta[1] instanceof Class) {
                t_swapClass = (Class)pta[1];
            } else if (pta[1] instanceof ParameterizedType) {
                t_swapClass = (Class)((ParameterizedType)pta[1]).getRawType();
            } else {
                throw new RuntimeException("Unexpected transformed class type: " + pta[1].getClass().getName());
            }
        }
        this.normalClass = t_normalClass;
        this.swapClass = t_swapClass;
    }

    protected PojoSwap(Class<T> normalClass, Class<S> swapClass) {
        this.normalClass = normalClass;
        this.swapClass = swapClass;
    }

    public S swap(T o) throws SerializeException {
        throw new SerializeException("Swap method not implemented on PojoSwap ''{0}''", this.getClass().getName());
    }

    public S swap(T o, BeanContext beanContext) throws SerializeException {
        return this.swap(o);
    }

    public T unswap(S f) throws ParseException {
        throw new ParseException("Unswap method not implemented on PojoSwap ''{0}''", this.getClass().getName());
    }

    public T unswap(S f, ClassMeta<?> hint, BeanContext beanContext) throws ParseException {
        return this.unswap(f);
    }

    public Class<T> getNormalClass() {
        return this.normalClass;
    }

    public Class<S> getSwapClass() {
        return this.swapClass;
    }

    public ClassMeta<S> getSwapClassMeta(BeanContext beanContext) {
        if (this.swapClassMeta == null) {
            this.swapClassMeta = beanContext.getClassMeta(this.swapClass);
        }
        return this.swapClassMeta;
    }

    public boolean isNormalObject(Object o) {
        if (o == null) {
            return false;
        }
        return ClassUtils.isParentClass(this.normalClass, o.getClass());
    }

    public boolean isSwappedObject(Object o) {
        if (o == null) {
            return false;
        }
        return ClassUtils.isParentClass(this.swapClass, o.getClass());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '<' + this.getNormalClass().getSimpleName() + "," + this.getSwapClass().getSimpleName() + '>';
    }
}

