/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.transform.BeanFilter;

public abstract class BeanFilterBuilder {
    Class<?> beanClass;
    String typeName;
    String[] properties;
    String[] excludeProperties;
    Class<?> interfaceClass;
    Class<?> stopClass;
    boolean sortProperties;
    PropertyNamer propertyNamer;
    String subTypeProperty;
    Map<Class<?>, String> subTypes;

    public BeanFilterBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanFilterBuilder setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public BeanFilterBuilder setProperties(String ... properties) {
        this.properties = properties;
        return this;
    }

    public BeanFilterBuilder setExcludeProperties(String ... excludeProperties) {
        this.excludeProperties = excludeProperties;
        return this;
    }

    public BeanFilterBuilder setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this;
    }

    public BeanFilterBuilder setStopClass(Class<?> stopClass) {
        this.stopClass = stopClass;
        return this;
    }

    public BeanFilterBuilder setSortProperties(boolean sortProperties) {
        this.sortProperties = sortProperties;
        return this;
    }

    public BeanFilterBuilder setPropertyNamer(PropertyNamer propertyNamer) {
        this.propertyNamer = propertyNamer;
        return this;
    }

    public BeanFilterBuilder setPropertyNamer(Class<? extends PropertyNamer> c) throws Exception {
        this.propertyNamer = c.newInstance();
        return this;
    }

    public BeanFilterBuilder setSubTypeProperty(String subTypeProperty) {
        this.subTypeProperty = subTypeProperty;
        return this;
    }

    public BeanFilterBuilder setSubTypes(Map<Class<?>, String> subTypes) {
        this.subTypes = subTypes;
        return this;
    }

    public BeanFilterBuilder addSubType(String name, Class<?> c) {
        if (this.subTypes == null) {
            this.subTypes = new LinkedHashMap();
        }
        this.subTypes.put(c, name);
        return this;
    }

    public BeanFilter build() {
        return new BeanFilter(this);
    }
}

