/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;

public class BeanFilter {
    private final Class<?> beanClass;
    private final String[] properties;
    private final String[] excludeProperties;
    private final Map<Class<?>, String> subTypes;
    private final String subTypeAttr;
    private final PropertyNamer propertyNamer;
    private final Class<?> interfaceClass;
    private final Class<?> stopClass;
    private final boolean sortProperties;
    private final String typeName;

    BeanFilter(BeanFilterBuilder builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.properties = StringUtils.split(builder.properties, ',');
        this.excludeProperties = StringUtils.split(builder.excludeProperties, ',');
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.propertyNamer = builder.propertyNamer;
        this.subTypeAttr = builder.subTypeProperty;
        this.subTypes = builder.subTypes == null ? null : Collections.unmodifiableMap(builder.subTypes);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public String[] getExcludeProperties() {
        return this.excludeProperties;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public String getSubTypeProperty() {
        return this.subTypeAttr;
    }

    public Map<Class<?>, String> getSubTypes() {
        return this.subTypes;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<?> getStopClass() {
        return this.stopClass;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return value;
    }

    public boolean writeProperty(Object bean, String name, Object value) {
        return false;
    }
}

