/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import java.util.ListIterator;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;

public final class AnnotationBeanFilterBuilder
extends BeanFilterBuilder {
    public AnnotationBeanFilterBuilder(Class<?> annotatedClass, List<Bean> annotations) throws Exception {
        super(annotatedClass);
        ListIterator<Bean> li = annotations.listIterator(annotations.size());
        while (li.hasPrevious()) {
            Bean b = li.previous();
            if (!b.properties().isEmpty()) {
                this.setProperties(StringUtils.split(b.properties(), ','));
            }
            if (!b.typeName().isEmpty()) {
                this.setTypeName(b.typeName());
            }
            if (b.sort()) {
                this.setSortProperties(true);
            }
            if (!b.excludeProperties().isEmpty()) {
                this.setExcludeProperties(StringUtils.split(b.excludeProperties(), ','));
            }
            if (b.propertyNamer() != PropertyNamerDefault.class) {
                this.setPropertyNamer(b.propertyNamer());
            }
            if (b.interfaceClass() != Object.class) {
                this.setInterfaceClass(b.interfaceClass());
            }
            if (b.stopClass() != Object.class) {
                this.setStopClass(b.stopClass());
            }
            if (b.subTypes().length <= 0) continue;
            this.setSubTypeProperty(b.subTypeProperty());
            for (Class<?> bst : b.subTypes()) {
                Bean b2 = bst.getAnnotation(Bean.class);
                String name = null;
                name = !b2.typeName().isEmpty() ? b2.typeName() : bst.getSimpleName();
                this.addSubType(name, bst);
            }
        }
    }
}

