/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.Session;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolverContext;

public class VarResolverSession
extends Session {
    private final Map<String, Object> sessionObjects;
    private final VarResolverContext context;

    public VarResolverSession(VarResolverContext context, Map<String, Object> sessionObjects) {
        super(context);
        this.context = context;
        this.sessionObjects = sessionObjects == null ? new TreeMap() : sessionObjects;
    }

    public VarResolverSession setSessionObject(String name, Object o) {
        this.sessionObjects.put(name, o);
        return this;
    }

    public String resolve(String s) {
        if (s == null) {
            return "";
        }
        if (s.indexOf(36) == -1 && s.indexOf(92) == -1) {
            return s;
        }
        if (this.isSimpleVar(s)) {
            String var = s.substring(1, s.indexOf(123));
            String val = s.substring(s.indexOf(123) + 1, s.length() - 1);
            Var v = this.getVar(var);
            if (v != null) {
                if (v.streamed) {
                    StringWriter sw = new StringWriter();
                    v.resolveTo(this, sw, val);
                    return sw.toString();
                }
                s = v.doResolve(this, val);
                if (s == null) {
                    s = "";
                }
                return this.resolve(s);
            }
            return s;
        }
        try {
            return this.resolveTo(s, new StringWriter()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSimpleVar(String s) {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int length = s.length();
        int state = S1;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c == '$') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c == '{') {
                    state = S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                return false;
            }
            if (state == S3) {
                if (c == '}') {
                    state = S4;
                    continue;
                }
                if (c != '{' && c != '$') continue;
                return false;
            }
            if (state != S4) continue;
            return false;
        }
        return state == S4;
    }

    public Writer resolveTo(String s, Writer out) throws IOException {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int state = S1;
        boolean isInEscape = false;
        boolean hasInternalVar = false;
        boolean hasInnerEscapes = false;
        String varType = null;
        String varVal = null;
        int x = 0;
        int x2 = 0;
        int depth = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (isInEscape) {
                    if (c == '\\' || c == '$') {
                        out.append(c);
                    } else {
                        out.append('\\').append(c);
                    }
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    isInEscape = true;
                    continue;
                }
                if (c == '$') {
                    x = i;
                    x2 = i;
                    state = S2;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (state == S2) {
                if (isInEscape) {
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    hasInnerEscapes = true;
                    isInEscape = true;
                    continue;
                }
                if (c == '{') {
                    varType = s.substring(x + 1, i);
                    x = i;
                    state = S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                if (hasInnerEscapes) {
                    out.append(StringUtils.unEscapeChars(s.substring(x, i + 1), new char[]{'\\', '{'}));
                } else {
                    out.append(s, x, i + 1);
                }
                x = i + 1;
                state = S1;
                hasInnerEscapes = false;
                continue;
            }
            if (state != S3) continue;
            if (isInEscape) {
                isInEscape = false;
                continue;
            }
            if (c == '\\') {
                isInEscape = true;
                hasInnerEscapes = true;
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            varVal = s.substring(x + 1, i);
            varVal = hasInternalVar ? this.resolve(varVal) : varVal;
            Var r = this.getVar(varType);
            if (r == null) {
                if (hasInnerEscapes) {
                    out.append(StringUtils.unEscapeChars(s.substring(x2, i + 1), new char[]{'\\', '$', '{', '}'}));
                } else {
                    out.append(s, x2, i + 1);
                }
                x = i + 1;
            } else {
                if (r.streamed) {
                    r.resolveTo(this, out, varVal);
                } else {
                    String replacement = r.doResolve(this, varVal);
                    if (replacement == null) {
                        replacement = "";
                    }
                    if (replacement.indexOf(36) != -1) {
                        replacement = this.resolve(replacement);
                    }
                    out.append(replacement);
                }
                x = i + 1;
            }
            state = 1;
            hasInnerEscapes = false;
        }
        if (isInEscape) {
            out.append('\\');
        } else if (state == S2) {
            out.append('$').append(StringUtils.unEscapeChars(s.substring(x + 1), new char[]{'{', '\\'}));
        } else if (state == S3) {
            out.append('$').append(varType).append('{').append(StringUtils.unEscapeChars(s.substring(x + 1), new char[]{'\\', '$', '{', '}'}));
        }
        return out;
    }

    public <T> T getSessionObject(Class<T> c, String name) {
        Object t = null;
        try {
            t = this.sessionObjects.get(name);
            if (t == null) {
                this.sessionObjects.put(name, this.context.getContextObject(name));
                t = this.sessionObjects.get(name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Session object ''{0}'' or context object ''SvlContext.{0}'' could not be converted to type ''{1}''.", name, c.getName()));
        }
        if (t == null) {
            throw new RuntimeException(MessageFormat.format("Session object ''{0}'' or context object ''SvlContext.{0}'' not found.", name));
        }
        return (T)t;
    }

    protected Var getVar(String name) {
        return this.context.getVars().get(name);
    }
}

